/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import android.support.annotation.FloatRange;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BaseGeometryTypeAdapter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.CoordinateContainer;
import com.mapbox.geojson.ListOfDoublesCoordinatesTypeAdapter;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import com.mapbox.geojson.shifter.CoordinateShifterManager;
import java.io.IOException;
import java.util.List;

@Keep
public final class Point
implements CoordinateContainer<List<Double>> {
    private static final String TYPE = "Point";
    @NonNull
    private final String type;
    @Nullable
    private final BoundingBox bbox;
    @NonNull
    private final List<Double> coordinates;

    public static Point fromJson(@NonNull String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return (Point)gson.create().fromJson(json, Point.class);
    }

    public static Point fromLngLat(@FloatRange(from=-180.0, to=180.0) double longitude, @FloatRange(from=-90.0, to=90.0) double latitude) {
        List<Double> coordinates = CoordinateShifterManager.getCoordinateShifter().shiftLonLat(longitude, latitude);
        return new Point(TYPE, null, coordinates);
    }

    public static Point fromLngLat(@FloatRange(from=-180.0, to=180.0) double longitude, @FloatRange(from=-90.0, to=90.0) double latitude, @Nullable BoundingBox bbox) {
        List<Double> coordinates = CoordinateShifterManager.getCoordinateShifter().shiftLonLat(longitude, latitude);
        return new Point(TYPE, bbox, coordinates);
    }

    public static Point fromLngLat(@FloatRange(from=-180.0, to=180.0) double longitude, @FloatRange(from=-90.0, to=90.0) double latitude, double altitude) {
        List<Double> coordinates = CoordinateShifterManager.getCoordinateShifter().shiftLonLatAlt(longitude, latitude, altitude);
        return new Point(TYPE, null, coordinates);
    }

    public static Point fromLngLat(@FloatRange(from=-180.0, to=180.0) double longitude, @FloatRange(from=-90.0, to=90.0) double latitude, double altitude, @Nullable BoundingBox bbox) {
        List<Double> coordinates = CoordinateShifterManager.getCoordinateShifter().shiftLonLatAlt(longitude, latitude, altitude);
        return new Point(TYPE, bbox, coordinates);
    }

    static Point fromLngLat(@NonNull double[] coords) {
        if (coords.length == 2) {
            return Point.fromLngLat(coords[0], coords[1]);
        }
        if (coords.length > 2) {
            return Point.fromLngLat(coords[0], coords[1], coords[2]);
        }
        return null;
    }

    Point(String type, @Nullable BoundingBox bbox, List<Double> coordinates) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        this.bbox = bbox;
        if (coordinates == null || coordinates.size() == 0) {
            throw new NullPointerException("Null coordinates");
        }
        this.coordinates = coordinates;
    }

    public double longitude() {
        return (Double)this.coordinates().get(0);
    }

    public double latitude() {
        return (Double)this.coordinates().get(1);
    }

    public double altitude() {
        if (this.coordinates().size() < 3) {
            return Double.NaN;
        }
        return (Double)this.coordinates().get(2);
    }

    public boolean hasAltitude() {
        return !Double.isNaN(this.altitude());
    }

    @Override
    @NonNull
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public BoundingBox bbox() {
        return this.bbox;
    }

    @Override
    @NonNull
    public List<Double> coordinates() {
        return this.coordinates;
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gson.create().toJson((Object)this);
    }

    public static TypeAdapter<Point> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    public String toString() {
        return "Point{type=" + this.type + ", bbox=" + this.bbox + ", coordinates=" + this.coordinates + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Point) {
            Point that = (Point)obj;
            return this.type.equals(that.type()) && (this.bbox == null ? that.bbox() == null : this.bbox.equals(that.bbox())) && this.coordinates.equals(that.coordinates());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= 1000003;
        hashCode ^= this.type.hashCode();
        hashCode *= 1000003;
        hashCode ^= this.bbox == null ? 0 : this.bbox.hashCode();
        hashCode *= 1000003;
        return hashCode ^= this.coordinates.hashCode();
    }

    static final class GsonTypeAdapter
    extends BaseGeometryTypeAdapter<Point, List<Double>> {
        GsonTypeAdapter(Gson gson) {
            super(gson, new ListOfDoublesCoordinatesTypeAdapter());
        }

        public void write(JsonWriter jsonWriter, Point object) throws IOException {
            this.writeCoordinateContainer(jsonWriter, object);
        }

        public Point read(JsonReader jsonReader) throws IOException {
            return (Point)this.readCoordinateContainer(jsonReader);
        }

        @Override
        CoordinateContainer<List<Double>> createCoordinateContainer(String type, BoundingBox bbox, List<Double> coordinates) {
            return new Point(type == null ? Point.TYPE : type, bbox, coordinates);
        }
    }
}

