/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson.gson;

import android.support.annotation.Keep;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.exception.GeoJsonException;
import com.mapbox.geojson.shifter.CoordinateShifterManager;
import com.mapbox.geojson.utils.GeoJsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Keep
public class BoundingBoxTypeAdapter
extends TypeAdapter<BoundingBox> {
    public void write(JsonWriter out, BoundingBox value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        Point point = value.southwest();
        List<Double> unshiftedCoordinates = CoordinateShifterManager.getCoordinateShifter().unshiftPoint(point);
        out.value(GeoJsonUtils.trim(unshiftedCoordinates.get(0)));
        out.value(GeoJsonUtils.trim(unshiftedCoordinates.get(1)));
        if (point.hasAltitude()) {
            out.value((Number)unshiftedCoordinates.get(2));
        }
        point = value.northeast();
        unshiftedCoordinates = CoordinateShifterManager.getCoordinateShifter().unshiftPoint(point);
        out.value(GeoJsonUtils.trim(unshiftedCoordinates.get(0)));
        out.value(GeoJsonUtils.trim(unshiftedCoordinates.get(1)));
        if (point.hasAltitude()) {
            out.value((Number)unshiftedCoordinates.get(2));
        }
        out.endArray();
    }

    public BoundingBox read(JsonReader in) throws IOException {
        ArrayList<Double> rawCoordinates = new ArrayList<Double>();
        in.beginArray();
        while (in.hasNext()) {
            rawCoordinates.add(in.nextDouble());
        }
        in.endArray();
        if (rawCoordinates.size() == 6) {
            return BoundingBox.fromLngLats((Double)rawCoordinates.get(0), (Double)rawCoordinates.get(1), (Double)rawCoordinates.get(2), (Double)rawCoordinates.get(3), (Double)rawCoordinates.get(4), (Double)rawCoordinates.get(5));
        }
        if (rawCoordinates.size() == 4) {
            return BoundingBox.fromLngLats((Double)rawCoordinates.get(0), (Double)rawCoordinates.get(1), (Double)rawCoordinates.get(2), (Double)rawCoordinates.get(3));
        }
        throw new GeoJsonException("The value of the bbox member MUST be an array of length 2*n where n is the number of dimensions represented in the contained geometries,with all axes of the most southwesterly point followed  by all axes of the more northeasterly point. The axes order of a bbox follows the axes order of geometries.");
    }
}

