/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BaseGeometryTypeAdapter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.CoordinateContainer;
import com.mapbox.geojson.ListofListofListOfPointCoordinatesTypeAdapter;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@Keep
public final class MultiPolygon
implements CoordinateContainer<List<List<List<Point>>>> {
    private static final String TYPE = "MultiPolygon";
    private final String type;
    private final BoundingBox bbox;
    private final List<List<List<Point>>> coordinates;

    public static MultiPolygon fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return (MultiPolygon)gson.create().fromJson(json, MultiPolygon.class);
    }

    public static MultiPolygon fromPolygons(@NonNull List<Polygon> polygons) {
        ArrayList<List<List<Point>>> coordinates = new ArrayList<List<List<Point>>>(polygons.size());
        for (Polygon polygon : polygons) {
            coordinates.add((List<List<Point>>)polygon.coordinates());
        }
        return new MultiPolygon(TYPE, null, coordinates);
    }

    public static MultiPolygon fromPolygons(@NonNull List<Polygon> polygons, @Nullable BoundingBox bbox) {
        ArrayList<List<List<Point>>> coordinates = new ArrayList<List<List<Point>>>(polygons.size());
        for (Polygon polygon : polygons) {
            coordinates.add((List<List<Point>>)polygon.coordinates());
        }
        return new MultiPolygon(TYPE, bbox, coordinates);
    }

    public static MultiPolygon fromPolygon(@NonNull Polygon polygon) {
        List<List<List<Point>>> coordinates = Arrays.asList(polygon.coordinates());
        return new MultiPolygon(TYPE, null, coordinates);
    }

    public static MultiPolygon fromPolygon(@NonNull Polygon polygon, @Nullable BoundingBox bbox) {
        List<List<List<Point>>> coordinates = Arrays.asList(polygon.coordinates());
        return new MultiPolygon(TYPE, bbox, coordinates);
    }

    public static MultiPolygon fromLngLats(@NonNull List<List<List<Point>>> points) {
        return new MultiPolygon(TYPE, null, points);
    }

    public static MultiPolygon fromLngLats(@NonNull List<List<List<Point>>> points, @Nullable BoundingBox bbox) {
        return new MultiPolygon(TYPE, bbox, points);
    }

    static MultiPolygon fromLngLats(@NonNull double[][][][] coordinates) {
        ArrayList<List<List<Point>>> converted = new ArrayList<List<List<Point>>>(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            ArrayList innerOneList = new ArrayList(coordinates[i].length);
            for (int j = 0; j < coordinates[i].length; ++j) {
                ArrayList<Point> innerTwoList = new ArrayList<Point>(coordinates[i][j].length);
                for (int k = 0; k < coordinates[i][j].length; ++k) {
                    innerTwoList.add(Point.fromLngLat(coordinates[i][j][k]));
                }
                innerOneList.add(innerTwoList);
            }
            converted.add(innerOneList);
        }
        return new MultiPolygon(TYPE, null, converted);
    }

    MultiPolygon(String type, @Nullable BoundingBox bbox, List<List<List<Point>>> coordinates) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        this.bbox = bbox;
        if (coordinates == null) {
            throw new NullPointerException("Null coordinates");
        }
        this.coordinates = coordinates;
    }

    public List<Polygon> polygons() {
        Object coordinates = this.coordinates();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(coordinates.size());
        Iterator iterator = coordinates.iterator();
        while (iterator.hasNext()) {
            List points = (List)iterator.next();
            polygons.add(Polygon.fromLngLats(points));
        }
        return polygons;
    }

    @Override
    @NonNull
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public BoundingBox bbox() {
        return this.bbox;
    }

    @Override
    @NonNull
    public List<List<List<Point>>> coordinates() {
        return this.coordinates;
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gson.create().toJson((Object)this);
    }

    public static TypeAdapter<MultiPolygon> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    public String toString() {
        return "Polygon{type=" + this.type + ", bbox=" + this.bbox + ", coordinates=" + this.coordinates + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MultiPolygon) {
            MultiPolygon that = (MultiPolygon)obj;
            return this.type.equals(that.type()) && (this.bbox == null ? that.bbox() == null : this.bbox.equals(that.bbox())) && this.coordinates.equals(that.coordinates());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= 1000003;
        hashCode ^= this.type.hashCode();
        hashCode *= 1000003;
        hashCode ^= this.bbox == null ? 0 : this.bbox.hashCode();
        hashCode *= 1000003;
        return hashCode ^= this.coordinates.hashCode();
    }

    static final class GsonTypeAdapter
    extends BaseGeometryTypeAdapter<MultiPolygon, List<List<List<Point>>>> {
        GsonTypeAdapter(Gson gson) {
            super(gson, new ListofListofListOfPointCoordinatesTypeAdapter());
        }

        public void write(JsonWriter jsonWriter, MultiPolygon object) throws IOException {
            this.writeCoordinateContainer(jsonWriter, object);
        }

        public MultiPolygon read(JsonReader jsonReader) throws IOException {
            return (MultiPolygon)this.readCoordinateContainer(jsonReader);
        }

        @Override
        CoordinateContainer<List<List<List<Point>>>> createCoordinateContainer(String type, BoundingBox bbox, List<List<List<Point>>> coords) {
            return new MultiPolygon(type == null ? MultiPolygon.TYPE : type, bbox, coords);
        }
    }
}

