

package com.mapbox.api.directionsrefresh.v1;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MapboxDirectionsRefresh extends MapboxDirectionsRefresh {

  private final String requestId;

  private final int routeIndex;

  private final int legIndex;

  private final String accessToken;

  private final String clientAppName;

  private final String baseUrl;

  private AutoValue_MapboxDirectionsRefresh(
      String requestId,
      int routeIndex,
      int legIndex,
      String accessToken,
      @Nullable String clientAppName,
      String baseUrl) {
    this.requestId = requestId;
    this.routeIndex = routeIndex;
    this.legIndex = legIndex;
    this.accessToken = accessToken;
    this.clientAppName = clientAppName;
    this.baseUrl = baseUrl;
  }

  @Override
  String requestId() {
    return requestId;
  }

  @Override
  int routeIndex() {
    return routeIndex;
  }

  @Override
  int legIndex() {
    return legIndex;
  }

  @Override
  String accessToken() {
    return accessToken;
  }

  @Nullable
  @Override
  String clientAppName() {
    return clientAppName;
  }

  @NonNull
  @Override
  protected String baseUrl() {
    return baseUrl;
  }

  @Override
  public String toString() {
    return "MapboxDirectionsRefresh{"
         + "requestId=" + requestId + ", "
         + "routeIndex=" + routeIndex + ", "
         + "legIndex=" + legIndex + ", "
         + "accessToken=" + accessToken + ", "
         + "clientAppName=" + clientAppName + ", "
         + "baseUrl=" + baseUrl
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MapboxDirectionsRefresh) {
      MapboxDirectionsRefresh that = (MapboxDirectionsRefresh) o;
      return (this.requestId.equals(that.requestId()))
           && (this.routeIndex == that.routeIndex())
           && (this.legIndex == that.legIndex())
           && (this.accessToken.equals(that.accessToken()))
           && ((this.clientAppName == null) ? (that.clientAppName() == null) : this.clientAppName.equals(that.clientAppName()))
           && (this.baseUrl.equals(that.baseUrl()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= requestId.hashCode();
    h$ *= 1000003;
    h$ ^= routeIndex;
    h$ *= 1000003;
    h$ ^= legIndex;
    h$ *= 1000003;
    h$ ^= accessToken.hashCode();
    h$ *= 1000003;
    h$ ^= (clientAppName == null) ? 0 : clientAppName.hashCode();
    h$ *= 1000003;
    h$ ^= baseUrl.hashCode();
    return h$;
  }

  @Override
  public MapboxDirectionsRefresh.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends MapboxDirectionsRefresh.Builder {
    private String requestId;
    private Integer routeIndex;
    private Integer legIndex;
    private String accessToken;
    private String clientAppName;
    private String baseUrl;
    Builder() {
    }
    private Builder(MapboxDirectionsRefresh source) {
      this.requestId = source.requestId();
      this.routeIndex = source.routeIndex();
      this.legIndex = source.legIndex();
      this.accessToken = source.accessToken();
      this.clientAppName = source.clientAppName();
      this.baseUrl = source.baseUrl();
    }
    @Override
    public MapboxDirectionsRefresh.Builder requestId(String requestId) {
      if (requestId == null) {
        throw new NullPointerException("Null requestId");
      }
      this.requestId = requestId;
      return this;
    }
    @Override
    public MapboxDirectionsRefresh.Builder routeIndex(int routeIndex) {
      this.routeIndex = routeIndex;
      return this;
    }
    @Override
    public MapboxDirectionsRefresh.Builder legIndex(int legIndex) {
      this.legIndex = legIndex;
      return this;
    }
    @Override
    public MapboxDirectionsRefresh.Builder accessToken(String accessToken) {
      if (accessToken == null) {
        throw new NullPointerException("Null accessToken");
      }
      this.accessToken = accessToken;
      return this;
    }
    @Override
    public MapboxDirectionsRefresh.Builder clientAppName(String clientAppName) {
      this.clientAppName = clientAppName;
      return this;
    }
    @Override
    public MapboxDirectionsRefresh.Builder baseUrl(String baseUrl) {
      if (baseUrl == null) {
        throw new NullPointerException("Null baseUrl");
      }
      this.baseUrl = baseUrl;
      return this;
    }
    @Override
    public MapboxDirectionsRefresh build() {
      String missing = "";
      if (this.requestId == null) {
        missing += " requestId";
      }
      if (this.routeIndex == null) {
        missing += " routeIndex";
      }
      if (this.legIndex == null) {
        missing += " legIndex";
      }
      if (this.accessToken == null) {
        missing += " accessToken";
      }
      if (this.baseUrl == null) {
        missing += " baseUrl";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MapboxDirectionsRefresh(
          this.requestId,
          this.routeIndex,
          this.legIndex,
          this.accessToken,
          this.clientAppName,
          this.baseUrl);
    }
  }

}
