/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.turf;

import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.MultiPolygon;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import java.util.ArrayList;
import java.util.List;

public final class TurfJoins {
    private TurfJoins() {
    }

    public static boolean inside(Point point, Polygon polygon) {
        List coordinates = polygon.coordinates();
        ArrayList<List> multiCoordinates = new ArrayList<List>();
        multiCoordinates.add(coordinates);
        return TurfJoins.inside(point, MultiPolygon.fromLngLats(multiCoordinates));
    }

    public static boolean inside(Point point, MultiPolygon multiPolygon) {
        List polys = multiPolygon.coordinates();
        boolean insidePoly = false;
        for (int i = 0; i < polys.size() && !insidePoly; ++i) {
            if (!TurfJoins.inRing(point, (List)((List)polys.get(i)).get(0))) continue;
            boolean inHole = false;
            for (int temp = 1; temp < ((List)polys.get(i)).size() && !inHole; ++temp) {
                if (!TurfJoins.inRing(point, (List)((List)polys.get(i)).get(temp))) continue;
                inHole = true;
            }
            if (inHole) continue;
            insidePoly = true;
        }
        return insidePoly;
    }

    public static FeatureCollection pointsWithinPolygon(FeatureCollection points, FeatureCollection polygons) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < polygons.features().size(); ++i) {
            for (int j = 0; j < points.features().size(); ++j) {
                Point point = (Point)((Feature)points.features().get(j)).geometry();
                boolean isInside = TurfJoins.inside(point, (Polygon)((Feature)polygons.features().get(i)).geometry());
                if (!isInside) continue;
                features.add(Feature.fromGeometry((Geometry)point));
            }
        }
        return FeatureCollection.fromFeatures(features);
    }

    private static boolean inRing(Point pt, List<Point> ring) {
        boolean isInside = false;
        int i = 0;
        int j = ring.size() - 1;
        while (i < ring.size()) {
            boolean intersect;
            double xi = ring.get(i).longitude();
            double yi = ring.get(i).latitude();
            double xj = ring.get(j).longitude();
            double yj = ring.get(j).latitude();
            boolean bl = intersect = yi > pt.latitude() != yj > pt.latitude() && pt.longitude() < (xj - xi) * (pt.latitude() - yi) / (yj - yi) + xi;
            if (intersect) {
                isInside = !isInside;
            }
            j = i++;
        }
        return isInside;
    }
}

