/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.turf;

import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.turf.TurfException;
import com.mapbox.turf.TurfMeasurement;
import com.mapbox.turf.models.LineIntersectsResult;
import java.util.ArrayList;
import java.util.List;

public final class TurfMisc {
    private static final String INDEX_KEY = "index";

    private TurfMisc() {
        throw new AssertionError((Object)"No Instances.");
    }

    @NonNull
    public static LineString lineSlice(@NonNull Point startPt, @NonNull Point stopPt, @NonNull Feature line) {
        if (line.geometry() == null) {
            throw new NullPointerException("Feature.geometry() == null");
        }
        if (!line.geometry().type().equals("LineString")) {
            throw new TurfException("input must be a LineString Feature or Geometry");
        }
        return TurfMisc.lineSlice(startPt, stopPt, (LineString)line.geometry());
    }

    @NonNull
    public static LineString lineSlice(@NonNull Point startPt, @NonNull Point stopPt, @NonNull LineString line) {
        List coords = line.coordinates();
        if (coords.size() < 2) {
            throw new TurfException("Turf lineSlice requires a LineString made up of at least 2 coordinates.");
        }
        if (startPt.equals((Object)stopPt)) {
            throw new TurfException("Start and stop points in Turf lineSlice cannot equal each other.");
        }
        Feature startVertex = TurfMisc.nearestPointOnLine(startPt, coords);
        Feature stopVertex = TurfMisc.nearestPointOnLine(stopPt, coords);
        ArrayList<Feature> ends = new ArrayList<Feature>();
        if ((Integer)startVertex.getNumberProperty(INDEX_KEY) <= (Integer)stopVertex.getNumberProperty(INDEX_KEY)) {
            ends.add(startVertex);
            ends.add(stopVertex);
        } else {
            ends.add(stopVertex);
            ends.add(startVertex);
        }
        ArrayList<Object> points = new ArrayList<Object>();
        points.add((Point)((Feature)ends.get(0)).geometry());
        for (int i = (Integer)((Feature)ends.get(0)).getNumberProperty(INDEX_KEY) + 1; i < (Integer)((Feature)ends.get(1)).getNumberProperty(INDEX_KEY) + 1; ++i) {
            points.add(coords.get(i));
        }
        points.add((Point)((Feature)ends.get(1)).geometry());
        return LineString.fromLngLats(points);
    }

    @NonNull
    public static LineString lineSliceAlong(@NonNull Feature line, @FloatRange(from=0.0) double startDist, @FloatRange(from=0.0) double stopDist, @NonNull String units) {
        if (line.geometry() == null) {
            throw new NullPointerException("Feature.geometry() == null");
        }
        if (!line.geometry().type().equals("LineString")) {
            throw new TurfException("input must be a LineString Feature or Geometry");
        }
        return TurfMisc.lineSliceAlong((LineString)line.geometry(), startDist, stopDist, units);
    }

    @NonNull
    public static LineString lineSliceAlong(@NonNull LineString line, @FloatRange(from=0.0) double startDist, @FloatRange(from=0.0) double stopDist, @NonNull String units) {
        List coords = line.coordinates();
        if (coords.size() < 2) {
            throw new TurfException("Turf lineSlice requires a LineString Geometry made up of at least 2 coordinates. The LineString passed in only contains " + coords.size() + ".");
        }
        if (startDist == stopDist) {
            throw new TurfException("Start and stop distance in Turf lineSliceAlong cannot equal each other.");
        }
        ArrayList slice = new ArrayList(2);
        double travelled = 0.0;
        for (int i = 0; !(i >= coords.size() || startDist >= travelled && i == coords.size() - 1); travelled += TurfMeasurement.distance((Point)coords.get(i), (Point)coords.get(i + 1), units), ++i) {
            Point interpolated;
            double direction;
            double overshot;
            if (travelled > startDist && slice.size() == 0) {
                overshot = startDist - travelled;
                if (overshot == 0.0) {
                    slice.add(coords.get(i));
                    return LineString.fromLngLats(slice);
                }
                direction = TurfMeasurement.bearing((Point)coords.get(i), (Point)coords.get(i - 1)) - 180.0;
                interpolated = TurfMeasurement.destination((Point)coords.get(i), overshot, direction, units);
                slice.add(interpolated);
            }
            if (travelled >= stopDist) {
                overshot = stopDist - travelled;
                if (overshot == 0.0) {
                    slice.add(coords.get(i));
                    return LineString.fromLngLats(slice);
                }
                direction = TurfMeasurement.bearing((Point)coords.get(i), (Point)coords.get(i - 1)) - 180.0;
                interpolated = TurfMeasurement.destination((Point)coords.get(i), overshot, direction, units);
                slice.add(interpolated);
                return LineString.fromLngLats(slice);
            }
            if (travelled >= startDist) {
                slice.add(coords.get(i));
            }
            if (i != coords.size() - 1) continue;
            return LineString.fromLngLats(slice);
        }
        if (travelled < startDist) {
            throw new TurfException("Start position is beyond line");
        }
        return LineString.fromLngLats(slice);
    }

    @NonNull
    public static Feature nearestPointOnLine(@NonNull Point pt, @NonNull List<Point> coords) {
        return TurfMisc.nearestPointOnLine(pt, coords, null);
    }

    @NonNull
    public static Feature nearestPointOnLine(@NonNull Point pt, @NonNull List<Point> coords, @Nullable String units) {
        if (coords.size() < 2) {
            throw new TurfException("Turf nearestPointOnLine requires a List of Points made up of at least 2 coordinates.");
        }
        if (units == null) {
            units = "kilometers";
        }
        Feature closestPt = Feature.fromGeometry((Geometry)Point.fromLngLat((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY));
        closestPt.addNumberProperty("dist", (Number)Double.POSITIVE_INFINITY);
        for (int i = 0; i < coords.size() - 1; ++i) {
            Feature start = Feature.fromGeometry((Geometry)((Geometry)coords.get(i)));
            Feature stop = Feature.fromGeometry((Geometry)((Geometry)coords.get(i + 1)));
            start.addNumberProperty("dist", (Number)TurfMeasurement.distance(pt, (Point)start.geometry(), units));
            stop.addNumberProperty("dist", (Number)TurfMeasurement.distance(pt, (Point)stop.geometry(), units));
            double heightDistance = Math.max(start.properties().get("dist").getAsDouble(), stop.properties().get("dist").getAsDouble());
            double direction = TurfMeasurement.bearing((Point)start.geometry(), (Point)stop.geometry());
            Feature perpendicularPt1 = Feature.fromGeometry((Geometry)TurfMeasurement.destination(pt, heightDistance, direction + 90.0, units));
            Feature perpendicularPt2 = Feature.fromGeometry((Geometry)TurfMeasurement.destination(pt, heightDistance, direction - 90.0, units));
            LineIntersectsResult intersect = TurfMisc.lineIntersects(((Point)perpendicularPt1.geometry()).longitude(), ((Point)perpendicularPt1.geometry()).latitude(), ((Point)perpendicularPt2.geometry()).longitude(), ((Point)perpendicularPt2.geometry()).latitude(), ((Point)start.geometry()).longitude(), ((Point)start.geometry()).latitude(), ((Point)stop.geometry()).longitude(), ((Point)stop.geometry()).latitude());
            Feature intersectPt = null;
            if (intersect != null) {
                intersectPt = Feature.fromGeometry((Geometry)Point.fromLngLat((double)intersect.horizontalIntersection(), (double)intersect.verticalIntersection()));
                intersectPt.addNumberProperty("dist", (Number)TurfMeasurement.distance(pt, (Point)intersectPt.geometry(), units));
            }
            if ((Double)start.getNumberProperty("dist") < (Double)closestPt.getNumberProperty("dist")) {
                closestPt = start;
                closestPt.addNumberProperty(INDEX_KEY, (Number)i);
            }
            if ((Double)stop.getNumberProperty("dist") < (Double)closestPt.getNumberProperty("dist")) {
                closestPt = stop;
                closestPt.addNumberProperty(INDEX_KEY, (Number)i);
            }
            if (intersectPt == null || !((Double)intersectPt.getNumberProperty("dist") < (Double)closestPt.getNumberProperty("dist"))) continue;
            closestPt = intersectPt;
            closestPt.addNumberProperty(INDEX_KEY, (Number)i);
        }
        return closestPt;
    }

    private static LineIntersectsResult lineIntersects(double line1StartX, double line1StartY, double line1EndX, double line1EndY, double line2StartX, double line2StartY, double line2EndX, double line2EndY) {
        LineIntersectsResult result = LineIntersectsResult.builder().onLine1(false).onLine2(false).build();
        double denominator = (line2EndY - line2StartY) * (line1EndX - line1StartX) - (line2EndX - line2StartX) * (line1EndY - line1StartY);
        if (denominator == 0.0) {
            if (result.horizontalIntersection() != null && result.verticalIntersection() != null) {
                return result;
            }
            return null;
        }
        double varA = line1StartY - line2StartY;
        double varB = line1StartX - line2StartX;
        double numerator1 = (line2EndX - line2StartX) * varA - (line2EndY - line2StartY) * varB;
        double numerator2 = (line1EndX - line1StartX) * varA - (line1EndY - line1StartY) * varB;
        varA = numerator1 / denominator;
        varB = numerator2 / denominator;
        result = result.toBuilder().horizontalIntersection(line1StartX + varA * (line1EndX - line1StartX)).build();
        result = result.toBuilder().verticalIntersection(line1StartY + varA * (line1EndY - line1StartY)).build();
        if (varA > 0.0 && varA < 1.0) {
            result = result.toBuilder().onLine1(true).build();
        }
        if (varB > 0.0 && varB < 1.0) {
            result = result.toBuilder().onLine2(true).build();
        }
        if (result.onLine1() && result.onLine2()) {
            return result;
        }
        return null;
    }
}

