/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.api;

import com.mapzen.android.lost.internal.ParcelableGeofence;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;
    public static final int LOITERING_DELAY_NONE = -1;

    public String getRequestId();

    public static final class Builder {
        private String requestId;
        private double latitude;
        private double longitude;
        private float radius;
        private long durationMillis = -1L;
        private int transitionTypes;
        private int loiteringDelayMs = -1;

        public Geofence build() {
            return new ParcelableGeofence(this.requestId, this.latitude, this.longitude, this.radius, this.durationMillis, this.transitionTypes, this.loiteringDelayMs);
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.latitude = latitude;
            this.longitude = longitude;
            this.radius = radius;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public Builder setLoiteringDelay(int loiteringDelayMs) {
            this.loiteringDelayMs = loiteringDelayMs;
            return this;
        }

        public Builder setNotificationResponsiveness(int notificationResponsivenessMs) {
            throw new RuntimeException("Sorry, not yet implemented");
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.transitionTypes = transitionTypes;
            return this;
        }
    }
}

