/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.api;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Parcelable;
import com.mapzen.android.lost.api.Geofence;
import com.mapzen.android.lost.api.GeofencingApi;
import com.mapzen.android.lost.internal.FusionEngine;
import com.mapzen.android.lost.internal.GeofenceIntentHelper;
import com.mapzen.android.lost.internal.GeofencingApiImpl;
import com.mapzen.android.lost.internal.ParcelableGeofence;
import java.util.ArrayList;

public class GeofencingIntentSender {
    private Context context;
    private FusionEngine engine;
    private GeofencingApiImpl geofencingApi;
    private GeofenceIntentHelper intentHelper;

    public GeofencingIntentSender(Context context, GeofencingApi geofencingApi) {
        this.context = context;
        this.geofencingApi = (GeofencingApiImpl)geofencingApi;
        this.engine = new FusionEngine(context, null);
        this.intentHelper = new GeofenceIntentHelper();
    }

    public void sendIntent(Intent intent) {
        if (!this.shouldSendIntent(intent)) {
            return;
        }
        Intent toSend = this.generateIntent(intent, this.engine.getLastLocation());
        int intentId = this.intentHelper.extractIntentId(intent);
        PendingIntent pendingIntent = this.geofencingApi.pendingIntentForIntentId(intentId);
        try {
            pendingIntent.send(this.context, 0, toSend);
        }
        catch (PendingIntent.CanceledException e) {
            e.printStackTrace();
        }
    }

    public boolean shouldSendIntent(Intent intent) {
        int transition = this.intentHelper.transitionForIntent(intent);
        int intentId = this.intentHelper.extractIntentId(intent);
        ParcelableGeofence geofence = (ParcelableGeofence)this.geofencingApi.geofenceForIntentId(intentId);
        return (geofence.getTransitionTypes() & transition) != 0;
    }

    public Intent generateIntent(Intent intent, Location location) {
        int intentId = this.intentHelper.extractIntentId(intent);
        Geofence geofence = this.geofencingApi.geofenceForIntentId(intentId);
        ArrayList<Geofence> geofences = new ArrayList<Geofence>();
        geofences.add(geofence);
        Intent toSend = new Intent();
        toSend.putExtra("com.mapzen.lost.extra.transition", this.intentHelper.transitionForIntent(intent));
        toSend.putExtra("com.mapzen.lost.extra.geofence_list", geofences);
        toSend.putExtra("com.mapzen.lost.extra.triggering_location", (Parcelable)location);
        return toSend;
    }
}

