/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.api;

import com.mapzen.android.lost.api.Geofence;
import java.util.ArrayList;
import java.util.List;

public class GeofencingRequest {
    private List<Geofence> geofences;

    private GeofencingRequest(List<Geofence> geofences) {
        this.geofences = geofences;
    }

    public List<Geofence> getGeofences() {
        return this.geofences;
    }

    public static final class Builder {
        private List<Geofence> geofences = new ArrayList<Geofence>();

        public GeofencingRequest build() {
            if (this.geofences.isEmpty()) {
                throw new IllegalArgumentException("No geofence has been added to this request.");
            }
            return new GeofencingRequest(this.geofences);
        }

        public Builder addGeofence(Geofence geofence) {
            if (geofence == null) {
                throw new IllegalArgumentException("Geofence cannot be null");
            }
            this.geofences.add(geofence);
            return this;
        }

        public Builder addGeofences(List<Geofence> geofences) {
            if (geofences == null) {
                throw new IllegalArgumentException("Geofence cannot be null");
            }
            this.geofences.addAll(geofences);
            return this;
        }
    }
}

