/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.api;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import com.mapzen.android.lost.internal.PidReader;

public final class LocationRequest
implements Parcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    static final long DEFAULT_INTERVAL_IN_MS = 3600000L;
    static final long DEFAULT_FASTEST_INTERVAL_IN_MS = 600000L;
    static final float DEFAULT_SMALLEST_DISPLACEMENT_IN_METERS = 0.0f;
    private long interval = 3600000L;
    private long fastestInterval = 600000L;
    private float smallestDisplacement = 0.0f;
    private int priority = 102;
    private PidReader pidReader = new PidReader(){

        @Override
        public long getPid() {
            return Process.myPid();
        }
    };
    long pid;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new Parcelable.Creator<LocationRequest>(){

        public LocationRequest createFromParcel(Parcel source) {
            return new LocationRequest(source);
        }

        public LocationRequest[] newArray(int size) {
            return new LocationRequest[size];
        }
    };

    private LocationRequest() {
        this.commonInit();
    }

    private LocationRequest(PidReader reader) {
        this.pidReader = reader;
        this.commonInit();
    }

    private void commonInit() {
        this.pid = this.pidReader.getPid();
    }

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public static LocationRequest create(PidReader reader) {
        return new LocationRequest(reader);
    }

    public LocationRequest(LocationRequest incoming) {
        this.setInterval(incoming.getInterval());
        this.setFastestInterval(incoming.getFastestInterval());
        this.setSmallestDisplacement(incoming.getSmallestDisplacement());
        this.setPriority(incoming.getPriority());
        this.pid = incoming.pid;
    }

    public long getInterval() {
        return this.interval;
    }

    public LocationRequest setInterval(long millis) {
        this.interval = millis;
        if (this.interval < this.fastestInterval) {
            this.fastestInterval = this.interval;
        }
        return this;
    }

    public long getFastestInterval() {
        return this.fastestInterval;
    }

    public LocationRequest setFastestInterval(long millis) {
        this.fastestInterval = millis;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.smallestDisplacement;
    }

    public LocationRequest setSmallestDisplacement(float meters) {
        this.smallestDisplacement = meters;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public LocationRequest setPriority(int priority) {
        if (priority != 100 && priority != 102 && priority != 104 && priority != 105) {
            throw new IllegalArgumentException("Invalid priority: " + priority);
        }
        this.priority = priority;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationRequest that = (LocationRequest)o;
        if (this.pid != that.pid) {
            return false;
        }
        if (this.interval != that.interval) {
            return false;
        }
        if (this.fastestInterval != that.fastestInterval) {
            return false;
        }
        if (Float.compare(that.smallestDisplacement, this.smallestDisplacement) != 0) {
            return false;
        }
        return this.priority == that.priority;
    }

    public int hashCode() {
        int result = (int)(this.interval ^ this.interval >>> 32);
        result = 31 * result + (int)(this.fastestInterval ^ this.fastestInterval >>> 32);
        result = 31 * result + (this.smallestDisplacement != 0.0f ? Float.floatToIntBits(this.smallestDisplacement) : 0);
        result = 31 * result + this.priority;
        result = 31 * result + (int)this.pid;
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.interval);
        dest.writeLong(this.fastestInterval);
        dest.writeFloat(this.smallestDisplacement);
        dest.writeInt(this.priority);
        dest.writeLong(this.pid);
    }

    protected LocationRequest(Parcel in) {
        this.interval = in.readLong();
        this.fastestInterval = in.readLong();
        this.smallestDisplacement = in.readFloat();
        this.priority = in.readInt();
        this.pid = in.readLong();
    }
}

