/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.api;

import android.content.Intent;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class LocationResult
implements Parcelable {
    public static final String EXTRA_LOCATION_RESULT = "com.mapzen.android.lost.EXTRA_LOCATION_RESULT";
    private final List<Location> locations;
    public static final Parcelable.Creator<LocationResult> CREATOR = new Parcelable.Creator<LocationResult>(){

        public LocationResult createFromParcel(Parcel in) {
            return new LocationResult(in);
        }

        public LocationResult[] newArray(int size) {
            return new LocationResult[size];
        }
    };

    public static LocationResult create(List<Location> locations) {
        if (locations == null) {
            locations = Collections.emptyList();
        }
        return new LocationResult(locations);
    }

    LocationResult(List<Location> locations) {
        this.locations = locations;
    }

    @NonNull
    public List<Location> getLocations() {
        return this.locations;
    }

    public Location getLastLocation() {
        if (this.locations.size() == 0) {
            return null;
        }
        return this.locations.get(this.locations.size() - 1);
    }

    public static boolean hasResult(Intent intent) {
        return intent != null && intent.hasExtra(EXTRA_LOCATION_RESULT);
    }

    public static LocationResult extractResult(Intent intent) {
        if (!LocationResult.hasResult(intent)) {
            return null;
        }
        return (LocationResult)intent.getParcelableExtra(EXTRA_LOCATION_RESULT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationResult that = (LocationResult)o;
        if (this.locations.size() != that.locations.size()) {
            return false;
        }
        Iterator<Location> thisIterator = this.locations.iterator();
        Iterator<Location> thatIterator = that.locations.iterator();
        while (thisIterator.hasNext()) {
            if (thisIterator.next().getTime() == thatIterator.next().getTime()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.locations.hashCode();
    }

    protected LocationResult(Parcel in) {
        this.locations = in.createTypedArrayList(Location.CREATOR);
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.locations);
    }

    public int describeContents() {
        return 0;
    }
}

