/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.api;

import android.content.Context;
import com.mapzen.android.lost.internal.LostApiClientImpl;
import com.mapzen.android.lost.internal.LostClientManager;
import java.lang.ref.WeakReference;

public interface LostApiClient {
    public void connect();

    public void disconnect();

    public boolean isConnected();

    public void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public static final class Builder {
        private final Context context;
        private WeakReference<ConnectionCallbacks> connectionCallbacks;

        public Builder(Context context) {
            this.context = context.getApplicationContext();
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks callbacks) {
            this.connectionCallbacks = new WeakReference<ConnectionCallbacks>(callbacks);
            return this;
        }

        public LostApiClient build() {
            ConnectionCallbacks callbacks = null;
            if (this.connectionCallbacks != null) {
                callbacks = (ConnectionCallbacks)this.connectionCallbacks.get();
            }
            return new LostApiClientImpl(this.context, callbacks, LostClientManager.shared());
        }
    }

    public static interface ConnectionCallbacks {
        public void onConnected();

        public void onConnectionSuspended();
    }
}

