/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import com.mapzen.android.lost.api.Result;
import com.mapzen.android.lost.internal.DialogDisplayer;

public class Status
implements Result,
Parcelable {
    public static final int SUCCESS = 0;
    public static final int RESOLUTION_REQUIRED = 6;
    public static final int INTERRUPTED = 14;
    public static final int INTERNAL_ERROR = 8;
    public static final int TIMEOUT = 15;
    public static final int CANCELLED = 16;
    public static final int SETTINGS_CHANGE_UNAVAILABLE = 8502;
    private final int statusCode;
    private final String statusMessage;
    private final PendingIntent pendingIntent;
    private final DialogDisplayer dialogDisplayer;
    public static final Parcelable.Creator<Status> CREATOR = new Parcelable.Creator<Status>(){

        public Status createFromParcel(Parcel in) {
            return new Status(in);
        }

        public Status[] newArray(int size) {
            return new Status[size];
        }
    };

    public Status(int statusCode) {
        this(statusCode, null, null);
    }

    public Status(int statusCode, DialogDisplayer dialogDisplayer) {
        this(statusCode, dialogDisplayer, null);
    }

    public Status(int statusCode, DialogDisplayer dialogDisplayer, PendingIntent pendingIntent) {
        String statusMessage;
        switch (statusCode) {
            case 0: {
                statusMessage = "SUCCESS";
                break;
            }
            case 6: {
                statusMessage = "RESOLUTION_REQUIRED";
                break;
            }
            case 8502: {
                statusMessage = "SETTINGS_CHANGE_UNAVAILABLE";
                break;
            }
            case 8: {
                statusMessage = "INTERNAL_ERROR";
                break;
            }
            case 14: {
                statusMessage = "INTERRUPTED";
                break;
            }
            case 15: {
                statusMessage = "TIMEOUT";
                break;
            }
            case 16: {
                statusMessage = "CANCELLED";
                break;
            }
            default: {
                statusMessage = "UNKNOWN STATUS";
            }
        }
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.pendingIntent = pendingIntent;
        this.dialogDisplayer = dialogDisplayer;
    }

    protected Status(Parcel in) {
        this.statusCode = in.readInt();
        this.statusMessage = in.readString();
        this.pendingIntent = (PendingIntent)in.readParcelable(PendingIntent.class.getClassLoader());
        this.dialogDisplayer = (DialogDisplayer)in.readParcelable(DialogDisplayer.class.getClassLoader());
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (this.hasResolution()) {
            this.dialogDisplayer.displayDialog(activity, requestCode, this.pendingIntent);
        }
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean hasResolution() {
        return this.pendingIntent != null && this.dialogDisplayer != null;
    }

    public boolean isSuccess() {
        return this.statusCode == 0;
    }

    public boolean isCanceled() {
        return this.statusCode == 16;
    }

    public boolean isInterrupted() {
        return this.statusCode == 14;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public PendingIntent getResolution() {
        return this.pendingIntent;
    }

    @Override
    public Status getStatus() {
        return this;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(this.statusCode);
        parcel.writeString(this.statusMessage);
        parcel.writeParcelable((Parcelable)this.pendingIntent, i);
        parcel.writeParcelable((Parcelable)this.dialogDisplayer, i);
    }
}

