/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.location.Location;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.mapzen.android.lost.api.FusedLocationProviderApi;
import com.mapzen.android.lost.api.LocationAvailability;
import com.mapzen.android.lost.api.LocationCallback;
import com.mapzen.android.lost.api.LocationListener;
import com.mapzen.android.lost.api.LocationRequest;
import com.mapzen.android.lost.api.LostApiClient;
import com.mapzen.android.lost.api.PendingResult;
import com.mapzen.android.lost.api.Status;
import com.mapzen.android.lost.internal.ApiImpl;
import com.mapzen.android.lost.internal.ClientManager;
import com.mapzen.android.lost.internal.FusedLocationProviderService;
import com.mapzen.android.lost.internal.FusedLocationServiceCallbackManager;
import com.mapzen.android.lost.internal.FusedLocationServiceConnectionManager;
import com.mapzen.android.lost.internal.IFusedLocationProviderCallback;
import com.mapzen.android.lost.internal.IFusedLocationProviderService;
import com.mapzen.android.lost.internal.RequestManager;
import com.mapzen.android.lost.internal.SimplePendingResult;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FusedLocationProviderApiImpl
extends ApiImpl
implements FusedLocationProviderApi,
FusedLocationServiceConnectionManager.EventCallbacks,
ServiceConnection {
    private static final String TAG = FusedLocationProviderApiImpl.class.getSimpleName();
    private Context context;
    private FusedLocationServiceConnectionManager serviceConnectionManager;
    private FusedLocationServiceCallbackManager serviceCallbackManager;
    private RequestManager requestManager;
    private ClientManager clientManager;
    private boolean isBound;
    IFusedLocationProviderService service;
    IFusedLocationProviderCallback.Stub remoteCallback = new IFusedLocationProviderCallback.Stub(){

        @Override
        public long pid() throws RemoteException {
            return Process.myPid();
        }

        @Override
        public void onLocationChanged(final Location location) throws RemoteException {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (FusedLocationProviderApiImpl.this.service != null) {
                        FusedLocationProviderApiImpl.this.serviceCallbackManager.onLocationChanged(FusedLocationProviderApiImpl.this.context, location, FusedLocationProviderApiImpl.this.clientManager, FusedLocationProviderApiImpl.this.service);
                    }
                }
            });
        }

        @Override
        public void onLocationAvailabilityChanged(LocationAvailability locationAvailability) throws RemoteException {
            FusedLocationProviderApiImpl.this.serviceCallbackManager.onLocationAvailabilityChanged(locationAvailability, FusedLocationProviderApiImpl.this.clientManager);
        }
    };

    @Override
    public void onConnect(Context context) {
        this.context = context;
        Intent intent = new Intent(context, FusedLocationProviderService.class);
        context.bindService(intent, (ServiceConnection)this, 1);
    }

    @Override
    public void onServiceConnected(IBinder binder) {
        this.service = IFusedLocationProviderService.Stub.asInterface(binder);
        this.isBound = true;
        this.registerRemoteCallback();
    }

    @Override
    public void onDisconnect() {
        if (this.isBound) {
            this.unregisterRemoteCallback();
            this.context.unbindService((ServiceConnection)this);
            this.isBound = false;
        }
        this.service = null;
    }

    public void onServiceConnected(ComponentName name, IBinder binder) {
        this.serviceConnectionManager.onServiceConnected(binder);
        this.isBound = true;
    }

    public void onServiceDisconnected(ComponentName name) {
        this.serviceConnectionManager.onServiceDisconnected();
        this.isBound = false;
    }

    public FusedLocationProviderApiImpl(FusedLocationServiceConnectionManager connectionManager, FusedLocationServiceCallbackManager callbackManager, RequestManager requestManager, ClientManager clientManager) {
        this.serviceConnectionManager = connectionManager;
        this.serviceCallbackManager = callbackManager;
        this.requestManager = requestManager;
        this.clientManager = clientManager;
        this.serviceConnectionManager.setEventCallbacks(this);
    }

    public boolean isConnecting() {
        return this.serviceConnectionManager.isConnecting();
    }

    public void addConnectionCallbacks(LostApiClient.ConnectionCallbacks callbacks) {
        this.serviceConnectionManager.addCallbacks(callbacks);
    }

    public void connect(Context context, LostApiClient.ConnectionCallbacks callbacks) {
        this.serviceConnectionManager.connect(context, callbacks);
    }

    public void disconnect() {
        this.serviceConnectionManager.disconnect();
    }

    public boolean isConnected() {
        return this.serviceConnectionManager.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Location getLastLocation(LostApiClient client) {
        this.throwIfNotConnected(client);
        Location location = null;
        try {
            location = this.service.getLastLocation();
            return location;
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error occurred trying to get last Location", (Throwable)e);
        }
        finally {
            return location;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocationAvailability getLocationAvailability(LostApiClient client) {
        this.throwIfNotConnected(client);
        LocationAvailability availability = null;
        try {
            availability = this.service.getLocationAvailability();
            return availability;
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error occurred trying to get LocationAvailability", (Throwable)e);
        }
        finally {
            return availability;
        }
    }

    @Override
    public PendingResult<Status> requestLocationUpdates(LostApiClient client, LocationRequest request, LocationListener listener) {
        this.throwIfNotConnected(client);
        this.requestManager.requestLocationUpdates(client, request, listener);
        this.clientManager.addListener(client, request, listener);
        this.requestLocationUpdatesInternal(request);
        return new SimplePendingResult(true);
    }

    @Override
    public PendingResult<Status> requestLocationUpdates(LostApiClient client, LocationRequest request, LocationListener listener, Looper looper) {
        throw new RuntimeException("Sorry, not yet implemented");
    }

    @Override
    public PendingResult<Status> requestLocationUpdates(LostApiClient client, LocationRequest request, LocationCallback callback, Looper looper) {
        this.throwIfNotConnected(client);
        this.requestManager.requestLocationUpdates(client, request, callback);
        this.clientManager.addLocationCallback(client, request, callback, looper);
        this.requestLocationUpdatesInternal(request);
        return new SimplePendingResult(true);
    }

    @Override
    public PendingResult<Status> requestLocationUpdates(LostApiClient client, LocationRequest request, PendingIntent callbackIntent) {
        this.throwIfNotConnected(client);
        this.requestManager.requestLocationUpdates(client, request, callbackIntent);
        this.clientManager.addPendingIntent(client, request, callbackIntent);
        this.requestLocationUpdatesInternal(request);
        return new SimplePendingResult(true);
    }

    private void requestLocationUpdatesInternal(LocationRequest request) {
        try {
            this.service.requestLocationUpdates(request);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error occurred trying to request location updates", (Throwable)e);
        }
    }

    private void removeLocationUpdatesInternal(List<LocationRequest> requests) {
        if (requests == null) {
            return;
        }
        try {
            this.service.removeLocationUpdates(requests);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error occurred trying to remove location updates", (Throwable)e);
        }
    }

    @Override
    public PendingResult<Status> removeLocationUpdates(LostApiClient client, LocationListener listener) {
        this.throwIfNotConnected(client);
        List<LocationRequest> requests = this.requestManager.removeLocationUpdates(client, listener);
        this.removeLocationUpdatesInternal(requests);
        boolean hasResult = this.clientManager.removeListener(client, listener);
        this.checkAllListenersPendingIntentsAndCallbacks();
        return new SimplePendingResult(hasResult);
    }

    @Override
    public PendingResult<Status> removeLocationUpdates(LostApiClient client, PendingIntent callbackIntent) {
        this.throwIfNotConnected(client);
        List<LocationRequest> requests = this.requestManager.removeLocationUpdates(client, callbackIntent);
        this.removeLocationUpdatesInternal(requests);
        boolean hasResult = this.clientManager.removePendingIntent(client, callbackIntent);
        this.checkAllListenersPendingIntentsAndCallbacks();
        return new SimplePendingResult(hasResult);
    }

    @Override
    public PendingResult<Status> removeLocationUpdates(LostApiClient client, LocationCallback callback) {
        this.throwIfNotConnected(client);
        List<LocationRequest> requests = this.requestManager.removeLocationUpdates(client, callback);
        this.removeLocationUpdatesInternal(requests);
        boolean hasResult = this.clientManager.removeLocationCallback(client, callback);
        this.checkAllListenersPendingIntentsAndCallbacks();
        return new SimplePendingResult(hasResult);
    }

    private void checkAllListenersPendingIntentsAndCallbacks() {
    }

    @Override
    public PendingResult<Status> setMockMode(LostApiClient client, boolean isMockMode) {
        this.throwIfNotConnected(client);
        try {
            this.service.setMockMode(isMockMode);
        }
        catch (RemoteException e) {
            String mode = isMockMode ? "enabled" : "disabled";
            Log.e((String)TAG, (String)("Error occurred trying to set mock mode " + mode), (Throwable)e);
        }
        return new SimplePendingResult(true);
    }

    @Override
    public PendingResult<Status> setMockLocation(LostApiClient client, Location mockLocation) {
        this.throwIfNotConnected(client);
        try {
            this.service.setMockLocation(mockLocation);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error occurred trying to set mock location", (Throwable)e);
        }
        return new SimplePendingResult(true);
    }

    @Override
    public PendingResult<Status> setMockTrace(LostApiClient client, String path, String filename) {
        this.throwIfNotConnected(client);
        try {
            this.service.setMockTrace(path, filename);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error occurred trying to set mock trace", (Throwable)e);
        }
        return new SimplePendingResult(true);
    }

    public Map<LostApiClient, Set<LocationListener>> getLocationListeners() {
        return this.clientManager.getLocationListeners();
    }

    void removeConnectionCallbacks(LostApiClient.ConnectionCallbacks callbacks) {
        this.serviceConnectionManager.removeCallbacks(callbacks);
    }

    FusedLocationServiceConnectionManager getServiceConnectionManager() {
        return this.serviceConnectionManager;
    }

    void registerRemoteCallback() {
        if (this.service != null) {
            try {
                this.service.add(this.remoteCallback);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Error occurred trying to register remote callback", (Throwable)e);
            }
        }
    }

    void unregisterRemoteCallback() {
        if (this.service != null) {
            try {
                this.service.remove(this.remoteCallback);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Error occurred trying to unregister remote callback", (Throwable)e);
            }
        }
    }
}

