/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.RequiresPermission;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.mapzen.android.lost.api.LocationAvailability;
import com.mapzen.android.lost.api.LocationRequest;
import com.mapzen.android.lost.internal.FusionEngine;
import com.mapzen.android.lost.internal.GpxTraceThreadFactory;
import com.mapzen.android.lost.internal.IFusedLocationProviderCallback;
import com.mapzen.android.lost.internal.LocationEngine;
import com.mapzen.android.lost.internal.MockEngine;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FusedLocationProviderServiceDelegate
implements LocationEngine.Callback {
    private static final String TAG = FusedLocationProviderServiceDelegate.class.getSimpleName();
    private Context context;
    private boolean mockMode;
    private LocationEngine locationEngine;
    private Map<Long, IFusedLocationProviderCallback> callbacks;

    public FusedLocationProviderServiceDelegate(Context context) {
        this.context = context;
        this.locationEngine = new FusionEngine(context, this);
        this.callbacks = new HashMap<Long, IFusedLocationProviderCallback>();
    }

    public void add(IFusedLocationProviderCallback callback) {
        try {
            this.callbacks.put(callback.pid(), callback);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error getting callback's unique id", (Throwable)e);
        }
    }

    public void remove(IFusedLocationProviderCallback callback) {
        try {
            this.callbacks.remove(callback.pid());
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error getting callback's unique id", (Throwable)e);
        }
    }

    public Location getLastLocation() {
        return this.locationEngine.getLastLocation();
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public LocationAvailability getLocationAvailability() {
        return this.locationEngine.createLocationAvailability();
    }

    public void requestLocationUpdates(LocationRequest request) {
        this.locationEngine.addRequest(request);
    }

    public void removeLocationUpdates(List<LocationRequest> requests) {
        this.locationEngine.removeRequests(requests);
    }

    public void setMockMode(boolean isMockMode) {
        if (this.mockMode != isMockMode) {
            this.toggleMockMode();
        }
    }

    public void setMockLocation(Location mockLocation) {
        if (this.mockMode) {
            ((MockEngine)this.locationEngine).setLocation(mockLocation);
        }
    }

    public void setMockTrace(String path, String filename) {
        if (this.mockMode) {
            ((MockEngine)this.locationEngine).setTrace(new File(path, filename));
        }
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void reportLocation(Location location) {
        for (IFusedLocationProviderCallback callback : this.callbacks.values()) {
            try {
                callback.onLocationChanged(location);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Error occurred trying to report a new Location", (Throwable)e);
            }
        }
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void reportProviderDisabled(String provider) {
        this.notifyLocationAvailabilityChanged();
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void reportProviderEnabled(String provider) {
        this.notifyLocationAvailabilityChanged();
        LocationManager manager = (LocationManager)this.context.getSystemService("location");
        manager.requestSingleUpdate(provider, new LocationListener(){

            public void onLocationChanged(Location location) {
                FusedLocationProviderServiceDelegate.this.notifyLocationAvailabilityChanged();
            }

            public void onStatusChanged(String s, int i, Bundle bundle) {
            }

            public void onProviderEnabled(String s) {
            }

            public void onProviderDisabled(String s) {
            }
        }, Looper.myLooper());
    }

    private void toggleMockMode() {
        this.mockMode = !this.mockMode;
        this.locationEngine.removeAllRequests();
        this.locationEngine = this.mockMode ? new MockEngine(this.context, this, new GpxTraceThreadFactory()) : new FusionEngine(this.context, this);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    private void notifyLocationAvailabilityChanged() {
        LocationAvailability availability = this.locationEngine.createLocationAvailability();
        for (IFusedLocationProviderCallback callback : this.callbacks.values()) {
            try {
                callback.onLocationAvailabilityChanged(availability);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Error occurred trying to report a new LocationAvailability", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    Map getCallbacks() {
        return this.callbacks;
    }
}

