/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import android.content.Context;
import android.location.Location;
import android.os.RemoteException;
import android.util.Log;
import com.mapzen.android.lost.api.LocationAvailability;
import com.mapzen.android.lost.api.LocationResult;
import com.mapzen.android.lost.internal.ClientManager;
import com.mapzen.android.lost.internal.IFusedLocationProviderService;
import java.util.ArrayList;

public class FusedLocationServiceCallbackManager {
    void onLocationChanged(Context context, Location location, ClientManager clientManager, IFusedLocationProviderService service) {
        clientManager.reportLocationChanged(location);
        LocationAvailability availability = null;
        try {
            availability = service.getLocationAvailability();
        }
        catch (RemoteException e) {
            Log.e((String)"ContentValues", (String)"Error occurred trying to get LocationAvailability", (Throwable)e);
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(location);
        LocationResult result = LocationResult.create(locations);
        clientManager.sendPendingIntent(context, location, availability, result);
        clientManager.reportLocationResult(location, result);
    }

    void onLocationAvailabilityChanged(LocationAvailability locationAvailability, ClientManager clientManager) {
        clientManager.notifyLocationAvailability(locationAvailability);
    }
}

