/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import android.content.Context;
import android.os.IBinder;
import com.mapzen.android.lost.api.LostApiClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class FusedLocationServiceConnectionManager {
    private EventCallbacks eventCallbacks;
    private ConnectState connectState;
    Set<LostApiClient.ConnectionCallbacks> connectionCallbacks = new HashSet<LostApiClient.ConnectionCallbacks>();

    public FusedLocationServiceConnectionManager() {
        this.connectState = ConnectState.IDLE;
    }

    public void setEventCallbacks(EventCallbacks callbacks) {
        this.eventCallbacks = callbacks;
    }

    public void addCallbacks(LostApiClient.ConnectionCallbacks callbacks) {
        if (callbacks != null) {
            this.connectionCallbacks.add(callbacks);
        }
    }

    public void removeCallbacks(LostApiClient.ConnectionCallbacks callbacks) {
        if (callbacks != null) {
            this.connectionCallbacks.remove(callbacks);
        }
    }

    public boolean isConnected() {
        return this.connectState == ConnectState.CONNECTED;
    }

    public boolean isConnecting() {
        return this.connectState == ConnectState.CONNECTING;
    }

    public void connect(Context context, LostApiClient.ConnectionCallbacks callbacks) {
        this.addCallbacks(callbacks);
        if (this.connectState == ConnectState.IDLE) {
            this.connectState = ConnectState.CONNECTING;
            if (this.eventCallbacks != null) {
                this.eventCallbacks.onConnect(context);
            }
        }
    }

    public void disconnect() {
        if (this.connectState != ConnectState.IDLE) {
            this.connectState = ConnectState.IDLE;
            if (this.eventCallbacks != null) {
                this.eventCallbacks.onDisconnect();
            }
        }
    }

    public void onServiceConnected(IBinder binder) {
        if (this.connectState != ConnectState.IDLE) {
            this.connectState = ConnectState.CONNECTED;
            if (this.eventCallbacks != null) {
                this.eventCallbacks.onServiceConnected(binder);
            }
            if (!this.connectionCallbacks.isEmpty()) {
                ArrayList<LostApiClient.ConnectionCallbacks> copy = new ArrayList<LostApiClient.ConnectionCallbacks>(this.connectionCallbacks);
                for (LostApiClient.ConnectionCallbacks callbacks : copy) {
                    callbacks.onConnected();
                }
            }
        }
    }

    public void onServiceDisconnected() {
        if (this.connectState != ConnectState.IDLE) {
            this.connectState = ConnectState.IDLE;
            if (!this.connectionCallbacks.isEmpty()) {
                ArrayList<LostApiClient.ConnectionCallbacks> copy = new ArrayList<LostApiClient.ConnectionCallbacks>(this.connectionCallbacks);
                for (LostApiClient.ConnectionCallbacks callbacks : copy) {
                    callbacks.onConnectionSuspended();
                }
            }
        }
    }

    public Set<LostApiClient.ConnectionCallbacks> getConnectionCallbacks() {
        return this.connectionCallbacks;
    }

    private static enum ConnectState {
        IDLE,
        CONNECTING,
        CONNECTED;

    }

    public static interface EventCallbacks {
        public void onConnect(Context var1);

        public void onServiceConnected(IBinder var1);

        public void onDisconnect();
    }
}

