/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import com.mapzen.android.lost.api.LocationRequest;
import com.mapzen.android.lost.internal.Clock;
import com.mapzen.android.lost.internal.LocationEngine;
import com.mapzen.android.lost.internal.SystemClock;
import java.util.List;

public class FusionEngine
extends LocationEngine
implements LocationListener {
    private static final String TAG = FusionEngine.class.getSimpleName();
    public static final long RECENT_UPDATE_THRESHOLD_IN_MILLIS = 60000L;
    public static final long RECENT_UPDATE_THRESHOLD_IN_NANOS = 60000000000L;
    private final LocationManager locationManager;
    private Location gpsLocation;
    private Location networkLocation;
    static Clock clock = new SystemClock();

    public FusionEngine(Context context, LocationEngine.Callback callback) {
        super(context, callback);
        this.locationManager = (LocationManager)context.getSystemService("location");
    }

    @Override
    public Location getLastLocation() {
        List providers = this.locationManager.getAllProviders();
        long minTime = clock.getSystemElapsedTimeInNanos() - 60000000000L;
        Location bestLocation = null;
        float bestAccuracy = Float.MAX_VALUE;
        long bestTime = Long.MIN_VALUE;
        for (String provider : providers) {
            try {
                Location location = this.locationManager.getLastKnownLocation(provider);
                if (location == null) continue;
                float accuracy = location.getAccuracy();
                long time = clock.getElapsedTimeInNanos(location);
                if (time > minTime && accuracy < bestAccuracy) {
                    bestLocation = location;
                    bestAccuracy = accuracy;
                    bestTime = time;
                    continue;
                }
                if (time >= minTime || bestAccuracy != Float.MAX_VALUE || time <= bestTime) continue;
                bestLocation = location;
                bestTime = time;
            }
            catch (SecurityException e) {
                Log.e((String)TAG, (String)("Permissions not granted for provider: " + provider), (Throwable)e);
            }
        }
        return bestLocation;
    }

    @Override
    public boolean isProviderEnabled(String provider) {
        return this.locationManager.isProviderEnabled(provider);
    }

    @Override
    protected void enable() {
        long networkInterval = Long.MAX_VALUE;
        long gpsInterval = Long.MAX_VALUE;
        long passiveInterval = Long.MAX_VALUE;
        for (LocationRequest request : this.getRequest().getRequests()) {
            switch (request.getPriority()) {
                case 100: {
                    if (request.getInterval() < gpsInterval) {
                        gpsInterval = request.getInterval();
                    }
                    if (request.getInterval() >= networkInterval) break;
                    networkInterval = request.getInterval();
                    break;
                }
                case 102: 
                case 104: {
                    if (request.getInterval() >= networkInterval) break;
                    networkInterval = request.getInterval();
                    break;
                }
                case 105: {
                    if (request.getInterval() >= passiveInterval) break;
                    passiveInterval = request.getInterval();
                    break;
                }
            }
        }
        boolean checkGps = false;
        if (gpsInterval < Long.MAX_VALUE) {
            this.enableGps(gpsInterval);
            checkGps = true;
        }
        if (networkInterval < Long.MAX_VALUE) {
            this.enableNetwork(networkInterval);
            if (checkGps) {
                Location lastGps = this.locationManager.getLastKnownLocation("gps");
                Location lastNetwork = this.locationManager.getLastKnownLocation("network");
                if (lastGps != null && lastNetwork != null) {
                    boolean useGps = FusionEngine.isBetterThan(lastGps, lastNetwork);
                    if (useGps) {
                        this.checkLastKnownGps();
                    } else {
                        this.checkLastKnownNetwork();
                    }
                } else if (lastGps != null) {
                    this.checkLastKnownGps();
                } else {
                    this.checkLastKnownNetwork();
                }
            } else {
                this.checkLastKnownNetwork();
            }
        }
        if (passiveInterval < Long.MAX_VALUE) {
            this.enablePassive(passiveInterval);
            this.checkLastKnownPassive();
        }
    }

    @Override
    protected void disable() throws SecurityException {
        if (this.locationManager != null) {
            this.locationManager.removeUpdates((LocationListener)this);
        }
    }

    private void enableGps(long interval) throws SecurityException {
        try {
            this.locationManager.requestLocationUpdates("gps", interval, 0.0f, (LocationListener)this, this.getLooper());
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"Unable to register for GPS updates.", (Throwable)e);
        }
    }

    private void enableNetwork(long interval) throws SecurityException {
        try {
            this.locationManager.requestLocationUpdates("network", interval, 0.0f, (LocationListener)this, this.getLooper());
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"Unable to register for network updates.", (Throwable)e);
        }
    }

    private void enablePassive(long interval) throws SecurityException {
        try {
            this.locationManager.requestLocationUpdates("passive", interval, 0.0f, (LocationListener)this, this.getLooper());
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"Unable to register for passive updates.", (Throwable)e);
        }
    }

    private void checkLastKnownGps() {
        this.checkLastKnownAndNotify("gps");
    }

    private void checkLastKnownNetwork() {
        this.checkLastKnownAndNotify("network");
    }

    private void checkLastKnownPassive() {
        this.checkLastKnownAndNotify("passive");
    }

    private void checkLastKnownAndNotify(String provider) {
        Location location = this.locationManager.getLastKnownLocation(provider);
        if (location != null) {
            this.onLocationChanged(location);
        }
    }

    public void onLocationChanged(Location location) {
        if ("gps".equals(location.getProvider())) {
            this.gpsLocation = location;
            if (this.getCallback() != null && FusionEngine.isBetterThan(this.gpsLocation, this.networkLocation)) {
                this.getCallback().reportLocation(location);
            }
        } else if ("network".equals(location.getProvider())) {
            this.networkLocation = location;
            if (this.getCallback() != null && FusionEngine.isBetterThan(this.networkLocation, this.gpsLocation)) {
                this.getCallback().reportLocation(location);
            }
        }
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    public void onProviderEnabled(String provider) {
        LocationEngine.Callback callback = this.getCallback();
        if (callback != null) {
            callback.reportProviderEnabled(provider);
        }
    }

    public void onProviderDisabled(String provider) {
        LocationEngine.Callback callback = this.getCallback();
        if (callback != null) {
            callback.reportProviderDisabled(provider);
        }
    }

    public static boolean isBetterThan(Location locationA, Location locationB) {
        if (locationA == null) {
            return false;
        }
        if (locationB == null) {
            return true;
        }
        if (clock.getElapsedTimeInNanos(locationA) > clock.getElapsedTimeInNanos(locationB) + 60000000000L) {
            return true;
        }
        if (!locationA.hasAccuracy()) {
            return false;
        }
        if (!locationB.hasAccuracy()) {
            return true;
        }
        return locationA.getAccuracy() < locationB.getAccuracy();
    }
}

