/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.support.annotation.RequiresPermission;
import com.mapzen.android.lost.api.Geofence;
import com.mapzen.android.lost.api.GeofencingApi;
import com.mapzen.android.lost.api.GeofencingRequest;
import com.mapzen.android.lost.api.LostApiClient;
import com.mapzen.android.lost.api.PendingResult;
import com.mapzen.android.lost.api.Status;
import com.mapzen.android.lost.internal.ApiImpl;
import com.mapzen.android.lost.internal.IdGenerator;
import com.mapzen.android.lost.internal.IntentFactory;
import com.mapzen.android.lost.internal.ParcelableGeofence;
import com.mapzen.android.lost.internal.SimplePendingResult;
import java.util.HashMap;
import java.util.List;

public class GeofencingApiImpl
extends ApiImpl
implements GeofencingApi {
    private Context context;
    private LocationManager locationManager;
    private final HashMap<String, PendingIntent> pendingIntentMap;
    private Intent internalIntent;
    private IntentFactory geofencingServiceIntentFactory;
    private IntentFactory dwellServiceIntentFactory;
    private IdGenerator idGenerator;
    private HashMap<Integer, PendingIntent> idToPendingIntent = new HashMap();
    private HashMap<Integer, Geofence> idToGeofence = new HashMap();
    private HashMap<Geofence, PendingIntent> enteredFences = new HashMap();

    public GeofencingApiImpl(IntentFactory geofenceFactory, IntentFactory dwellFactory, IdGenerator generator) {
        this.geofencingServiceIntentFactory = geofenceFactory;
        this.dwellServiceIntentFactory = dwellFactory;
        this.idGenerator = generator;
        this.pendingIntentMap = new HashMap();
    }

    public void connect(Context context) {
        this.context = context;
        this.locationManager = (LocationManager)context.getSystemService("location");
    }

    public boolean isConnected() {
        return this.locationManager != null;
    }

    public void disconnect() {
        this.locationManager = null;
    }

    @Override
    public PendingResult<Status> addGeofences(LostApiClient client, GeofencingRequest geofencingRequest, PendingIntent pendingIntent) throws SecurityException {
        this.throwIfNotConnected(client);
        List<Geofence> geofences = geofencingRequest.getGeofences();
        this.addGeofences(client, geofences, pendingIntent);
        return new SimplePendingResult(true);
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public PendingResult<Status> addGeofences(LostApiClient client, List<Geofence> geofences, PendingIntent pendingIntent) throws SecurityException {
        this.throwIfNotConnected(client);
        for (Geofence geofence : geofences) {
            this.addGeofence(client, geofence, pendingIntent);
        }
        return new SimplePendingResult(true);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    private PendingResult<Status> addGeofence(LostApiClient client, Geofence geofence, PendingIntent pendingIntent) throws SecurityException {
        this.checkGeofence(geofence);
        int pendingIntentId = this.idGenerator.generateId();
        this.internalIntent = this.geofencingServiceIntentFactory.createIntent(this.context);
        this.internalIntent.addCategory(String.valueOf(pendingIntentId));
        ParcelableGeofence pGeofence = (ParcelableGeofence)geofence;
        this.idToPendingIntent.put(pendingIntentId, pendingIntent);
        this.idToGeofence.put(pendingIntentId, pGeofence);
        PendingIntent internalPendingIntent = this.geofencingServiceIntentFactory.createPendingIntent(this.context, pendingIntentId, this.internalIntent);
        String requestId = String.valueOf(pGeofence.hashCode());
        this.locationManager.addProximityAlert(pGeofence.getLatitude(), pGeofence.getLongitude(), pGeofence.getRadius(), pGeofence.getDuration(), internalPendingIntent);
        if (pGeofence.getRequestId() != null && !pGeofence.getRequestId().isEmpty()) {
            requestId = pGeofence.getRequestId();
        }
        this.pendingIntentMap.put(requestId, pendingIntent);
        return new SimplePendingResult(true);
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public PendingResult<Status> removeGeofences(LostApiClient client, List<String> geofenceRequestIds) {
        this.throwIfNotConnected(client);
        boolean hasResult = false;
        for (String geofenceRequestId : geofenceRequestIds) {
            if (this.pendingIntentMap.containsKey(geofenceRequestId)) {
                hasResult = true;
            }
            this.removeGeofences(client, geofenceRequestId);
        }
        return new SimplePendingResult(hasResult);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    private void removeGeofences(LostApiClient client, String geofenceRequestId) throws SecurityException {
        PendingIntent pendingIntent = this.pendingIntentMap.get(geofenceRequestId);
        this.removeGeofences(client, pendingIntent);
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public PendingResult<Status> removeGeofences(LostApiClient client, PendingIntent pendingIntent) throws SecurityException {
        this.throwIfNotConnected(client);
        boolean hasResult = false;
        if (this.pendingIntentMap.values().contains(pendingIntent)) {
            hasResult = true;
        }
        this.locationManager.removeProximityAlert(pendingIntent);
        this.pendingIntentMap.values().remove(pendingIntent);
        return new SimplePendingResult(hasResult);
    }

    public PendingIntent pendingIntentForIntentId(int intentId) {
        return this.idToPendingIntent.get(intentId);
    }

    public Geofence geofenceForIntentId(int intentId) {
        return this.idToGeofence.get(intentId);
    }

    public void geofenceEntered(Geofence geofence, int pendingIntentId) {
        ParcelableGeofence parcelableGeofence = (ParcelableGeofence)geofence;
        long loiterDelay = parcelableGeofence.getLoiteringDelayMs();
        AlarmManager alarmManager = (AlarmManager)this.context.getSystemService("alarm");
        Intent intent = this.dwellServiceIntentFactory.createIntent(this.context);
        intent.addCategory(String.valueOf(pendingIntentId));
        PendingIntent pendingIntent = this.dwellServiceIntentFactory.createPendingIntent(this.context, pendingIntentId, intent);
        alarmManager.set(0, System.currentTimeMillis() + loiterDelay, pendingIntent);
        this.enteredFences.put(geofence, pendingIntent);
    }

    public void geofenceExited(Geofence geofence) {
        PendingIntent pendingIntent = this.enteredFences.get(geofence);
        if (pendingIntent != null) {
            AlarmManager alarmManager = (AlarmManager)this.context.getSystemService("alarm");
            alarmManager.cancel(pendingIntent);
            this.enteredFences.remove(geofence);
        }
    }

    private void checkGeofence(Geofence geofence) {
        ParcelableGeofence pGeofence = (ParcelableGeofence)geofence;
        if ((pGeofence.getTransitionTypes() & 4) != 0 && pGeofence.getLoiteringDelayMs() == -1) {
            throw new IllegalStateException("Dwell transition type requested without loitering delay. Please set a loitering delay for this geofence.");
        }
    }
}

