/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import android.content.Intent;
import com.mapzen.android.lost.api.GeofencingApi;
import com.mapzen.android.lost.internal.GeofenceIntentHelper;
import com.mapzen.android.lost.internal.GeofencingApiImpl;
import com.mapzen.android.lost.internal.ParcelableGeofence;

public class GeofencingDwellManager {
    GeofencingApiImpl geofencingApi;
    GeofenceIntentHelper intentHelper;

    public GeofencingDwellManager(GeofencingApi geofencingApi) {
        this.geofencingApi = (GeofencingApiImpl)geofencingApi;
        this.intentHelper = new GeofenceIntentHelper();
    }

    public void handleIntent(Intent intent) {
        int transition = this.intentHelper.transitionForIntent(intent);
        int intentId = this.intentHelper.extractIntentId(intent);
        ParcelableGeofence geofence = (ParcelableGeofence)this.geofencingApi.geofenceForIntentId(intentId);
        switch (transition) {
            case 1: {
                this.geofencingApi.geofenceEntered(geofence, intentId);
                break;
            }
            case 2: {
                this.geofencingApi.geofenceExited(geofence);
            }
        }
    }
}

