/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.os.Looper;
import android.support.annotation.RequiresPermission;
import com.mapzen.android.lost.api.LocationAvailability;
import com.mapzen.android.lost.api.LocationRequest;
import com.mapzen.android.lost.internal.LocationRequestUnbundled;
import java.util.List;

public abstract class LocationEngine {
    private final Context context;
    private final Callback callback;
    private LocationRequestUnbundled request;

    public LocationEngine(Context context, Callback callback) {
        this.context = context;
        this.callback = callback;
        this.request = new LocationRequestUnbundled();
    }

    public abstract Location getLastLocation();

    public abstract boolean isProviderEnabled(String var1);

    public void addRequest(LocationRequest request) {
        if (request != null) {
            this.request.addRequest(request);
            this.enable();
        }
    }

    public void removeRequests(List<LocationRequest> requests) {
        if (this.request != null) {
            this.request.removeRequests(requests);
            this.disable();
            if (!this.request.getRequests().isEmpty()) {
                this.enable();
            }
        }
    }

    public void removeAllRequests() {
        this.request.removeAllRequests();
        this.disable();
    }

    protected abstract void enable();

    protected abstract void disable();

    protected Context getContext() {
        return this.context;
    }

    protected Looper getLooper() {
        return this.context.getMainLooper();
    }

    protected Callback getCallback() {
        return this.callback;
    }

    protected LocationRequestUnbundled getRequest() {
        return this.request;
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    protected LocationAvailability createLocationAvailability() {
        LocationManager locationManager = (LocationManager)this.context.getSystemService("location");
        boolean gpsEnabled = locationManager.isProviderEnabled("gps");
        boolean networkEnabled = locationManager.isProviderEnabled("network");
        boolean gpsLocationExists = locationManager.getLastKnownLocation("gps") != null;
        boolean networkLocationExists = locationManager.getLastKnownLocation("network") != null;
        return new LocationAvailability(gpsEnabled && gpsLocationExists || networkEnabled && networkLocationExists);
    }

    public static interface Callback {
        public void reportLocation(Location var1);

        public void reportProviderDisabled(String var1);

        public void reportProviderEnabled(String var1);
    }
}

