/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import com.mapzen.android.lost.api.LocationRequest;
import java.util.ArrayList;
import java.util.List;

public class LocationRequestUnbundled {
    private List<LocationRequest> requests = new ArrayList<LocationRequest>();
    private long fastestInterval = Long.MAX_VALUE;

    public void addRequest(LocationRequest request) {
        if (request.getFastestInterval() < this.fastestInterval) {
            this.fastestInterval = request.getFastestInterval();
        }
        this.requests.add(request);
    }

    public void removeRequests(List<LocationRequest> requests) {
        this.requests.removeAll(requests);
        this.fastestInterval = this.calculateFastestInterval();
    }

    public void removeAllRequests() {
        this.fastestInterval = Long.MAX_VALUE;
        this.requests.clear();
    }

    public List<LocationRequest> getRequests() {
        return this.requests;
    }

    public long getFastestInterval() {
        return this.fastestInterval;
    }

    public long calculateFastestInterval() {
        long interval = Long.MAX_VALUE;
        for (LocationRequest request : this.requests) {
            if (request.getFastestInterval() >= interval) continue;
            interval = request.getFastestInterval();
        }
        return interval;
    }
}

