/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.support.annotation.NonNull;
import com.mapzen.android.lost.api.LocationRequest;
import com.mapzen.android.lost.api.LocationSettingsRequest;
import com.mapzen.android.lost.api.LocationSettingsResult;
import com.mapzen.android.lost.api.LocationSettingsStates;
import com.mapzen.android.lost.api.PendingResult;
import com.mapzen.android.lost.api.ResultCallback;
import com.mapzen.android.lost.api.Status;
import com.mapzen.android.lost.internal.PendingIntentGenerator;
import com.mapzen.android.lost.internal.SettingsDialogDisplayer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class LocationSettingsResultRequest
extends PendingResult<LocationSettingsResult> {
    private final PackageManager packageManager;
    private final LocationManager locationManager;
    private final PendingIntentGenerator pendingIntentGenerator;
    private final LocationSettingsRequest settingsRequest;
    private ResultCallback<? super LocationSettingsResult> resultCallback;
    private Future<LocationSettingsResult> future;
    private SettingsDialogDisplayer dialogDisplayer = new SettingsDialogDisplayer();

    LocationSettingsResultRequest(Context context, PendingIntentGenerator generator, LocationSettingsRequest request) {
        this.packageManager = context.getPackageManager();
        this.locationManager = (LocationManager)context.getSystemService("location");
        this.pendingIntentGenerator = generator;
        this.settingsRequest = request;
    }

    @Override
    @NonNull
    public LocationSettingsResult await() {
        return this.generateLocationSettingsResult();
    }

    @Override
    @NonNull
    public LocationSettingsResult await(long time, @NonNull TimeUnit timeUnit) {
        return this.generateLocationSettingsResult(time, timeUnit);
    }

    @Override
    public void cancel() {
        if (this.future != null && !this.future.isCancelled()) {
            this.future.cancel(true);
        }
    }

    @Override
    public boolean isCanceled() {
        if (this.future == null) {
            return false;
        }
        return this.future.isCancelled();
    }

    @Override
    public void setResultCallback(@NonNull ResultCallback<? super LocationSettingsResult> callback) {
        this.resultCallback = callback;
        LocationSettingsResult result = this.generateLocationSettingsResult();
        this.resultCallback.onResult(result);
    }

    @Override
    public void setResultCallback(@NonNull ResultCallback<? super LocationSettingsResult> callback, long time, @NonNull TimeUnit timeUnit) {
        this.resultCallback = callback;
        LocationSettingsResult result = this.generateLocationSettingsResult(time, timeUnit);
        this.resultCallback.onResult(result);
    }

    private LocationSettingsResult generateLocationSettingsResult() {
        Status status;
        boolean resolutionUnavailable;
        boolean needGps = false;
        boolean needNetwork = false;
        for (LocationRequest request : this.settingsRequest.getLocationRequests()) {
            switch (request.getPriority()) {
                case 100: {
                    needGps = true;
                    needNetwork = true;
                    break;
                }
                case 102: 
                case 104: {
                    needNetwork = true;
                    break;
                }
            }
        }
        boolean needBle = this.settingsRequest.getNeedBle();
        boolean gpsUsable = this.locationManager.isProviderEnabled("gps");
        boolean gpsPresent = this.packageManager.hasSystemFeature("android.hardware.location.gps");
        boolean networkUsable = this.locationManager.isProviderEnabled("network");
        boolean networkPresent = this.packageManager.hasSystemFeature("android.hardware.location.network");
        boolean bleUsable = networkUsable;
        boolean blePresent = this.packageManager.hasSystemFeature("android.hardware.bluetooth_le");
        boolean hasGpsResolution = needGps && gpsPresent && !gpsUsable;
        boolean hasNetworkResolution = needNetwork && networkPresent && !networkUsable;
        boolean hasBleResolution = needBle && blePresent && !bleUsable;
        boolean hasResolution = hasGpsResolution || hasNetworkResolution || hasBleResolution;
        boolean gpsResolutionUnavailable = needGps && !gpsPresent;
        boolean networkResolutionUnavailable = needNetwork && !networkPresent;
        boolean bleResolutionUnavailable = needBle && !blePresent;
        boolean bl = resolutionUnavailable = gpsResolutionUnavailable || networkResolutionUnavailable || bleResolutionUnavailable;
        if (hasResolution) {
            PendingIntent pendingIntent = this.pendingIntentGenerator.generatePendingIntent();
            status = new Status(6, this.dialogDisplayer, pendingIntent);
        } else {
            status = resolutionUnavailable ? new Status(8502, this.dialogDisplayer) : new Status(0, this.dialogDisplayer);
        }
        LocationSettingsStates states = new LocationSettingsStates(gpsUsable, networkUsable, bleUsable, gpsPresent, networkPresent, blePresent);
        return new LocationSettingsResult(status, states);
    }

    private LocationSettingsResult generateLocationSettingsResult(long time, TimeUnit timeUnit) {
        LocationSettingsResult result;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        this.future = executor.submit(new Callable(){

            public LocationSettingsResult call() throws Exception {
                return LocationSettingsResultRequest.this.generateLocationSettingsResult();
            }
        });
        try {
            result = this.future.get(time, timeUnit);
        }
        catch (TimeoutException e) {
            result = this.createResultForStatus(15);
        }
        catch (InterruptedException e) {
            result = this.createResultForStatus(14);
        }
        catch (ExecutionException e) {
            result = this.createResultForStatus(8);
        }
        executor.shutdownNow();
        return result;
    }

    private LocationSettingsResult createResultForStatus(int statusType) {
        Status status = new Status(statusType, this.dialogDisplayer);
        return new LocationSettingsResult(status, null);
    }
}

