/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import android.content.Context;
import com.mapzen.android.lost.api.LocationServices;
import com.mapzen.android.lost.api.LostApiClient;
import com.mapzen.android.lost.internal.ClientManager;
import com.mapzen.android.lost.internal.FusedLocationProviderApiImpl;
import com.mapzen.android.lost.internal.GeofencingApiImpl;
import com.mapzen.android.lost.internal.SettingsApiImpl;

public class LostApiClientImpl
implements LostApiClient {
    private final Context context;
    private LostApiClient.ConnectionCallbacks connectionCallbacks;
    private final ClientManager clientManager;

    public LostApiClientImpl(Context context, LostApiClient.ConnectionCallbacks callbacks, ClientManager clientManager) {
        this.context = context;
        this.connectionCallbacks = callbacks;
        this.clientManager = clientManager;
    }

    @Override
    public void connect() {
        FusedLocationProviderApiImpl fusedApi;
        SettingsApiImpl settingsApi;
        this.clientManager.addClient(this);
        GeofencingApiImpl geofencingApi = this.getGeofencingImpl();
        if (!geofencingApi.isConnected()) {
            geofencingApi.connect(this.context);
        }
        if (!(settingsApi = this.getSettingsApiImpl()).isConnected()) {
            settingsApi.connect(this.context);
        }
        if ((fusedApi = this.getFusedLocationProviderApiImpl()).isConnected()) {
            if (this.connectionCallbacks != null) {
                this.connectionCallbacks.onConnected();
                fusedApi.addConnectionCallbacks(this.connectionCallbacks);
            }
        } else if (fusedApi.isConnecting()) {
            if (this.connectionCallbacks != null) {
                fusedApi.addConnectionCallbacks(this.connectionCallbacks);
            }
        } else {
            fusedApi.connect(this.context, this.connectionCallbacks);
        }
    }

    @Override
    public void disconnect() {
        this.getFusedLocationProviderApiImpl().removeConnectionCallbacks(this.connectionCallbacks);
        this.clientManager.removeClient(this);
        if (this.clientManager.numberOfClients() > 0) {
            return;
        }
        this.getSettingsApiImpl().disconnect();
        this.getGeofencingImpl().disconnect();
        this.getFusedLocationProviderApiImpl().disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.getGeofencingImpl().isConnected() && this.getSettingsApiImpl().isConnected() && this.getFusedLocationProviderApiImpl().isConnected() && this.clientManager.containsClient(this);
    }

    @Override
    public void unregisterConnectionCallbacks(LostApiClient.ConnectionCallbacks callbacks) {
        this.getFusedLocationProviderApiImpl().removeConnectionCallbacks(this.connectionCallbacks);
        this.connectionCallbacks = null;
    }

    private GeofencingApiImpl getGeofencingImpl() {
        return (GeofencingApiImpl)LocationServices.GeofencingApi;
    }

    private SettingsApiImpl getSettingsApiImpl() {
        return (SettingsApiImpl)LocationServices.SettingsApi;
    }

    private FusedLocationProviderApiImpl getFusedLocationProviderApiImpl() {
        return (FusedLocationProviderApiImpl)LocationServices.FusedLocationApi;
    }
}

