/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.mapzen.android.lost.api.LocationAvailability;
import com.mapzen.android.lost.api.LocationCallback;
import com.mapzen.android.lost.api.LocationListener;
import com.mapzen.android.lost.api.LocationRequest;
import com.mapzen.android.lost.api.LocationResult;
import com.mapzen.android.lost.api.LostApiClient;
import com.mapzen.android.lost.internal.AndroidHandlerFactory;
import com.mapzen.android.lost.internal.ClientManager;
import com.mapzen.android.lost.internal.Clock;
import com.mapzen.android.lost.internal.HandlerFactory;
import com.mapzen.android.lost.internal.LocationRequestReport;
import com.mapzen.android.lost.internal.LostClientWrapper;
import com.mapzen.android.lost.internal.SystemClock;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LostClientManager
implements ClientManager {
    private static final String TAG = ClientManager.class.getSimpleName();
    private static LostClientManager instance;
    private final Clock clock;
    private final HandlerFactory handlerFactory;
    private HashMap<LostApiClient, LostClientWrapper> clients;
    private Map<LocationListener, LocationRequestReport> listenerToReports;
    private Map<PendingIntent, LocationRequestReport> intentToReports;
    private Map<LocationCallback, LocationRequestReport> callbackToReports;

    LostClientManager(Clock clock, HandlerFactory handlerFactory) {
        this.clock = clock;
        this.handlerFactory = handlerFactory;
        this.clients = new HashMap();
        this.listenerToReports = new HashMap<LocationListener, LocationRequestReport>();
        this.intentToReports = new HashMap<PendingIntent, LocationRequestReport>();
        this.callbackToReports = new HashMap<LocationCallback, LocationRequestReport>();
    }

    public static LostClientManager shared() {
        if (instance == null) {
            instance = new LostClientManager(new SystemClock(), new AndroidHandlerFactory());
        }
        return instance;
    }

    @Override
    public void addClient(LostApiClient client) {
        this.clients.put(client, new LostClientWrapper(client));
    }

    @Override
    public void removeClient(LostApiClient client) {
        this.clients.remove(client);
    }

    @Override
    public boolean containsClient(LostApiClient client) {
        return this.clients.containsKey(client);
    }

    @Override
    public int numberOfClients() {
        return this.clients.size();
    }

    @Override
    public void addListener(LostApiClient client, LocationRequest request, LocationListener listener) {
        this.throwIfClientNotAdded(client);
        this.clients.get(client).locationListeners().add(listener);
        this.listenerToReports.put(listener, new LocationRequestReport(request));
    }

    @Override
    public void addPendingIntent(LostApiClient client, LocationRequest request, PendingIntent callbackIntent) {
        this.throwIfClientNotAdded(client);
        this.clients.get(client).pendingIntents().add(callbackIntent);
        this.intentToReports.put(callbackIntent, new LocationRequestReport(request));
    }

    @Override
    public void addLocationCallback(LostApiClient client, LocationRequest request, LocationCallback callback, Looper looper) {
        this.throwIfClientNotAdded(client);
        this.clients.get(client).locationCallbacks().add(callback);
        this.clients.get(client).looperMap().put(callback, looper);
        this.callbackToReports.put(callback, new LocationRequestReport(request));
    }

    private void throwIfClientNotAdded(LostApiClient client) {
        if (this.clients.get(client) == null) {
            throw new IllegalArgumentException("Client must be added before requesting location updates");
        }
    }

    @Override
    public boolean removeListener(LostApiClient client, LocationListener listener) {
        Set<LocationListener> listeners = this.clients.get(client).locationListeners();
        boolean removed = false;
        if (listeners.contains(listener)) {
            listeners.remove(listener);
            removed = true;
        }
        this.listenerToReports.remove(listener);
        return removed;
    }

    @Override
    public boolean removePendingIntent(LostApiClient client, PendingIntent callbackIntent) {
        Set<PendingIntent> pendingIntents = this.clients.get(client).pendingIntents();
        boolean removed = false;
        if (pendingIntents.contains(callbackIntent)) {
            pendingIntents.remove(callbackIntent);
            removed = true;
        }
        this.intentToReports.remove(callbackIntent);
        return removed;
    }

    @Override
    public boolean removeLocationCallback(LostApiClient client, LocationCallback callback) {
        Set<LocationCallback> callbacks = this.clients.get(client).locationCallbacks();
        boolean removed = false;
        if (callbacks.contains(callback)) {
            callbacks.remove(callback);
            removed = true;
        }
        this.clients.get(client).looperMap().remove(callback);
        this.callbackToReports.remove(callback);
        return removed;
    }

    @Override
    public void reportLocationChanged(final Location location) {
        this.iterateAndNotify(location, this.getLocationListeners(), this.listenerToReports, new Notifier<LocationListener>(){

            @Override
            public void notify(LostApiClient client, LocationListener listener) {
                listener.onLocationChanged(location);
            }
        });
    }

    @Override
    public void sendPendingIntent(final Context context, final Location location, final LocationAvailability availability, final LocationResult result) {
        this.iterateAndNotify(location, this.getPendingIntents(), this.intentToReports, new Notifier<PendingIntent>(){

            @Override
            public void notify(LostApiClient client, PendingIntent pendingIntent) {
                LostClientManager.this.fireIntent(context, pendingIntent, location, availability, result);
            }
        });
    }

    @Override
    public void reportLocationResult(Location location, final LocationResult result) {
        this.iterateAndNotify(location, this.getLocationCallbacks(), this.callbackToReports, new Notifier<LocationCallback>(){

            @Override
            public void notify(LostApiClient client, LocationCallback callback) {
                LostClientManager.this.notifyCallback(client, callback, result);
            }
        });
    }

    @Override
    public void notifyLocationAvailability(LocationAvailability availability) {
        for (LostClientWrapper wrapper : this.clients.values()) {
            for (LocationCallback callback : wrapper.locationCallbacks()) {
                this.notifyAvailability(wrapper.client(), callback, availability);
            }
        }
    }

    @Override
    public boolean hasNoListeners() {
        for (LostClientWrapper wrapper : this.clients.values()) {
            if (wrapper.locationListeners().isEmpty() && wrapper.pendingIntents().isEmpty() && wrapper.locationCallbacks().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    void clearClients() {
        this.clients.clear();
    }

    @Override
    public Map<LostApiClient, Set<LocationListener>> getLocationListeners() {
        HashMap<LostApiClient, Set<LocationListener>> clientToListeners = new HashMap<LostApiClient, Set<LocationListener>>();
        for (LostApiClient client : this.clients.keySet()) {
            clientToListeners.put(client, this.clients.get(client).locationListeners());
        }
        return clientToListeners;
    }

    @Override
    public Map<LostApiClient, Set<PendingIntent>> getPendingIntents() {
        HashMap<LostApiClient, Set<PendingIntent>> clientToPendingIntents = new HashMap<LostApiClient, Set<PendingIntent>>();
        for (LostApiClient client : this.clients.keySet()) {
            clientToPendingIntents.put(client, this.clients.get(client).pendingIntents());
        }
        return clientToPendingIntents;
    }

    @Override
    public Map<LostApiClient, Set<LocationCallback>> getLocationCallbacks() {
        HashMap<LostApiClient, Set<LocationCallback>> clientToLocationCallbacks = new HashMap<LostApiClient, Set<LocationCallback>>();
        for (LostApiClient client : this.clients.keySet()) {
            clientToLocationCallbacks.put(client, this.clients.get(client).locationCallbacks());
        }
        return clientToLocationCallbacks;
    }

    private void fireIntent(Context context, PendingIntent intent, Location location, LocationAvailability availability, LocationResult result) {
        try {
            Intent toSend = new Intent().putExtra("com.mapzen.android.lost.LOCATION", (Parcelable)location);
            toSend.putExtra("com.mapzen.android.lost.EXTRA_LOCATION_AVAILABILITY", (Parcelable)availability);
            toSend.putExtra("com.mapzen.android.lost.EXTRA_LOCATION_RESULT", (Parcelable)result);
            intent.send(context, 0, toSend);
        }
        catch (PendingIntent.CanceledException e) {
            Log.e((String)TAG, (String)("Unable to send pending intent: " + intent));
        }
    }

    private void notifyCallback(LostApiClient client, final LocationCallback callback, final LocationResult result) {
        Looper looper = this.clients.get(client).looperMap().get(callback);
        this.handlerFactory.run(looper, new Runnable(){

            @Override
            public void run() {
                callback.onLocationResult(result);
            }
        });
    }

    private void notifyAvailability(LostApiClient client, final LocationCallback callback, final LocationAvailability availability) {
        Looper looper = this.clients.get(client).looperMap().get(callback);
        Handler handler = new Handler(looper);
        handler.post(new Runnable(){

            @Override
            public void run() {
                callback.onLocationAvailability(availability);
            }
        });
    }

    private <T> void iterateAndNotify(Location location, Map<LostApiClient, Set<T>> clientToObj, Map<T, LocationRequestReport> objToLocationRequest, Notifier notifier) {
        for (LostApiClient client : clientToObj.keySet()) {
            if (clientToObj.get(client) == null) continue;
            for (T obj : clientToObj.get(client)) {
                LocationRequestReport report = objToLocationRequest.get(obj);
                LocationRequest request = report.locationRequest;
                Location lastReportedLocation = report.location;
                if (lastReportedLocation == null) {
                    report.location = location;
                    notifier.notify(client, obj);
                    continue;
                }
                long lastReportedTime = this.clock.getElapsedTimeInNanos(lastReportedLocation);
                long locationTime = this.clock.getElapsedTimeInNanos(location);
                long intervalSinceLastReport = (locationTime - lastReportedTime) / 1000000L;
                long fastestInterval = request.getFastestInterval();
                float smallestDisplacement = request.getSmallestDisplacement();
                float displacementSinceLastReport = location.distanceTo(lastReportedLocation);
                if (intervalSinceLastReport < fastestInterval || !(displacementSinceLastReport >= smallestDisplacement)) continue;
                report.location = location;
                notifier.notify(client, obj);
            }
        }
    }

    static interface Notifier<T> {
        public void notify(LostApiClient var1, T var2);
    }
}

