/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import android.app.PendingIntent;
import com.mapzen.android.lost.api.LocationCallback;
import com.mapzen.android.lost.api.LocationListener;
import com.mapzen.android.lost.api.LocationRequest;
import com.mapzen.android.lost.api.LostApiClient;
import com.mapzen.android.lost.internal.ClientCallbackWrapper;
import com.mapzen.android.lost.internal.RequestManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LostRequestManager
implements RequestManager {
    private static LostRequestManager instance;
    private Map<ClientCallbackWrapper, List<LocationRequest>> clientCallbackToLocationRequests = new HashMap<ClientCallbackWrapper, List<LocationRequest>>();

    LostRequestManager() {
    }

    public static LostRequestManager shared() {
        if (instance == null) {
            instance = new LostRequestManager();
        }
        return instance;
    }

    @Override
    public void requestLocationUpdates(LostApiClient client, LocationRequest request, LocationListener listener) {
        ClientCallbackWrapper wrapper = this.getWrapper(client, listener);
        this.registerRequest(wrapper, request);
    }

    @Override
    public void requestLocationUpdates(LostApiClient client, LocationRequest request, LocationCallback callback) {
        ClientCallbackWrapper wrapper = this.getWrapper(client, callback);
        this.registerRequest(wrapper, request);
    }

    @Override
    public void requestLocationUpdates(LostApiClient client, LocationRequest request, PendingIntent callbackIntent) {
        ClientCallbackWrapper wrapper = this.getWrapper(client, callbackIntent);
        this.registerRequest(wrapper, request);
    }

    @Override
    public List<LocationRequest> removeLocationUpdates(LostApiClient client, LocationListener listener) {
        ClientCallbackWrapper wrapper = this.getWrapper(client, listener);
        return this.getRequestOnlyUsedBy(wrapper);
    }

    @Override
    public List<LocationRequest> removeLocationUpdates(LostApiClient client, PendingIntent callbackIntent) {
        ClientCallbackWrapper wrapper = this.getWrapper(client, callbackIntent);
        return this.getRequestOnlyUsedBy(wrapper);
    }

    @Override
    public List<LocationRequest> removeLocationUpdates(LostApiClient client, LocationCallback callback) {
        ClientCallbackWrapper wrapper = this.getWrapper(client, callback);
        return this.getRequestOnlyUsedBy(wrapper);
    }

    private <T> ClientCallbackWrapper getWrapper(LostApiClient client, T callback) {
        return new ClientCallbackWrapper(client, callback);
    }

    private void registerRequest(ClientCallbackWrapper wrapper, LocationRequest request) {
        List<LocationRequest> requests = this.clientCallbackToLocationRequests.get(wrapper);
        if (requests == null) {
            requests = new ArrayList<LocationRequest>();
            this.clientCallbackToLocationRequests.put(wrapper, requests);
        }
        LocationRequest r = new LocationRequest(request);
        requests.add(r);
    }

    private List<LocationRequest> getRequestOnlyUsedBy(ClientCallbackWrapper wrapper) {
        List<LocationRequest> requestsToRemove = this.clientCallbackToLocationRequests.get(wrapper);
        if (requestsToRemove == null) {
            return null;
        }
        this.clientCallbackToLocationRequests.remove(wrapper);
        return requestsToRemove;
    }

    Map<ClientCallbackWrapper, List<LocationRequest>> getClientCallbackMap() {
        return this.clientCallbackToLocationRequests;
    }
}

