/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import android.content.Context;
import android.location.Location;
import com.mapzen.android.lost.internal.LocationEngine;
import com.mapzen.android.lost.internal.ThreadSleepFactory;
import com.mapzen.android.lost.internal.TraceThread;
import com.mapzen.android.lost.internal.TraceThreadFactory;
import java.io.File;

public class MockEngine
extends LocationEngine {
    public static final String MOCK_PROVIDER = "mock";
    private Location location;
    private File traceFile;
    private TraceThreadFactory traceThreadFactory;
    protected TraceThread traceThread;

    public MockEngine(Context context, LocationEngine.Callback callback, TraceThreadFactory traceThreadFactory) {
        super(context, callback);
        this.traceThreadFactory = traceThreadFactory;
    }

    @Override
    public Location getLastLocation() {
        return this.location;
    }

    @Override
    public boolean isProviderEnabled(String provider) {
        return false;
    }

    @Override
    protected void enable() {
        if (this.traceFile != null) {
            this.traceThread = this.traceThreadFactory.createTraceThread(this.getContext(), this.traceFile, this, new ThreadSleepFactory());
            this.traceThread.start();
        }
    }

    @Override
    protected void disable() {
        if (this.traceThread != null) {
            this.traceThread.cancel();
        }
    }

    public void setLocation(Location location) {
        this.location = location;
        if (this.getCallback() != null) {
            this.getCallback().reportLocation(location);
        }
    }

    public void setTrace(File file) {
        this.traceFile = file;
    }

    public File getTrace() {
        return this.traceFile;
    }
}

