/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.android.lost.internal;

import android.content.Context;
import android.location.Location;
import android.os.Handler;
import com.mapzen.android.lost.internal.LocationRequestUnbundled;
import com.mapzen.android.lost.internal.MockEngine;
import com.mapzen.android.lost.internal.SleepFactory;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class TraceThread
extends Thread {
    private static final String TAG_TRACK_POINT = "trkpt";
    private static final String TAG_SPEED = "speed";
    private static final String TAG_LAT = "lat";
    private static final String TAG_LNG = "lon";
    private boolean canceled;
    private Location previous;
    private final Context context;
    private final File traceFile;
    private final MockEngine engine;
    private final SleepFactory sleepFactory;

    TraceThread(Context context, File traceFile, MockEngine engine, SleepFactory sleepFactory) {
        this.context = context;
        this.traceFile = traceFile;
        this.engine = engine;
        this.sleepFactory = sleepFactory;
    }

    public void cancel() {
        this.canceled = true;
        this.interrupt();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void run() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        XPath xPath = XPathFactory.newInstance().newXPath();
        String expression = "//trkpt";
        String speedExpression = "//speed";
        NodeList nodeList = null;
        NodeList speedList = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(this.traceFile);
            nodeList = (NodeList)xPath.compile("//trkpt").evaluate(document, XPathConstants.NODESET);
            speedList = (NodeList)xPath.compile("//speed").evaluate(document, XPathConstants.NODESET);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        this.parse(nodeList, speedList);
    }

    private void parse(NodeList nodeList, NodeList speedList) {
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.postMockLocation(this.nodeToLocation(nodeList, speedList, i));
                this.sleepFastestInterval();
            }
        }
    }

    private Location nodeToLocation(NodeList nodeList, NodeList speedList, int i) {
        Node node = nodeList.item(i);
        String lat = node.getAttributes().getNamedItem(TAG_LAT).getNodeValue();
        String lng = node.getAttributes().getNamedItem(TAG_LNG).getNodeValue();
        Location location = new Location("mock");
        location.setLatitude(Double.parseDouble(lat));
        location.setLongitude(Double.parseDouble(lng));
        location.setTime(System.currentTimeMillis());
        if (speedList.item(i) != null && speedList.item(i).getFirstChild() != null) {
            location.setSpeed(Float.parseFloat(speedList.item(i).getFirstChild().getNodeValue()));
        }
        if (this.previous != null) {
            location.setBearing(this.previous.bearingTo(location));
        }
        this.previous = location;
        return location;
    }

    private void sleepFastestInterval() {
        LocationRequestUnbundled request = this.engine.getRequest();
        if (request != null) {
            this.sleepFactory.sleep(request.getFastestInterval());
        }
    }

    private void postMockLocation(final Location mockLocation) {
        new Handler(this.context.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (!TraceThread.this.canceled) {
                    TraceThread.this.engine.setLocation(mockLocation);
                }
            }
        });
    }
}

