/*
 * Decompiled with CFR 0.152.
 */
package com.marcinmoskala.math;

import com.marcinmoskala.math.FactorialFunKt;
import com.marcinmoskala.math.PowersetExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a0\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00040\b0\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\t\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"combinations", "", "T", "combinationSize", "", "combinationsNumber", "", "combinationsWithRepetitions", "", "combinationsWithRepetitionsNumber", "DiscreteMathToolkit_main"})
public final class CombinationsExtKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Set<Set<T>> combinations(@NotNull Set<? extends T> $receiver, int combinationSize) {
        Set set;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (combinationSize < 0) {
            set = SetsKt.emptySet();
        } else if (combinationSize == 0) {
            set = SetsKt.setOf((Object)SetsKt.emptySet());
        } else if (combinationSize >= $receiver.size()) {
            set = SetsKt.setOf((Object)CollectionsKt.toSet((Iterable)$receiver));
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv = PowersetExtKt.powerset((Collection)$receiver);
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Set it = (Set)element$iv$iv;
                if (!(it.size() == combinationSize)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        return set;
    }

    public static final <T> long combinationsNumber(@NotNull Set<? extends T> $receiver, int combinationSize) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return combinationSize >= $receiver.size() || combinationSize == 0 ? 1L : (combinationSize < 0 ? 0L : FactorialFunKt.factorial($receiver.size()) / (FactorialFunKt.factorial(combinationSize) * FactorialFunKt.factorial($receiver.size() - combinationSize)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Set<Map<T, Integer>> combinationsWithRepetitions(@NotNull Set<? extends T> $receiver, int combinationSize) {
        Set set;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (combinationSize < 0) {
            set = SetsKt.emptySet();
        } else if (combinationSize == 0) {
            set = SetsKt.setOf((Object)MapsKt.emptyMap());
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv = CombinationsExtKt.combinationsWithRepetitions($receiver, combinationSize - 1);
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                void $receiver$iv$iv2;
                Iterable $receiver$iv2;
                Map subset = (Map)element$iv$iv;
                Iterable iterable2 = $receiver$iv2 = (Iterable)$receiver;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                Iterator iterator = $receiver$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv2;
                    Map map = MapsKt.plus((Map)subset, (Pair)TuplesKt.to((Object)it, (Object)(((Number)subset.getOrDefault(it, 0)).intValue() + 1)));
                    collection.add(map);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        return set;
    }

    public static final <T> long combinationsWithRepetitionsNumber(@NotNull Set<? extends T> $receiver, int combinationSize) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return combinationSize == 0 ? 1L : (combinationSize < 0 ? 0L : FactorialFunKt.factorial($receiver.size() + combinationSize - 1) / (FactorialFunKt.factorial(combinationSize) * FactorialFunKt.factorial($receiver.size() - 1)));
    }
}

