/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.helm.jni;

import com.marcnuri.helm.jni.HelmLib;
import com.marcnuri.helm.jni.RemoteJarLoader;
import com.sun.jna.Native;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceLoader;

public interface NativeLibrary {
    public static NativeLibrary getInstance() {
        ClassLoader remoteJar;
        NativeLibrary nativeLibrary = NativeLibrary.serviceProviderLibrary(null);
        if (nativeLibrary != null || (remoteJar = RemoteJarLoader.remoteJar()) != null && (nativeLibrary = NativeLibrary.serviceProviderLibrary(remoteJar)) != null) {
            return nativeLibrary;
        }
        throw new IllegalStateException("No NativeLibrary implementation found, please add one of the supported dependencies to your project");
    }

    public static NativeLibrary serviceProviderLibrary(ClassLoader classLoader) {
        Iterator<NativeLibrary> iterator = ServiceLoader.load(NativeLibrary.class, classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader).iterator();
        if (iterator.hasNext()) {
            NativeLibrary nativeLibrary = iterator.next();
            return nativeLibrary;
        }
        return null;
    }

    public String getBinaryName();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public HelmLib load() {
        Path temp = this.createTempDirectory();
        Path tempBinary = temp.resolve(this.getBinaryName());
        tempBinary.toFile().deleteOnExit();
        try (InputStream stream = Objects.requireNonNull(this.getClass().getResourceAsStream("/" + this.getBinaryName()));){
            Files.copy(stream, tempBinary, StandardCopyOption.REPLACE_EXISTING);
            HelmLib helmLib = (HelmLib)Native.load((String)tempBinary.toAbsolutePath().toString(), HelmLib.class);
            Runtime.getRuntime().addShutdownHook(new Thread(helmLib::RepoServerStopAll));
            HelmLib helmLib2 = helmLib;
            return helmLib2;
        }
        catch (IOException exception) {
            throw new IllegalStateException("Unable to load native library " + this.getBinaryName(), exception);
        }
    }

    default public Path createTempDirectory() {
        try {
            Path temp = Files.createTempDirectory("helm-java", new FileAttribute[0]);
            temp.toFile().deleteOnExit();
            return temp;
        }
        catch (IOException exception) {
            throw new IllegalStateException("Unable to create temporary directory", exception);
        }
    }
}

