/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.plugins.gradle.api;

import com.marcnuri.plugins.gradle.api.GradleApiLog;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class GradleApi
implements Callable<Collection<String>> {
    static final String GRADLE_GROUP_ID = "org.gradle";
    static final String GRADLE_ALL_ARTIFACT_ID = "gradle-all";
    private static final String GRADLE_DISTRIBUTION_BASE_URL = "https://services.gradle.org/distributions/";
    private final GradleApiLog log;
    private final boolean forceUpdate;
    private final String gradleVersion;
    private final Path repositoryBaseDir;
    private final Path gradleBinZip;

    public GradleApi(GradleApiLog log, boolean forceUpdate, String gradleVersion, Path repositoryBaseDir) {
        this.log = log;
        this.gradleVersion = gradleVersion;
        this.forceUpdate = forceUpdate;
        this.repositoryBaseDir = repositoryBaseDir;
        this.gradleBinZip = this.resolveGroupDir().resolve(GRADLE_ALL_ARTIFACT_ID).resolve(gradleVersion).resolve("gradle-" + gradleVersion + "-bin.zip");
    }

    @Override
    public final Collection<String> call() {
        if (this.forceUpdate || !this.gradleBinZip.toFile().exists()) {
            this.download();
        }
        return this.extract();
    }

    private void download() {
        this.log.info("Downloading Gradle " + this.gradleVersion + "...");
        try {
            URL remoteBin = new URL(GRADLE_DISTRIBUTION_BASE_URL + this.gradleBinZip.toFile().getName());
            Files.createDirectories(this.resolveGroupDir(), new FileAttribute[0]);
            GradleApi.writeToFile(remoteBin.openStream(), this.gradleBinZip);
            this.writePom(GRADLE_ALL_ARTIFACT_ID, "pom");
            this.log.info("Gradle " + this.gradleVersion + " download complete");
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't download Gradle " + this.gradleVersion, e);
        }
    }

    private Set<String> extract() {
        this.log.info("Extracting Gradle " + this.gradleVersion + " to local Maven repository...");
        HashSet<String> artifactIds = new HashSet<String>();
        try (ZipFile zipFile = new ZipFile(this.gradleBinZip.toFile());){
            Set applicableEntries = zipFile.stream().filter(e -> e.getName().indexOf("gradle-", e.getName().lastIndexOf(47) + 1) >= 0).filter(e -> e.getName().endsWith("-" + this.gradleVersion + ".jar")).collect(Collectors.toSet());
            for (ZipEntry entry : applicableEntries) {
                String artifactJar = entry.getName().substring(entry.getName().lastIndexOf(47) + 1);
                String artifactId = artifactJar.substring(0, artifactJar.lastIndexOf('-' + this.gradleVersion));
                Path artifactJarPath = this.resolveArtifactJar(artifactId);
                if (this.forceUpdate || !artifactJarPath.toFile().exists()) {
                    Files.createDirectories(artifactJarPath.getParent(), new FileAttribute[0]);
                    GradleApi.writeToFile(zipFile.getInputStream(entry), artifactJarPath);
                    this.writePom(artifactId, "jar");
                }
                artifactIds.add(artifactId);
            }
        }
        catch (IOException e2) {
            throw new IllegalStateException("Couldn't extract Gradle " + this.gradleVersion, e2);
        }
        return artifactIds;
    }

    private Path resolveArtifactJar(String artifact) {
        return this.resolveArtifactDir(artifact).resolve(artifact + "-" + this.gradleVersion + ".jar");
    }

    private Path resolveArtifactDir(String artifact) {
        return this.resolveGroupDir().resolve(artifact).resolve(this.gradleVersion);
    }

    private Path resolveGroupDir() {
        return this.repositoryBaseDir.resolve("org").resolve("gradle");
    }

    private void writePom(String artifact, String packaging) throws IOException {
        Path pom = this.resolveArtifactDir(artifact).resolve(artifact + "-" + this.gradleVersion + ".pom");
        Files.deleteIfExists(pom);
        Files.write(Files.createFile(pom, new FileAttribute[0]), Arrays.asList("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">", "  <modelVersion>4.0.0</modelVersion>", "  <groupId>org.gradle</groupId>", "  <artifactId>" + artifact + "</artifactId>", "  <version>" + this.gradleVersion + "</version>", "  <packaging>" + packaging + "</packaging>", "</project>"), new OpenOption[0]);
    }

    private static void writeToFile(InputStream stream, Path targetPath) throws IOException {
        Files.deleteIfExists(targetPath);
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        Files.createFile(targetPath, new FileAttribute[0]);
        try (ReadableByteChannel in = Channels.newChannel(stream);
             FileChannel out = FileChannel.open(targetPath, StandardOpenOption.WRITE);){
            out.transferFrom(in, 0L, Long.MAX_VALUE);
        }
    }
}

