/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.plugins.gradle.api;

import com.marcnuri.plugins.gradle.api.GradleApi;
import com.marcnuri.plugins.gradle.api.GradleApiLog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

@Named(value="gradle-api")
public class GradleApiExtension
extends AbstractMavenLifecycleParticipant {
    public void afterProjectsRead(MavenSession session) {
        GradleApiLog log = new GradleApiLog(session.getRequest().getLoggingLevel());
        HashMap projects = new HashMap();
        for (MavenProject project : session.getProjects()) {
            project.getDependencies().stream().filter(d -> d.getGroupId().equals("org.gradle")).filter(d -> d.getArtifactId().equals("gradle-all")).findAny().ifPresent(d -> projects.put(project, d));
        }
        Map artifactsForVersion = projects.values().stream().map(Dependency::getVersion).collect(Collectors.toMap(Function.identity(), v -> new ArrayList(), (a, b) -> a));
        for (Map.Entry entry : artifactsForVersion.entrySet()) {
            entry.getValue().addAll(new GradleApi(log, session.getRequest().isUpdateSnapshots(), (String)entry.getKey(), new File(session.getLocalRepository().getBasedir()).toPath()).call());
        }
        for (Map.Entry<Object, List<Object>> entry : projects.entrySet()) {
            Dependency dependency = (Dependency)entry.getValue();
            ((MavenProject)entry.getKey()).getDependencies().remove(dependency);
            for (String artifactId : artifactsForVersion.get(dependency.getVersion())) {
                Dependency newDependency = new Dependency();
                newDependency.setGroupId("org.gradle");
                newDependency.setArtifactId(artifactId);
                newDependency.setVersion(dependency.getVersion());
                newDependency.setScope(dependency.getScope());
                ((MavenProject)entry.getKey()).getDependencies().add(newDependency);
            }
        }
    }
}

