/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.plugins.gradle.api;

import com.marcnuri.plugins.gradle.api.GradleApi;
import com.marcnuri.plugins.gradle.api.GradleApiLog;
import java.io.File;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

@Named(value="gradle-api")
public class GradleApiExtension
extends AbstractMavenLifecycleParticipant {
    public void afterProjectsRead(MavenSession session) {
        GradleApiLog log = new GradleApiLog(session.getRequest().getLoggingLevel());
        HashMap projects = new HashMap();
        for (MavenProject project : session.getProjects()) {
            project.getDependencies().stream().filter(d -> d.getGroupId().equals("org.gradle")).filter(d -> d.getArtifactId().equals("gradle-all")).findAny().ifPresent(d -> projects.put(project, d));
        }
        Map artifactsForVersion = projects.values().stream().map(Dependency::getVersion).collect(Collectors.toMap(Function.identity(), v -> new ArrayList(), (a, b) -> a));
        for (Map.Entry entry : artifactsForVersion.entrySet()) {
            entry.getValue().addAll(new GradleApi(log, GradleApiExtension.selectProxy(session.getRequest()), session.getRequest().isUpdateSnapshots(), (String)entry.getKey(), new File(session.getLocalRepository().getBasedir()).toPath()).call());
        }
        for (Map.Entry<Object, List<Object>> entry : projects.entrySet()) {
            Dependency dependency = (Dependency)entry.getValue();
            ((MavenProject)entry.getKey()).getDependencies().remove(dependency);
            for (String artifactId : artifactsForVersion.get(dependency.getVersion())) {
                Dependency newDependency = new Dependency();
                newDependency.setGroupId("org.gradle");
                newDependency.setArtifactId(artifactId);
                newDependency.setVersion(dependency.getVersion());
                newDependency.setScope(dependency.getScope());
                ((MavenProject)entry.getKey()).getDependencies().add(newDependency);
            }
        }
    }

    private static Proxy selectProxy(MavenExecutionRequest request) {
        try {
            Optional<Proxy> mavenProxy;
            URL gradleBaseUrl = new URL("https://services.gradle.org/distributions/");
            Optional<Proxy> propertiesProxy = ProxySelector.getDefault().select(gradleBaseUrl.toURI()).stream().filter(p -> p.type() != Proxy.Type.DIRECT).findAny();
            if (propertiesProxy.isPresent()) {
                if (System.getProperties().get(gradleBaseUrl.getProtocol() + ".proxyUser") != null && System.getProperty(gradleBaseUrl.getProtocol() + ".proxyPassword") != null) {
                    GradleApiExtension.setAuthenticator(System.getProperty(gradleBaseUrl.getProtocol() + ".proxyUser"), System.getProperty(gradleBaseUrl.getProtocol() + ".proxyPassword"));
                }
                return propertiesProxy.get();
            }
            if (request.getProxies() != null && !request.getProxies().isEmpty() && (mavenProxy = request.getProxies().stream().filter(p -> p.isActive() && p.getProtocol().equalsIgnoreCase(gradleBaseUrl.getProtocol())).findAny().map(p -> {
                if (p.getUsername() != null && p.getPassword() != null) {
                    GradleApiExtension.setAuthenticator(p.getUsername(), p.getPassword());
                }
                return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(p.getHost(), p.getPort()));
            })).isPresent()) {
                return mavenProxy.get();
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalStateException("Invalid Gradle base URL", e);
        }
        return null;
    }

    static void setAuthenticator(final String userName, final String password) {
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userName, password.toCharArray());
            }
        });
    }
}

