/*
 * Decompiled with CFR 0.152.
 */
package com.mariten.kanatools;

public class KanaAppraiser {
    public static final char ZENKAKU_HIRAGANA_FIRST = '\u3041';
    public static final char ZENKAKU_HIRAGANA_LAST_FOR_CONVERT = '\u3093';
    public static final char ZENKAKU_HIRAGANA_LAST = '\u3096';
    public static final char HANKAKU_KATAKANA_FIRST = '\uff66';
    public static final char HANKAKU_KATAKANA_LAST = '\uff9d';
    public static final char ZENKAKU_KATAKANA_FIRST = '\u30a1';
    public static final char ZENKAKU_KATAKANA_LAST_FOR_CONVERT = '\u30f3';
    public static final char ZENKAKU_KATAKANA_LAST = '\u30fa';
    public static final char HANKAKU_PUNCTUATION_FIRST = '\uff61';
    public static final char HANKAKU_PUNCTUATION_LAST = '\uff9f';
    public static final char HANKAKU_PUNCTUATION_ONBIKI = '\uff70';
    public static final char ZENKAKU_PUNCTUATION_FIRST = '\u3001';
    public static final char ZENKAKU_PUNCTUATION_LAST = '\u301c';
    public static final char ZENKAKU_PUNCTUATION_HG_FIRST = '\u309b';
    public static final char ZENKAKU_PUNCTUATION_HG_LAST = '\u309e';
    public static final char ZENKAKU_PUNCTUATION_KK_FIRST = '\u30fb';
    public static final char ZENKAKU_PUNCTUATION_KK_LAST = '\u30fe';
    public static final char HANKAKU_NUMBER_FIRST = '0';
    public static final char HANKAKU_NUMBER_LAST = '9';
    public static final char ZENKAKU_NUMBER_FIRST = '\uff10';
    public static final char ZENKAKU_NUMBER_LAST = '\uff19';
    public static final char HANKAKU_LETTER_UPPER_FIRST = 'A';
    public static final char HANKAKU_LETTER_UPPER_LAST = 'Z';
    public static final char HANKAKU_LETTER_LOWER_FIRST = 'a';
    public static final char HANKAKU_LETTER_LOWER_LAST = 'z';
    public static final char ZENKAKU_LETTER_UPPER_FIRST = '\uff21';
    public static final char ZENKAKU_LETTER_UPPER_LAST = '\uff3a';
    public static final char ZENKAKU_LETTER_LOWER_FIRST = '\uff41';
    public static final char ZENKAKU_LETTER_LOWER_LAST = '\uff5a';
    public static final char HANKAKU_SPACE = ' ';
    public static final char HANKAKU_ASCII_FIRST = '!';
    public static final char HANKAKU_ASCII_LAST = '~';
    public static final char ZENKAKU_SPACE = '\u3000';
    public static final char ZENKAKU_ASCII_FIRST = '\uff01';
    public static final char ZENKAKU_ASCII_LAST = '\uff5e';

    public static boolean isZenkakuHiragana(char eval_char) {
        return eval_char >= '\u3041' && eval_char <= '\u3096';
    }

    public static boolean isZenkakuHiraganaWithKatakanaEquivalent(char eval_char) {
        return eval_char >= '\u3041' && eval_char <= '\u3093';
    }

    public static boolean isHankakuKatakana(char eval_char) {
        return eval_char >= '\uff66' && eval_char <= '\uff9d' && eval_char != '\uff70';
    }

    public static boolean isZenkakuKatakana(char eval_char) {
        return eval_char >= '\u30a1' && eval_char <= '\u30fa';
    }

    public static boolean isZenkakuKatakanaWithHiraganaEquivalent(char eval_char) {
        return eval_char >= '\u30a1' && eval_char <= '\u30f3';
    }

    public static boolean isHankakuKutoten(char eval_char) {
        return eval_char >= '\uff61' && eval_char <= '\uff9f' && !KanaAppraiser.isHankakuKatakana(eval_char);
    }

    public static boolean isZenkakuKutoten(char eval_char) {
        return eval_char >= '\u3001' && eval_char <= '\u301c' || eval_char >= '\u309b' && eval_char <= '\u309e' || eval_char >= '\u30fb' && eval_char <= '\u30fe';
    }

    public static boolean isHankakuNumber(char eval_char) {
        return eval_char >= '0' && eval_char <= '9';
    }

    public static boolean isZenkakuNumber(char eval_char) {
        return eval_char >= '\uff10' && eval_char <= '\uff19';
    }

    public static boolean isHankakuLetter(char eval_char) {
        if (eval_char >= 'A' && eval_char <= 'Z') {
            return true;
        }
        return eval_char >= 'a' && eval_char <= 'z';
    }

    public static boolean isZenkakuLetter(char eval_char) {
        if (eval_char >= '\uff21' && eval_char <= '\uff3a') {
            return true;
        }
        return eval_char >= '\uff41' && eval_char <= '\uff5a';
    }

    public static boolean isHankakuAscii(char eval_char) {
        return eval_char >= '!' && eval_char <= '~';
    }

    public static boolean isZenkakuAscii(char eval_char) {
        return eval_char >= '\uff01' && eval_char <= '\uff5e';
    }
}

