/*
 * Decompiled with CFR 0.152.
 */
package com.mariten.kanatools;

import com.mariten.kanatools.KanaAppraiser;
import java.util.HashMap;
import java.util.Map;

public class KanaConverter {
    public static final int OP_HAN_ASCII_TO_ZEN_ASCII = 1;
    public static final int OP_HAN_LETTER_TO_ZEN_LETTER = 2;
    public static final int OP_HAN_NUMBER_TO_ZEN_NUMBER = 4;
    public static final int OP_HAN_SPACE_TO_ZEN_SPACE = 8;
    public static final int OP_HAN_KATA_TO_ZEN_KATA = 256;
    public static final int OP_HAN_KATA_TO_ZEN_HIRA = 512;
    public static final int OP_KEEP_DIACRITIC_MARKS_APART = 0x100000;
    public static final int OP_ZEN_ASCII_TO_HAN_ASCII = 16;
    public static final int OP_ZEN_LETTER_TO_HAN_LETTER = 32;
    public static final int OP_ZEN_NUMBER_TO_HAN_NUMBER = 64;
    public static final int OP_ZEN_SPACE_TO_HAN_SPACE = 128;
    public static final int OP_ZEN_KATA_TO_HAN_KATA = 4096;
    public static final int OP_ZEN_HIRA_TO_HAN_KATA = 8192;
    public static final int OP_ZEN_HIRA_TO_ZEN_KATA = 65536;
    public static final int OP_ZEN_KATA_TO_ZEN_HIRA = 131072;
    public static final Map<Character, Integer> LETTER_OP_CODE_LOOKUP = new HashMap<Character, Integer>();
    public static final char HANKAKU_VOICED_MARK = '\uff9e';
    public static final char HANKAKU_ASPIRATED_MARK = '\uff9f';
    protected static final Map<Character, Character> MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED;
    protected static final Map<Character, Character> MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED;
    protected static final Map<Character, Character> MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_ASPIRATED;
    protected static final Map<Character, Character> MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA;
    protected static final Map<Character, Character> MAPPING_HANKAKU_DIACRITIC_SUFFIXES;
    public static final int OFFSET_ZENKAKU_HIRAGANA_TO_ZENKAKU_KATAKANA = 96;
    public static final int OFFSET_HANKAKU_ASCII_TO_ZENKAKU_ASCII = 65248;

    public static String convertKana(String original_string, int conversion_ops, String chars_to_ignore) {
        if (original_string.equals("")) {
            return "";
        }
        if (conversion_ops <= 0) {
            return original_string;
        }
        boolean do_collapse_on_hankaku_diacritic = true;
        if ((conversion_ops & 0x100000) != 0) {
            do_collapse_on_hankaku_diacritic = false;
        }
        int char_count = original_string.length();
        StringBuffer new_string = new StringBuffer();
        int i = 0;
        while (i < char_count) {
            boolean is_ignore_char;
            char this_char;
            char current_char = this_char = original_string.charAt(i);
            char hankaku_diacritic_suffix = '\u0000';
            char next_char = '\u0000';
            if (i < char_count - 1) {
                next_char = original_string.charAt(i + 1);
            }
            if (is_ignore_char = KanaConverter.isIgnoreChar(current_char, chars_to_ignore)) {
                new_string.append(current_char);
                ++i;
                continue;
            }
            if (0 != (conversion_ops & 1)) {
                current_char = KanaConverter.convertHankakuAsciiToZenkakuAscii(current_char);
            }
            if (current_char == this_char && 0 != (conversion_ops & 2)) {
                current_char = KanaConverter.convertHankakuLetterToZenkakuLetter(current_char);
            }
            if (current_char == this_char && 0 != (conversion_ops & 4)) {
                current_char = KanaConverter.convertHankakuNumberToZenkakuNumber(current_char);
            }
            if (current_char == this_char && 0 != (conversion_ops & 8)) {
                current_char = KanaConverter.convertHankakuSpaceToZenkakuSpace(current_char);
            }
            if (current_char == this_char && (0 != (conversion_ops & 0x100) || 0 != (conversion_ops & 0x200))) {
                char collapsed_char_for_check = current_char;
                boolean performed_hankaku_conversion = false;
                if (do_collapse_on_hankaku_diacritic) {
                    collapsed_char_for_check = KanaConverter.convertDiacriticHankakuKanaToZenkaku(current_char, next_char);
                }
                if (collapsed_char_for_check != current_char) {
                    current_char = collapsed_char_for_check;
                    performed_hankaku_conversion = true;
                    ++i;
                } else {
                    char converted_current_char = KanaConverter.convertUnvoicedHankakuKanaToZenkaku(current_char);
                    if (converted_current_char != current_char) {
                        current_char = converted_current_char;
                        performed_hankaku_conversion = true;
                    }
                }
                if (performed_hankaku_conversion && 0 == (conversion_ops & 0x100)) {
                    current_char = KanaConverter.convertZenkakuKatakanaToZenkakuHiragana(current_char);
                }
            }
            if (current_char == this_char && 0 != (conversion_ops & 0x10)) {
                current_char = KanaConverter.convertZenkakuAsciiToHankakuAscii(current_char);
            }
            if (current_char == this_char && 0 != (conversion_ops & 0x20)) {
                current_char = KanaConverter.convertZenkakuLetterToHankakuLetter(current_char);
            }
            if (current_char == this_char && 0 != (conversion_ops & 0x40)) {
                current_char = KanaConverter.convertZenkakuNumberToHankakuNumber(current_char);
            }
            if (current_char == this_char && 0 != (conversion_ops & 0x80)) {
                current_char = KanaConverter.convertZenkakuSpaceToHankakuSpace(current_char);
            }
            if (current_char == this_char && 0 != (conversion_ops & 0x1000)) {
                hankaku_diacritic_suffix = KanaConverter.determineHankakuDiacriticSuffix(current_char);
                current_char = KanaConverter.convertZenkakuKatakanaToHankakuKatakana(current_char);
            }
            char full_katakana_to_hiragana_result = KanaConverter.convertZenkakuKatakanaToZenkakuHiragana(current_char);
            if (current_char == this_char && full_katakana_to_hiragana_result == current_char && (0 != (conversion_ops & 0x10000) || 0 != (conversion_ops & 0x2000))) {
                current_char = KanaConverter.convertZenkakuHiraganaToZenkakuKatakana(current_char);
                if (0 != (conversion_ops & 0x2000)) {
                    hankaku_diacritic_suffix = KanaConverter.determineHankakuDiacriticSuffix(current_char);
                    current_char = KanaConverter.convertZenkakuKatakanaToHankakuKatakana(current_char);
                }
            }
            if (current_char == this_char && 0 != (conversion_ops & 0x20000)) {
                current_char = full_katakana_to_hiragana_result;
            }
            new_string.append(current_char);
            if (hankaku_diacritic_suffix == '\uff9e' || hankaku_diacritic_suffix == '\uff9f') {
                new_string.append(hankaku_diacritic_suffix);
            }
            ++i;
        }
        return new_string.toString();
    }

    public static String convertKana(String original_string, int conversion_ops) {
        return KanaConverter.convertKana(original_string, conversion_ops, "");
    }

    public static String convertKana(String original_string, String conversion_ops_string, String chars_to_ignore) {
        int conversion_ops = KanaConverter.createOpsArrayFromString(conversion_ops_string);
        return KanaConverter.convertKana(original_string, conversion_ops, chars_to_ignore);
    }

    public static String convertKana(String original_string, String conversion_ops_string) {
        return KanaConverter.convertKana(original_string, conversion_ops_string, "");
    }

    protected static char convertHankakuAsciiToZenkakuAscii(char target) {
        if (KanaAppraiser.isHankakuAscii(target)) {
            return (char)(target + 65248);
        }
        if (target == ' ') {
            return '\u3000';
        }
        return target;
    }

    protected static char convertZenkakuAsciiToHankakuAscii(char target) {
        if (KanaAppraiser.isZenkakuAscii(target)) {
            return (char)(target - 65248);
        }
        if (target == '\u3000') {
            return ' ';
        }
        return target;
    }

    protected static char convertZenkakuHiraganaToZenkakuKatakana(char target) {
        if (KanaAppraiser.isZenkakuHiraganaWithKatakanaEquivalent(target)) {
            return (char)(target + 96);
        }
        return target;
    }

    protected static char convertZenkakuKatakanaToZenkakuHiragana(char target) {
        if (KanaAppraiser.isZenkakuKatakanaWithHiraganaEquivalent(target)) {
            return (char)(target - 96);
        }
        return target;
    }

    protected static char convertUnvoicedHankakuKanaToZenkaku(char target) {
        if (MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.containsKey(Character.valueOf(target))) {
            return MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.get(Character.valueOf(target)).charValue();
        }
        return target;
    }

    protected static char convertDiacriticHankakuKanaToZenkaku(char target, char diacritic_mark) {
        if (diacritic_mark == '\uff9e' && MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.containsKey(Character.valueOf(target))) {
            return MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.get(Character.valueOf(target)).charValue();
        }
        if (diacritic_mark == '\uff9f' && MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_ASPIRATED.containsKey(Character.valueOf(target))) {
            return MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_ASPIRATED.get(Character.valueOf(target)).charValue();
        }
        return target;
    }

    protected static char convertZenkakuKatakanaToHankakuKatakana(char target) {
        if (MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.containsKey(Character.valueOf(target))) {
            return MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.get(Character.valueOf(target)).charValue();
        }
        return target;
    }

    protected static char determineHankakuDiacriticSuffix(char target) {
        if (MAPPING_HANKAKU_DIACRITIC_SUFFIXES.containsKey(Character.valueOf(target))) {
            return MAPPING_HANKAKU_DIACRITIC_SUFFIXES.get(Character.valueOf(target)).charValue();
        }
        return '\u0000';
    }

    protected static char convertHankakuNumberToZenkakuNumber(char target) {
        if (KanaAppraiser.isHankakuNumber(target)) {
            return (char)(target + 65248);
        }
        return target;
    }

    protected static char convertZenkakuNumberToHankakuNumber(char target) {
        if (KanaAppraiser.isZenkakuNumber(target)) {
            return (char)(target - 65248);
        }
        return target;
    }

    protected static char convertHankakuLetterToZenkakuLetter(char target) {
        if (KanaAppraiser.isHankakuLetter(target)) {
            return (char)(target + 65248);
        }
        return target;
    }

    protected static char convertZenkakuLetterToHankakuLetter(char target) {
        if (KanaAppraiser.isZenkakuLetter(target)) {
            return (char)(target - 65248);
        }
        return target;
    }

    protected static char convertHankakuSpaceToZenkakuSpace(char target) {
        if (target == ' ') {
            return '\u3000';
        }
        return target;
    }

    protected static char convertZenkakuSpaceToHankakuSpace(char target) {
        if (target == '\u3000') {
            return ' ';
        }
        return target;
    }

    protected static boolean isIgnoreChar(char char_to_check, String chars_to_ignore) {
        int ignore_char_count = chars_to_ignore.length();
        for (int i = 0; i < ignore_char_count; ++i) {
            if (char_to_check != chars_to_ignore.charAt(i)) continue;
            return true;
        }
        return false;
    }

    private static int createOpsArrayFromString(String php_style_options_string) {
        int char_op_count = php_style_options_string.length();
        int conversion_op_flags = 0;
        for (int i = 0; i < char_op_count; ++i) {
            char php_style_op_code = php_style_options_string.charAt(i);
            if (!LETTER_OP_CODE_LOOKUP.containsKey(Character.valueOf(php_style_op_code))) continue;
            conversion_op_flags |= LETTER_OP_CODE_LOOKUP.get(Character.valueOf(php_style_op_code)).intValue();
        }
        return conversion_op_flags;
    }

    static {
        LETTER_OP_CODE_LOOKUP.put(Character.valueOf('A'), 1);
        LETTER_OP_CODE_LOOKUP.put(Character.valueOf('a'), 16);
        LETTER_OP_CODE_LOOKUP.put(Character.valueOf('C'), 65536);
        LETTER_OP_CODE_LOOKUP.put(Character.valueOf('c'), 131072);
        LETTER_OP_CODE_LOOKUP.put(Character.valueOf('H'), 512);
        LETTER_OP_CODE_LOOKUP.put(Character.valueOf('h'), 8192);
        LETTER_OP_CODE_LOOKUP.put(Character.valueOf('K'), 256);
        LETTER_OP_CODE_LOOKUP.put(Character.valueOf('k'), 4096);
        LETTER_OP_CODE_LOOKUP.put(Character.valueOf('N'), 4);
        LETTER_OP_CODE_LOOKUP.put(Character.valueOf('n'), 64);
        LETTER_OP_CODE_LOOKUP.put(Character.valueOf('R'), 2);
        LETTER_OP_CODE_LOOKUP.put(Character.valueOf('r'), 32);
        LETTER_OP_CODE_LOOKUP.put(Character.valueOf('S'), 8);
        LETTER_OP_CODE_LOOKUP.put(Character.valueOf('s'), 128);
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED = new HashMap<Character, Character>();
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff61'), Character.valueOf('\u3002'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff62'), Character.valueOf('\u300c'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff63'), Character.valueOf('\u300d'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff64'), Character.valueOf('\u3001'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff65'), Character.valueOf('\u30fb'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff66'), Character.valueOf('\u30f2'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff67'), Character.valueOf('\u30a1'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff68'), Character.valueOf('\u30a3'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff69'), Character.valueOf('\u30a5'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff6a'), Character.valueOf('\u30a7'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff6b'), Character.valueOf('\u30a9'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff6c'), Character.valueOf('\u30e3'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff6d'), Character.valueOf('\u30e5'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff6e'), Character.valueOf('\u30e7'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff6f'), Character.valueOf('\u30c3'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff70'), Character.valueOf('\u30fc'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff71'), Character.valueOf('\u30a2'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff72'), Character.valueOf('\u30a4'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff73'), Character.valueOf('\u30a6'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff74'), Character.valueOf('\u30a8'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff75'), Character.valueOf('\u30aa'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff76'), Character.valueOf('\u30ab'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff77'), Character.valueOf('\u30ad'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff78'), Character.valueOf('\u30af'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff79'), Character.valueOf('\u30b1'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff7a'), Character.valueOf('\u30b3'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff7b'), Character.valueOf('\u30b5'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff7c'), Character.valueOf('\u30b7'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff7d'), Character.valueOf('\u30b9'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff7e'), Character.valueOf('\u30bb'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff7f'), Character.valueOf('\u30bd'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff80'), Character.valueOf('\u30bf'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff81'), Character.valueOf('\u30c1'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff82'), Character.valueOf('\u30c4'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff83'), Character.valueOf('\u30c6'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff84'), Character.valueOf('\u30c8'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff85'), Character.valueOf('\u30ca'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff86'), Character.valueOf('\u30cb'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff87'), Character.valueOf('\u30cc'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff88'), Character.valueOf('\u30cd'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff89'), Character.valueOf('\u30ce'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff8a'), Character.valueOf('\u30cf'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff8b'), Character.valueOf('\u30d2'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff8c'), Character.valueOf('\u30d5'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff8d'), Character.valueOf('\u30d8'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff8e'), Character.valueOf('\u30db'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff8f'), Character.valueOf('\u30de'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff90'), Character.valueOf('\u30df'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff91'), Character.valueOf('\u30e0'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff92'), Character.valueOf('\u30e1'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff93'), Character.valueOf('\u30e2'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff94'), Character.valueOf('\u30e4'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff95'), Character.valueOf('\u30e6'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff96'), Character.valueOf('\u30e8'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff97'), Character.valueOf('\u30e9'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff98'), Character.valueOf('\u30ea'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff99'), Character.valueOf('\u30eb'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff9a'), Character.valueOf('\u30ec'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff9b'), Character.valueOf('\u30ed'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff9c'), Character.valueOf('\u30ef'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff9d'), Character.valueOf('\u30f3'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff9e'), Character.valueOf('\u309b'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_UNVOICED.put(Character.valueOf('\uff9f'), Character.valueOf('\u309c'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED = new HashMap<Character, Character>();
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff76'), Character.valueOf('\u30ac'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff77'), Character.valueOf('\u30ae'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff78'), Character.valueOf('\u30b0'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff79'), Character.valueOf('\u30b2'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff7a'), Character.valueOf('\u30b4'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff7b'), Character.valueOf('\u30b6'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff7c'), Character.valueOf('\u30b8'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff7d'), Character.valueOf('\u30ba'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff7e'), Character.valueOf('\u30bc'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff7f'), Character.valueOf('\u30be'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff80'), Character.valueOf('\u30c0'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff81'), Character.valueOf('\u30c2'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff82'), Character.valueOf('\u30c5'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff83'), Character.valueOf('\u30c7'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff84'), Character.valueOf('\u30c9'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff8a'), Character.valueOf('\u30d0'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff8b'), Character.valueOf('\u30d3'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff8c'), Character.valueOf('\u30d6'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff8d'), Character.valueOf('\u30d9'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_VOICED.put(Character.valueOf('\uff8e'), Character.valueOf('\u30dc'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_ASPIRATED = new HashMap<Character, Character>();
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_ASPIRATED.put(Character.valueOf('\uff8a'), Character.valueOf('\u30d1'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_ASPIRATED.put(Character.valueOf('\uff8b'), Character.valueOf('\u30d4'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_ASPIRATED.put(Character.valueOf('\uff8c'), Character.valueOf('\u30d7'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_ASPIRATED.put(Character.valueOf('\uff8d'), Character.valueOf('\u30da'));
        MAPPING_HANKAKU_TO_ZENKAKU_KATAKANA_ASPIRATED.put(Character.valueOf('\uff8e'), Character.valueOf('\u30dd'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA = new HashMap<Character, Character>();
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u3002'), Character.valueOf('\uff61'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u300c'), Character.valueOf('\uff62'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u300d'), Character.valueOf('\uff63'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u3001'), Character.valueOf('\uff64'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30fb'), Character.valueOf('\uff65'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30a1'), Character.valueOf('\uff67'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30a3'), Character.valueOf('\uff68'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30a5'), Character.valueOf('\uff69'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30a7'), Character.valueOf('\uff6a'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30a9'), Character.valueOf('\uff6b'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30e3'), Character.valueOf('\uff6c'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30e5'), Character.valueOf('\uff6d'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30e7'), Character.valueOf('\uff6e'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30c3'), Character.valueOf('\uff6f'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30fc'), Character.valueOf('\uff70'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30a2'), Character.valueOf('\uff71'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30a4'), Character.valueOf('\uff72'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30a6'), Character.valueOf('\uff73'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30f4'), Character.valueOf('\uff73'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30a8'), Character.valueOf('\uff74'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30aa'), Character.valueOf('\uff75'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30ab'), Character.valueOf('\uff76'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30ac'), Character.valueOf('\uff76'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30ad'), Character.valueOf('\uff77'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30ae'), Character.valueOf('\uff77'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30af'), Character.valueOf('\uff78'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30b0'), Character.valueOf('\uff78'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30b1'), Character.valueOf('\uff79'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30b2'), Character.valueOf('\uff79'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30b3'), Character.valueOf('\uff7a'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30b4'), Character.valueOf('\uff7a'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30b5'), Character.valueOf('\uff7b'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30b6'), Character.valueOf('\uff7b'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30b7'), Character.valueOf('\uff7c'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30b8'), Character.valueOf('\uff7c'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30b9'), Character.valueOf('\uff7d'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30ba'), Character.valueOf('\uff7d'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30bb'), Character.valueOf('\uff7e'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30bc'), Character.valueOf('\uff7e'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30bd'), Character.valueOf('\uff7f'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30be'), Character.valueOf('\uff7f'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30bf'), Character.valueOf('\uff80'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30c0'), Character.valueOf('\uff80'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30c1'), Character.valueOf('\uff81'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30c2'), Character.valueOf('\uff81'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30c4'), Character.valueOf('\uff82'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30c5'), Character.valueOf('\uff82'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30c6'), Character.valueOf('\uff83'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30c7'), Character.valueOf('\uff83'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30c8'), Character.valueOf('\uff84'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30c9'), Character.valueOf('\uff84'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30ca'), Character.valueOf('\uff85'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30cb'), Character.valueOf('\uff86'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30cc'), Character.valueOf('\uff87'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30cd'), Character.valueOf('\uff88'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30ce'), Character.valueOf('\uff89'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30cf'), Character.valueOf('\uff8a'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30d0'), Character.valueOf('\uff8a'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30d1'), Character.valueOf('\uff8a'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30d2'), Character.valueOf('\uff8b'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30d3'), Character.valueOf('\uff8b'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30d4'), Character.valueOf('\uff8b'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30d5'), Character.valueOf('\uff8c'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30d6'), Character.valueOf('\uff8c'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30d7'), Character.valueOf('\uff8c'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30d8'), Character.valueOf('\uff8d'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30d9'), Character.valueOf('\uff8d'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30da'), Character.valueOf('\uff8d'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30db'), Character.valueOf('\uff8e'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30dc'), Character.valueOf('\uff8e'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30dd'), Character.valueOf('\uff8e'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30de'), Character.valueOf('\uff8f'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30df'), Character.valueOf('\uff90'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30e0'), Character.valueOf('\uff91'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30e1'), Character.valueOf('\uff92'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30e2'), Character.valueOf('\uff93'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30e4'), Character.valueOf('\uff94'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30e6'), Character.valueOf('\uff95'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30e8'), Character.valueOf('\uff96'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30e9'), Character.valueOf('\uff97'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30ea'), Character.valueOf('\uff98'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30eb'), Character.valueOf('\uff99'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30ec'), Character.valueOf('\uff9a'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30ed'), Character.valueOf('\uff9b'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30ef'), Character.valueOf('\uff9c'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30ee'), Character.valueOf('\uff9c'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30f0'), Character.valueOf('\uff72'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30f1'), Character.valueOf('\uff74'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30f2'), Character.valueOf('\uff66'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u30f3'), Character.valueOf('\uff9d'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u309b'), Character.valueOf('\uff9e'));
        MAPPING_ZENKAKU_TO_HANKAKU_KATAKANA.put(Character.valueOf('\u309c'), Character.valueOf('\uff9f'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES = new HashMap<Character, Character>();
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30f4'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30ac'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30ae'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30b0'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30b2'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30b4'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30b6'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30b8'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30ba'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30bc'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30be'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30c0'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30c2'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30c5'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30c7'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30c9'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30d0'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30d3'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30d6'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30d9'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30dc'), Character.valueOf('\uff9e'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30d1'), Character.valueOf('\uff9f'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30d4'), Character.valueOf('\uff9f'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30d7'), Character.valueOf('\uff9f'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30da'), Character.valueOf('\uff9f'));
        MAPPING_HANKAKU_DIACRITIC_SUFFIXES.put(Character.valueOf('\u30dd'), Character.valueOf('\uff9f'));
    }
}

