/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.Batch;
import com.marklogic.client.datamovement.BatchFailureListener;
import com.marklogic.client.datamovement.HostAvailabilityListener;
import com.marklogic.client.datamovement.QueryBatch;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.datamovement.impl.QueryBatchImpl;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.impl.DatabaseClientImpl;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.ReaderHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.util.RequestParameters;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyTransformListener
implements QueryBatchListener {
    private static Logger logger = LoggerFactory.getLogger(ApplyTransformListener.class);
    private ServerTransform transform;
    private ApplyResult applyResult = ApplyResult.REPLACE;
    private List<QueryBatchListener> successListeners = new ArrayList<QueryBatchListener>();
    private List<QueryBatchListener> skippedListeners = new ArrayList<QueryBatchListener>();
    private List<BatchFailureListener<Batch<String>>> failureListeners = new ArrayList<BatchFailureListener<Batch<String>>>();
    private List<BatchFailureListener<QueryBatch>> queryBatchFailureListeners = new ArrayList<BatchFailureListener<QueryBatch>>();

    public ApplyTransformListener() {
        logger.debug("new ApplyTransformListener - this should print once/job; if you see this once/batch, fix your job configuration");
    }

    @Override
    public void initializeListener(QueryBatcher queryBatcher) {
        BatchFailureListener<QueryBatch> retryListener;
        HostAvailabilityListener hostAvailabilityListener = HostAvailabilityListener.getInstance(queryBatcher);
        if (hostAvailabilityListener != null && (retryListener = hostAvailabilityListener.initializeRetryListener(this)) != null) {
            this.onFailure(retryListener);
        }
    }

    @Override
    public void processEvent(QueryBatch batch) {
        if (!(batch.getClient() instanceof DatabaseClientImpl)) {
            throw new IllegalStateException("DatabaseClient must be instanceof DatabaseClientImpl");
        }
        StringHandle uris = new StringHandle(String.join((CharSequence)"\n", (CharSequence[])batch.getItems())).withMimetype("text/uri-list");
        RESTServices services = ((DatabaseClientImpl)batch.getClient()).getServices();
        try {
            RequestParameters params = new RequestParameters();
            if (this.transform != null) {
                this.transform.merge(params);
            }
            params.add("result", this.applyResult.toString().toLowerCase());
            List<String> responseUris = new BufferedReader(services.postResource(null, "internal/apply-transform", null, params, uris, new ReaderHandle()).get()).lines().collect(Collectors.toList());
            QueryBatchImpl queryBatchImpl = new QueryBatchImpl().withClient(batch.getClient()).withItems(responseUris.toArray(new String[responseUris.size()])).withTimestamp(batch.getTimestamp()).withJobBatchNumber(batch.getJobBatchNumber()).withJobResultsSoFar(batch.getJobResultsSoFar()).withForestBatchNumber(batch.getForestBatchNumber()).withForestResultsSoFar(batch.getForestResultsSoFar()).withForest(batch.getForest()).withServerTimestamp(batch.getServerTimestamp()).withJobTicket(batch.getJobTicket());
            for (QueryBatchListener listener : this.successListeners) {
                try {
                    listener.processEvent(queryBatchImpl);
                }
                catch (Throwable t) {
                    logger.error("Exception thrown by an onSuccess listener", t);
                }
            }
            ArrayList<String> skippedRequestUris = new ArrayList<String>(Arrays.asList(batch.getItems()));
            skippedRequestUris.removeAll(responseUris);
            if (skippedRequestUris.size() > 0) {
                QueryBatchImpl skippedBatch = queryBatchImpl.withItems(skippedRequestUris.toArray(new String[0]));
                for (QueryBatchListener listener : this.skippedListeners) {
                    try {
                        listener.processEvent(skippedBatch);
                    }
                    catch (Throwable t) {
                        logger.error("Exception thrown by an onSkipped listener", t);
                    }
                }
            }
        }
        catch (Throwable t) {
            for (BatchFailureListener<Batch<String>> batchFailureListener : this.failureListeners) {
                try {
                    batchFailureListener.processFailure(batch, t);
                }
                catch (Throwable t2) {
                    logger.error("Exception thrown by an onBatchFailure listener", t2);
                }
            }
            for (BatchFailureListener<Batch<String>> batchFailureListener : this.queryBatchFailureListeners) {
                try {
                    batchFailureListener.processFailure(batch, t);
                }
                catch (Throwable t2) {
                    logger.error("Exception thrown by an onFailure listener", t2);
                }
            }
            logger.warn("Error: {} in batch with urs ({})", (Object)t.toString(), Arrays.asList(batch.getItems()));
        }
    }

    public ApplyTransformListener onSuccess(QueryBatchListener listener) {
        this.successListeners.add(listener);
        return this;
    }

    public ApplyTransformListener onSkipped(QueryBatchListener listener) {
        this.skippedListeners.add(listener);
        return this;
    }

    @Deprecated
    public ApplyTransformListener onBatchFailure(BatchFailureListener<Batch<String>> listener) {
        this.failureListeners.add(listener);
        return this;
    }

    public ApplyTransformListener onFailure(BatchFailureListener<QueryBatch> listener) {
        this.queryBatchFailureListeners.add(listener);
        return this;
    }

    public ApplyTransformListener withTransform(ServerTransform transform) {
        this.transform = transform;
        return this;
    }

    public ApplyTransformListener withApplyResult(ApplyResult applyResult) {
        this.applyResult = applyResult;
        return this;
    }

    public static enum ApplyResult {
        REPLACE,
        IGNORE;

    }
}

