/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.Batch;
import com.marklogic.client.datamovement.BatchFailureListener;
import com.marklogic.client.datamovement.HostAvailabilityListener;
import com.marklogic.client.datamovement.NoResponseListener;
import com.marklogic.client.datamovement.QueryBatch;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.datamovement.QueryBatcher;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteListener
implements QueryBatchListener {
    private static Logger logger = LoggerFactory.getLogger(DeleteListener.class);
    private List<BatchFailureListener<Batch<String>>> failureListeners = new ArrayList<BatchFailureListener<Batch<String>>>();
    private List<BatchFailureListener<QueryBatch>> queryBatchFailureListeners = new ArrayList<BatchFailureListener<QueryBatch>>();

    public DeleteListener() {
        logger.debug("new DeleteListener - this should print once/job; if you see this once/batch, fix your job configuration");
    }

    @Override
    public void initializeListener(QueryBatcher queryBatcher) {
        BatchFailureListener<QueryBatch> noResponseRetryListener;
        NoResponseListener noResponseListener;
        BatchFailureListener<QueryBatch> retryListener;
        HostAvailabilityListener hostAvailabilityListener = HostAvailabilityListener.getInstance(queryBatcher);
        if (hostAvailabilityListener != null && (retryListener = hostAvailabilityListener.initializeRetryListener(this)) != null) {
            this.onFailure(retryListener);
        }
        if ((noResponseListener = NoResponseListener.getInstance(queryBatcher)) != null && (noResponseRetryListener = noResponseListener.initializeRetryListener(this)) != null) {
            this.onFailure(noResponseRetryListener);
        }
    }

    @Override
    public void processEvent(QueryBatch batch) {
        try {
            batch.getClient().newDocumentManager().delete((String[])batch.getItems());
        }
        catch (Throwable t) {
            for (BatchFailureListener<Batch<String>> batchFailureListener : this.failureListeners) {
                try {
                    batchFailureListener.processFailure(batch, t);
                }
                catch (Throwable t2) {
                    logger.error("Exception thrown by an onBatchFailure listener", t2);
                }
            }
            for (BatchFailureListener<Batch<String>> batchFailureListener : this.queryBatchFailureListeners) {
                try {
                    batchFailureListener.processFailure(batch, t);
                }
                catch (Throwable t2) {
                    logger.error("Exception thrown by an onFailure listener", t2);
                }
            }
        }
    }

    @Deprecated
    public DeleteListener onBatchFailure(BatchFailureListener<Batch<String>> listener) {
        this.failureListeners.add(listener);
        return this;
    }

    public DeleteListener onFailure(BatchFailureListener<QueryBatch> listener) {
        this.queryBatchFailureListeners.add(listener);
        return this;
    }
}

