/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.Batch;
import com.marklogic.client.datamovement.BatchFailureListener;
import com.marklogic.client.datamovement.DataMovementException;
import com.marklogic.client.datamovement.ExportListener;
import com.marklogic.client.datamovement.HostAvailabilityListener;
import com.marklogic.client.datamovement.NoResponseListener;
import com.marklogic.client.datamovement.QueryBatch;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.document.DocumentManager;
import com.marklogic.client.document.DocumentPage;
import com.marklogic.client.document.DocumentRecord;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportToWriterListener
extends ExportListener {
    private static Logger logger = LoggerFactory.getLogger(ExportToWriterListener.class);
    private Writer writer;
    private String suffix;
    private String prefix;
    private List<OutputListener> outputListeners = new ArrayList<OutputListener>();

    public ExportToWriterListener(Writer writer) {
        this.writer = writer;
        logger.debug("new ExportToWriterListener - this should print once/job; if you see this once/batch, fix your job configuration");
    }

    @Override
    public void initializeListener(QueryBatcher queryBatcher) {
        BatchFailureListener<QueryBatch> noResponseRetryListener;
        NoResponseListener noResponseListener;
        BatchFailureListener<QueryBatch> retryListener;
        HostAvailabilityListener hostAvailabilityListener = HostAvailabilityListener.getInstance(queryBatcher);
        if (hostAvailabilityListener != null && (retryListener = hostAvailabilityListener.initializeRetryListener(this)) != null) {
            this.onFailure(retryListener);
        }
        if ((noResponseListener = NoResponseListener.getInstance(queryBatcher)) != null && (noResponseRetryListener = noResponseListener.initializeRetryListener(this)) != null) {
            this.onFailure(noResponseRetryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvent(QueryBatch batch) {
        try (DocumentPage docs = this.getDocs(batch);){
            Writer writer = this.writer;
            synchronized (writer) {
                for (DocumentRecord doc : docs) {
                    Format format = doc.getFormat();
                    if (Format.BINARY.equals((Object)format)) {
                        throw new IllegalStateException("Document " + doc.getUri() + " is binary and cannot be written.  Change your query to not select any binary documents.");
                    }
                    try {
                        if (this.prefix != null) {
                            this.writer.write(this.prefix);
                        }
                        if (this.outputListeners.size() > 0) {
                            for (OutputListener listener : this.outputListeners) {
                                String output = null;
                                try {
                                    output = listener.generateOutput(doc);
                                }
                                catch (Throwable t) {
                                    logger.error("Exception thrown by an onGenerateOutput listener", t);
                                }
                                if (output == null) continue;
                                this.writer.write(output);
                            }
                        } else {
                            this.writer.write(doc.getContent(new StringHandle()).get());
                        }
                        if (this.suffix == null) continue;
                        this.writer.write(this.suffix);
                    }
                    catch (IOException e) {
                        throw new DataMovementException("Failed to write document \"" + doc.getUri() + "\"", e);
                    }
                }
            }
        }
        catch (Throwable t) {
            for (BatchFailureListener<Batch<String>> batchFailureListener : this.getFailureListeners()) {
                try {
                    batchFailureListener.processFailure(batch, t);
                }
                catch (Throwable t2) {
                    logger.error("Exception thrown by an onBatchFailure listener", t2);
                }
            }
            for (BatchFailureListener<Batch<String>> batchFailureListener : this.getBatchFailureListeners()) {
                try {
                    batchFailureListener.processFailure(batch, t);
                }
                catch (Throwable t2) {
                    logger.error("Exception thrown by an onFailure listener", t2);
                }
            }
        }
    }

    public ExportToWriterListener withRecordSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public ExportToWriterListener withRecordPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ExportToWriterListener onGenerateOutput(OutputListener listener) {
        this.outputListeners.add(listener);
        return this;
    }

    @Override
    public ExportToWriterListener withTransform(ServerTransform transform) {
        super.withTransform(transform);
        return this;
    }

    @Override
    public ExportToWriterListener withMetadataCategory(DocumentManager.Metadata category) {
        super.withMetadataCategory(category);
        return this;
    }

    @Override
    public ExportToWriterListener withNonDocumentFormat(Format nonDocumentFormat) {
        super.withNonDocumentFormat(nonDocumentFormat);
        return this;
    }

    public static interface OutputListener {
        public String generateOutput(DocumentRecord var1);
    }
}

