/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.datamovement.BatchFailureListener;
import com.marklogic.client.datamovement.QueryBatch;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.datamovement.TypedRow;
import com.marklogic.client.expression.PlanBuilder;
import com.marklogic.client.impl.DatabaseClientImpl;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.JacksonParserHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.util.RequestParameters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractRowsViaTemplateListener
implements QueryBatchListener,
AutoCloseable {
    private static Logger logger = LoggerFactory.getLogger(ExtractRowsViaTemplateListener.class);
    private List<String> templateUris = new ArrayList<String>();
    private String templateDb;
    private List<Consumer<TypedRow>> rowListeners = new ArrayList<Consumer<TypedRow>>();
    private List<BatchFailureListener<QueryBatch>> failureListeners = new ArrayList<BatchFailureListener<QueryBatch>>();
    private PlanBuilder pb;

    public ExtractRowsViaTemplateListener() {
        logger.debug("new ExtractRowsViaTemplateListener - this should print once/job; if you see this once/batch, fix your job configuration");
    }

    public ExtractRowsViaTemplateListener withTemplate(String templateUri) {
        this.templateUris.add(templateUri);
        return this;
    }

    private ExtractRowsViaTemplateListener withTemplateDatabase(String templateDatabase) {
        this.templateDb = templateDatabase;
        return this;
    }

    public ExtractRowsViaTemplateListener onTypedRowReady(Consumer<TypedRow> listener) {
        this.rowListeners.add(listener);
        return this;
    }

    public ExtractRowsViaTemplateListener onFailure(BatchFailureListener<QueryBatch> listener) {
        this.failureListeners.add(listener);
        return this;
    }

    @Override
    public void initializeListener(QueryBatcher queryBatcher) {
        this.pb = queryBatcher.getPrimaryClient().newRowManager().newPlanBuilder();
    }

    @Override
    public void processEvent(QueryBatch batch) {
        if (!(batch.getClient() instanceof DatabaseClientImpl)) {
            throw new IllegalStateException("DatabaseClient must be instanceof DatabaseClientImpl");
        }
        try {
            for (TypedRow row : this.getTypedRows(batch)) {
                for (Consumer<TypedRow> listener : this.rowListeners) {
                    try {
                        listener.accept(row);
                    }
                    catch (Throwable t) {
                        logger.error("Exception thrown by an onTypedRowReady listener", t);
                    }
                }
            }
        }
        catch (Throwable t) {
            for (BatchFailureListener<QueryBatch> listener : this.failureListeners) {
                try {
                    listener.processFailure(batch, t);
                }
                catch (Throwable t2) {
                    logger.error("Exception thrown by an onFailure listener", t2);
                }
            }
            logger.warn("Error: [{}] in batch with uris ({})", (Object)t.toString(), Arrays.asList(batch.getItems()));
        }
    }

    private Iterable<TypedRow> getTypedRows(QueryBatch batch) throws IOException {
        JacksonParserHandle handle;
        JsonParser jp;
        StringHandle uris = new StringHandle(String.join((CharSequence)"\n", (CharSequence[])batch.getItems())).withMimetype("text/uri-list");
        RESTServices services = ((DatabaseClientImpl)batch.getClient()).getServices();
        RequestParameters params = new RequestParameters();
        for (String templateUri : this.templateUris) {
            params.add("template", templateUri);
        }
        if (this.templateDb != null) {
            params.add("template-database", this.templateDb);
        }
        if ((jp = (handle = services.postResource(null, "internal/extract-via-template", null, params, uris, new JacksonParserHandle())).get()).nextToken() != JsonToken.START_OBJECT) {
            throw new MarkLogicIOException("Expected data to start with an Object");
        }
        jp.nextToken();
        if (jp.currentToken() == JsonToken.END_OBJECT) {
            logger.warn("No documents found for this batch");
            return new ArrayList<TypedRow>();
        }
        return new Iterable<TypedRow>(){

            @Override
            public Iterator<TypedRow> iterator() {
                return new Iterator<TypedRow>(){
                    private String uri = null;
                    private TypedRow nextRow = null;
                    private boolean rowUsed = true;

                    @Override
                    public TypedRow next() {
                        if (this.nextRow == null && !this.hasNext()) {
                            throw new NoSuchElementException("No more elements found in this iterator");
                        }
                        this.rowUsed = true;
                        return this.nextRow;
                    }

                    @Override
                    public boolean hasNext() {
                        if (!this.rowUsed) {
                            return true;
                        }
                        if (jp.currentToken() != JsonToken.END_OBJECT) {
                            this.nextRow = this.getOneTypedRow(jp);
                            return this.nextRow != null;
                        }
                        return false;
                    }

                    private TypedRow getOneTypedRow(JsonParser jp) {
                        try {
                            block19: {
                                do {
                                    if (this.uri == null) {
                                        if (jp.currentToken() != JsonToken.FIELD_NAME) {
                                            throw new MarkLogicIOException("Expected a uri for next template result");
                                        }
                                        this.uri = jp.getCurrentName();
                                        if (jp.nextToken() != JsonToken.START_ARRAY) {
                                            throw new MarkLogicIOException("Expected an array of rows");
                                        }
                                        jp.nextToken();
                                    }
                                    if (jp.currentToken() != JsonToken.END_ARRAY) break block19;
                                    logger.warn("No row found for Uri - " + this.uri);
                                    this.uri = null;
                                } while (jp.nextToken() != JsonToken.END_OBJECT);
                                return null;
                            }
                            if (jp.currentToken() != JsonToken.START_OBJECT) {
                                throw new MarkLogicIOException("Expected a JSON object containing a row");
                            }
                            if ("triple".equals(jp.nextFieldName())) {
                                throw new MarkLogicIOException("Expected a row but we got a triple. We don't support triples");
                            }
                            if (!"row".equals(jp.getCurrentName()) || jp.nextToken() != JsonToken.START_OBJECT) {
                                throw new MarkLogicIOException("Expected row to start");
                            }
                            while (!"data".equals(jp.nextFieldName())) {
                            }
                            if (jp.nextToken() != JsonToken.START_OBJECT || !"rownum".equals(jp.nextFieldName())) {
                                throw new MarkLogicIOException("Expected a row of values");
                            }
                            String rowNum = jp.nextTextValue();
                            TypedRow row = new TypedRow(this.uri, rowNum);
                            while (jp.nextToken() == JsonToken.FIELD_NAME) {
                                JsonToken valueType = jp.nextToken();
                                if (valueType == JsonToken.VALUE_STRING) {
                                    row.put(jp.getCurrentName(), ((ExtractRowsViaTemplateListener)ExtractRowsViaTemplateListener.this).pb.xs.string(jp.getText()));
                                    continue;
                                }
                                if (valueType == JsonToken.VALUE_NUMBER_INT) {
                                    row.put(jp.getCurrentName(), ((ExtractRowsViaTemplateListener)ExtractRowsViaTemplateListener.this).pb.xs.integer(jp.getIntValue()));
                                    continue;
                                }
                                if (valueType == JsonToken.VALUE_NUMBER_FLOAT) {
                                    row.put(jp.getCurrentName(), ((ExtractRowsViaTemplateListener)ExtractRowsViaTemplateListener.this).pb.xs.floatVal(jp.getFloatValue()));
                                    continue;
                                }
                                if (valueType == JsonToken.VALUE_TRUE || valueType == JsonToken.VALUE_FALSE) {
                                    row.put(jp.getCurrentName(), ((ExtractRowsViaTemplateListener)ExtractRowsViaTemplateListener.this).pb.xs.booleanVal(jp.getBooleanValue()));
                                    continue;
                                }
                                if (valueType == JsonToken.VALUE_NULL) {
                                    row.put(jp.getCurrentName(), null);
                                    continue;
                                }
                                throw new MarkLogicIOException("Unexpected value type for column \"" + jp.getCurrentName() + "\"");
                            }
                            if (jp.currentToken() != JsonToken.END_OBJECT || jp.nextToken() != JsonToken.END_OBJECT || jp.nextToken() != JsonToken.END_OBJECT) {
                                throw new MarkLogicIOException("Expected row to end");
                            }
                            if (jp.nextToken() == JsonToken.END_ARRAY) {
                                this.uri = null;
                                jp.nextToken();
                            }
                            return row;
                        }
                        catch (IOException e) {
                            throw new MarkLogicIOException(e);
                        }
                    }
                };
            }
        };
    }

    @Override
    public void close() throws Exception {
        for (Consumer<TypedRow> consumer : this.rowListeners) {
            if (!(consumer instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)((Object)consumer)).close();
            }
            catch (Exception e) {
                logger.error("onTypedRowReady listener cannot be closed", (Throwable)e);
            }
        }
        for (BatchFailureListener batchFailureListener : this.failureListeners) {
            if (!(batchFailureListener instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)((Object)batchFailureListener)).close();
            }
            catch (Exception e) {
                logger.error("onFailure listener cannot be closed", (Throwable)e);
            }
        }
    }
}

