/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.ForestConfiguration;
import com.marklogic.client.datamovement.impl.DataMovementManagerImpl;
import com.marklogic.client.datamovement.impl.ForestConfigurationImpl;

public abstract class BatcherImpl
implements Batcher {
    private String jobName = "unnamed";
    private String jobId = null;
    private int batchSize = 100;
    private int threadCount = 1;
    private ForestConfiguration forestConfig;
    private DatabaseClient client;
    private DataMovementManagerImpl moveMgr;

    protected BatcherImpl(DataMovementManager moveMgr) {
        if (moveMgr == null) {
            throw new IllegalArgumentException("moveMgr must not be null");
        }
        if (!(moveMgr instanceof DataMovementManagerImpl)) {
            throw new IllegalArgumentException("moveMgr must be DataMovementManagerImpl");
        }
        this.moveMgr = (DataMovementManagerImpl)moveMgr;
    }

    @Override
    public Batcher withJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    @Override
    public Batcher withJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public Batcher withBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be 1 or greater");
        }
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public Batcher withThreadCount(int threadCount) {
        if (threadCount <= 0) {
            throw new IllegalArgumentException("threadCount must be 1 or greater");
        }
        this.threadCount = threadCount;
        return this;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public ForestConfiguration getForestConfig() {
        return this.forestConfig;
    }

    @Override
    public Batcher withForestConfig(ForestConfiguration forestConfig) {
        if (forestConfig == null) {
            throw new IllegalArgumentException("forestConfig must not be null");
        }
        if (this.moveMgr.getConnectionType() == DatabaseClient.ConnectionType.GATEWAY && !(forestConfig instanceof ForestConfigurationImpl)) {
            throw new IllegalArgumentException("cannot change internal forestConfig when using a gateway");
        }
        this.forestConfig = forestConfig;
        return this;
    }

    @Override
    public abstract boolean isStopped();

    @Override
    public abstract boolean isStarted();

    public DataMovementManagerImpl getMoveMgr() {
        return this.moveMgr;
    }
}

