/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementException;
import com.marklogic.client.datamovement.JobReport;
import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.datamovement.WriteBatcher;
import com.marklogic.client.datamovement.impl.ForestConfigurationImpl;
import com.marklogic.client.datamovement.impl.ForestImpl;
import com.marklogic.client.datamovement.impl.JobReportImpl;
import com.marklogic.client.datamovement.impl.JobTicketImpl;
import com.marklogic.client.datamovement.impl.QueryBatcherImpl;
import com.marklogic.client.datamovement.impl.WriteBatcherImpl;
import com.marklogic.client.impl.DatabaseClientImpl;
import com.marklogic.client.io.JacksonHandle;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class DataMovementServices {
    private DatabaseClient client;

    public DatabaseClient getClient() {
        return this.client;
    }

    public DataMovementServices setClient(DatabaseClient client) {
        this.client = client;
        return this;
    }

    public ForestConfigurationImpl readForestConfig() {
        ArrayList<ForestImpl> forests = new ArrayList<ForestImpl>();
        JsonNode results = ((DatabaseClientImpl)this.client).getServices().getResource(null, "internal/forestinfo", null, null, new JacksonHandle()).get();
        for (JsonNode forestNode : results) {
            String id = forestNode.get("id").asText();
            String name = forestNode.get("name").asText();
            String database = forestNode.get("database").asText();
            String host = forestNode.get("host").asText();
            String openReplicaHost = null;
            if (forestNode.get("openReplicaHost") != null) {
                openReplicaHost = forestNode.get("openReplicaHost").asText();
            }
            String requestHost = null;
            if (forestNode.get("requestHost") != null) {
                requestHost = forestNode.get("requestHost").asText();
            }
            String alternateHost = null;
            if (forestNode.get("alternateHost") != null) {
                alternateHost = forestNode.get("alternateHost").asText();
            }
            if (requestHost != null && alternateHost != null) {
                alternateHost = null;
            }
            boolean isUpdateable = "all".equals(forestNode.get("updatesAllowed").asText());
            boolean isDeleteOnly = false;
            forests.add(new ForestImpl(host, openReplicaHost, requestHost, alternateHost, database, name, id, isUpdateable, isDeleteOnly));
        }
        return new ForestConfigurationImpl(forests.toArray(new ForestImpl[forests.size()]));
    }

    public JobTicket startJob(WriteBatcher batcher, ConcurrentHashMap<String, JobTicket> activeJobs) {
        String jobId;
        String string = jobId = batcher.getJobId() != null ? batcher.getJobId() : this.generateJobId();
        if (batcher.getJobId() == null && !batcher.isStarted()) {
            batcher.withJobId(jobId);
        }
        if (!batcher.isStarted() && activeJobs.containsKey(jobId)) {
            throw new DataMovementException("Cannot start the batcher because the given job Id already exists in the active jobs", null);
        }
        JobTicketImpl jobTicket = new JobTicketImpl(jobId, JobTicket.JobType.WRITE_BATCHER).withWriteBatcher((WriteBatcherImpl)batcher);
        ((WriteBatcherImpl)batcher).start(jobTicket);
        activeJobs.put(jobId, jobTicket);
        return jobTicket;
    }

    public JobTicket startJob(QueryBatcher batcher, ConcurrentHashMap<String, JobTicket> activeJobs) {
        String jobId;
        String string = jobId = batcher.getJobId() != null ? batcher.getJobId() : this.generateJobId();
        if (batcher.getJobId() == null) {
            batcher.withJobId(jobId);
        }
        if (!batcher.isStarted() && activeJobs.containsKey(jobId)) {
            throw new DataMovementException("Cannot start the batcher because the given job Id already exists in the active jobs", null);
        }
        JobTicketImpl jobTicket = new JobTicketImpl(jobId, JobTicket.JobType.QUERY_BATCHER).withQueryBatcher((QueryBatcherImpl)batcher);
        ((QueryBatcherImpl)batcher).start(jobTicket);
        activeJobs.put(jobId, jobTicket);
        return jobTicket;
    }

    public JobReport getJobReport(JobTicket ticket) {
        if (ticket instanceof JobTicketImpl) {
            JobTicketImpl ticketImpl = (JobTicketImpl)ticket;
            if (ticketImpl.getJobType() == JobTicket.JobType.WRITE_BATCHER) {
                return new JobReportImpl(ticketImpl.getWriteBatcher());
            }
            if (ticketImpl.getJobType() == JobTicket.JobType.QUERY_BATCHER) {
                return new JobReportImpl(ticketImpl.getQueryBatcher());
            }
        }
        return null;
    }

    public void stopJob(JobTicket ticket, ConcurrentHashMap<String, JobTicket> activeJobs) {
        if (ticket instanceof JobTicketImpl) {
            JobTicketImpl ticketImpl = (JobTicketImpl)ticket;
            if (ticketImpl.getJobType() == JobTicket.JobType.WRITE_BATCHER) {
                ticketImpl.getWriteBatcher().stop();
            } else if (ticketImpl.getJobType() == JobTicket.JobType.QUERY_BATCHER) {
                ticketImpl.getQueryBatcher().stop();
            }
            activeJobs.remove(ticket.getJobId());
        }
    }

    public void stopJob(Batcher batcher, ConcurrentHashMap<String, JobTicket> activeJobs) {
        if (batcher instanceof QueryBatcherImpl) {
            ((QueryBatcherImpl)batcher).stop();
        } else if (batcher instanceof WriteBatcherImpl) {
            ((WriteBatcherImpl)batcher).stop();
        }
        if (batcher.getJobId() != null) {
            activeJobs.remove(batcher.getJobId());
        }
    }

    private String generateJobId() {
        return UUID.randomUUID().toString();
    }
}

