/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.dataservices;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.SessionState;
import com.marklogic.client.dataservices.CallManagerImpl;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Date;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public interface CallManager {
    public static CallManager on(DatabaseClient client) {
        return new CallManagerImpl(client);
    }

    public SessionState newSessionState();

    public CallableEndpoint endpoint(JSONWriteHandle var1, JSONWriteHandle var2, String var3);

    public static interface Returndef {
        public String getDataType();

        public boolean isNullable();

        public boolean isMultiple();
    }

    public static interface Paramdef {
        public String getParamName();

        public String getDataType();

        public boolean isNullable();

        public boolean isMultiple();
    }

    public static interface CallArgs {
        public CallArgs param(String var1, AbstractWriteHandle var2);

        public CallArgs param(String var1, AbstractWriteHandle[] var2);

        public CallArgs param(String var1, BigDecimal var2);

        public CallArgs param(String var1, BigDecimal[] var2);

        public CallArgs param(String var1, Boolean var2);

        public CallArgs param(String var1, Boolean[] var2);

        public CallArgs param(String var1, byte[] var2);

        public CallArgs param(String var1, byte[][] var2);

        public CallArgs param(String var1, Date var2);

        public CallArgs param(String var1, Date[] var2);

        public CallArgs param(String var1, Document var2);

        public CallArgs param(String var1, Document[] var2);

        public CallArgs param(String var1, Double var2);

        public CallArgs param(String var1, Double[] var2);

        public CallArgs param(String var1, Duration var2);

        public CallArgs param(String var1, Duration[] var2);

        public CallArgs param(String var1, File var2);

        public CallArgs param(String var1, File[] var2);

        public CallArgs param(String var1, Float var2);

        public CallArgs param(String var1, Float[] var2);

        public CallArgs param(String var1, InputSource var2);

        public CallArgs param(String var1, InputSource[] var2);

        public CallArgs param(String var1, InputStream var2);

        public CallArgs param(String var1, InputStream[] var2);

        public CallArgs param(String var1, Integer var2);

        public CallArgs param(String var1, Integer[] var2);

        public CallArgs param(String var1, JsonNode var2);

        public CallArgs param(String var1, JsonNode[] var2);

        public CallArgs param(String var1, JsonParser var2);

        public CallArgs param(String var1, JsonParser[] var2);

        public CallArgs param(String var1, LocalDate var2);

        public CallArgs param(String var1, LocalDate[] var2);

        public CallArgs param(String var1, LocalDateTime var2);

        public CallArgs param(String var1, LocalDateTime[] var2);

        public CallArgs param(String var1, LocalTime var2);

        public CallArgs param(String var1, LocalTime[] var2);

        public CallArgs param(String var1, Long var2);

        public CallArgs param(String var1, Long[] var2);

        public CallArgs param(String var1, OffsetDateTime var2);

        public CallArgs param(String var1, OffsetDateTime[] var2);

        public CallArgs param(String var1, OffsetTime var2);

        public CallArgs param(String var1, OffsetTime[] var2);

        public CallArgs param(String var1, Reader var2);

        public CallArgs param(String var1, Reader[] var2);

        public CallArgs param(String var1, Source var2);

        public CallArgs param(String var1, Source[] var2);

        public CallArgs param(String var1, String var2);

        public CallArgs param(String var1, String[] var2);

        public CallArgs param(String var1, XMLEventReader var2);

        public CallArgs param(String var1, XMLEventReader[] var2);

        public CallArgs param(String var1, XMLStreamReader var2);

        public CallArgs param(String var1, XMLStreamReader[] var2);
    }

    public static interface EndpointDefiner {
        public CallArgs args();

        public CallArgs args(SessionState var1);

        public String getEndpointPath();

        public Boolean isSessionRequired();

        public Map<String, Paramdef> getParamdefs();

        public Returndef getReturndef();
    }

    public static interface ManyCaller<R>
    extends EndpointDefiner {
        public Stream<R> call();

        public Stream<R> call(CallArgs var1);
    }

    public static interface OneCaller<R>
    extends EndpointDefiner {
        public R call();

        public R call(CallArgs var1);
    }

    public static interface NoneCaller
    extends EndpointDefiner {
        public void call();

        public void call(CallArgs var1);
    }

    public static interface CallableEndpoint
    extends EndpointDefiner {
        public NoneCaller returningNone();

        public <R> OneCaller<R> returningOne(Class<R> var1);

        public <R> ManyCaller<R> returningMany(Class<R> var1);
    }
}

