/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.dataservices;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.SessionState;
import com.marklogic.client.dataservices.CallManager;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.NodeConverter;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.SessionStateImpl;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.BinaryReadHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

class CallManagerImpl
implements CallManager {
    private static final Map<String, BaseFieldifier> paramFieldifiers = new HashMap<String, BaseFieldifier>();
    private static final Map<String, Format> typeFormats = new HashMap<String, Format>();
    private static final Map<String, ServerTypeConverter> returnConverters = new HashMap<String, ServerTypeConverter>();
    private DatabaseClient client;

    CallManagerImpl(DatabaseClient client) {
        paramFieldifiers.put("boolean", new BooleanFieldifier());
        paramFieldifiers.put("date", new DateFieldifier());
        paramFieldifiers.put("dateTime", new DateTimeFieldifier());
        paramFieldifiers.put("dayTimeDuration", new DayTimeDurationFieldifier());
        paramFieldifiers.put("decimal", new DecimalFieldifier());
        paramFieldifiers.put("double", new DoubleFieldifier());
        paramFieldifiers.put("float", new FloatFieldifier());
        paramFieldifiers.put("int", new IntegerFieldifier());
        paramFieldifiers.put("long", new LongFieldifier());
        paramFieldifiers.put("string", new StringFieldifier());
        paramFieldifiers.put("time", new TimeFieldifier());
        paramFieldifiers.put("unsignedInt", new UnsignedIntegerFieldifier());
        paramFieldifiers.put("unsignedLong", new UnsignedLongFieldifier());
        paramFieldifiers.put("array", new ArrayFieldifier());
        paramFieldifiers.put("binaryDocument", new BinaryDocumentFieldifier());
        paramFieldifiers.put("jsonDocument", new JsonDocumentFieldifier());
        paramFieldifiers.put("object", new ObjectFieldifier());
        paramFieldifiers.put("textDocument", new TextDocumentFieldifier());
        paramFieldifiers.put("xmlDocument", new XmlDocumentFieldifier());
        typeFormats.put("array", BaseProxy.ArrayType.FORMAT);
        typeFormats.put("binaryDocument", BaseProxy.BinaryDocumentType.FORMAT);
        typeFormats.put("jsonDocument", BaseProxy.JsonDocumentType.FORMAT);
        typeFormats.put("object", BaseProxy.ObjectType.FORMAT);
        typeFormats.put("textDocument", BaseProxy.TextDocumentType.FORMAT);
        typeFormats.put("xmlDocument", BaseProxy.XmlDocumentType.FORMAT);
        new BooleanTypeConverter().putTo(returnConverters);
        new DateTypeConverter().putTo(returnConverters);
        new DateTimeTypeConverter().putTo(returnConverters);
        new DayTimeDurationTypeConverter().putTo(returnConverters);
        new DecimalTypeConverter().putTo(returnConverters);
        new DoubleTypeConverter().putTo(returnConverters);
        new FloatTypeConverter().putTo(returnConverters);
        new IntegerTypeConverter().putTo(returnConverters);
        new LongTypeConverter().putTo(returnConverters);
        new StringTypeConverter().putTo(returnConverters);
        new TimeTypeConverter().putTo(returnConverters);
        new UnsignedIntegerTypeConverter().putTo(returnConverters);
        new UnsignedLongTypeConverter().putTo(returnConverters);
        new BinaryDocumentTypeConverter().putTo(returnConverters);
        JsonDocumentTypeConverter converter = new JsonDocumentTypeConverter();
        returnConverters.put("jsonDocument", converter);
        returnConverters.put("array", converter);
        returnConverters.put("object", converter);
        new TextDocumentTypeConverter().putTo(returnConverters);
        new XMLDocumentTypeConverter().putTo(returnConverters);
        if (client == null) {
            throw new IllegalArgumentException("cannot construct CallManager with null database client");
        }
        this.client = client;
    }

    @Override
    public SessionState newSessionState() {
        return new SessionStateImpl();
    }

    @Override
    public CallManager.CallableEndpoint endpoint(JSONWriteHandle serviceDeclaration, JSONWriteHandle endpointDeclaration, String extension) {
        JsonNode serviceDecl = NodeConverter.handleToJsonNode(serviceDeclaration);
        JsonNode endpointDecl = NodeConverter.handleToJsonNode(endpointDeclaration);
        if (serviceDecl == null) {
            throw new IllegalArgumentException("cannot construct CallableEndpoint with null serviceDeclaration");
        }
        if (endpointDecl == null) {
            throw new IllegalArgumentException("cannot construct CallableEndpoint with null endpointDeclaration");
        }
        if (extension == null || extension.length() == 0) {
            throw new IllegalArgumentException("cannot construct CallableEndpoint with null or empty extension");
        }
        if (!"sjs".equals(extension) && !"xqy".equals(extension)) {
            throw new IllegalArgumentException("extension must be sjs or xqy: " + extension);
        }
        return new CallableEndpointImpl(this.client, serviceDecl, endpointDecl, extension);
    }

    private static boolean getBoolean(JsonNode property, boolean defaultValue) {
        if (property == null) {
            return defaultValue;
        }
        return property.asBoolean(defaultValue);
    }

    private static String getText(JsonNode property) {
        if (property == null) {
            return null;
        }
        return property.asText();
    }

    private static class XMLDocumentTypeConverter
    extends CharacterNodeTypeConverter {
        XMLDocumentTypeConverter() {
            super("xmlDocument");
            this.put(XMLReadHandle.class, new ReturnConverter<XMLReadHandle>(){

                @Override
                public XMLReadHandle one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.XmlDocumentType.toXMLReadHandle(response);
                }

                @Override
                public Stream<XMLReadHandle> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.XmlDocumentType.toXMLReadHandle(response);
                }
            });
            this.put(Document.class, new ReturnConverter<Document>(){

                @Override
                public Document one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.XmlDocumentType.toDocument(response);
                }

                @Override
                public Stream<Document> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.XmlDocumentType.toDocument(response);
                }
            });
            this.put(InputSource.class, new ReturnConverter<InputSource>(){

                @Override
                public InputSource one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.XmlDocumentType.toInputSource(response);
                }

                @Override
                public Stream<InputSource> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.XmlDocumentType.toInputSource(response);
                }
            });
            this.put(Source.class, new ReturnConverter<Source>(){

                @Override
                public Source one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.XmlDocumentType.toSource(response);
                }

                @Override
                public Stream<Source> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.XmlDocumentType.toSource(response);
                }
            });
            this.put(XMLEventReader.class, new ReturnConverter<XMLEventReader>(){

                @Override
                public XMLEventReader one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.XmlDocumentType.toXMLEventReader(response);
                }

                @Override
                public Stream<XMLEventReader> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.XmlDocumentType.toXMLEventReader(response);
                }
            });
            this.put(XMLStreamReader.class, new ReturnConverter<XMLStreamReader>(){

                @Override
                public XMLStreamReader one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.XmlDocumentType.toXMLStreamReader(response);
                }

                @Override
                public Stream<XMLStreamReader> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.XmlDocumentType.toXMLStreamReader(response);
                }
            });
        }
    }

    private static class TextDocumentTypeConverter
    extends CharacterNodeTypeConverter {
        TextDocumentTypeConverter() {
            super("textDocument");
            this.put(TextReadHandle.class, new ReturnConverter<TextReadHandle>(){

                @Override
                public TextReadHandle one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.TextDocumentType.toTextReadHandle(response);
                }

                @Override
                public Stream<TextReadHandle> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.TextDocumentType.toTextReadHandle(response);
                }
            });
        }
    }

    private static class JsonDocumentTypeConverter
    extends CharacterNodeTypeConverter {
        JsonDocumentTypeConverter() {
            super("jsonDocument");
            this.put(JSONReadHandle.class, new ReturnConverter<JSONReadHandle>(){

                @Override
                public JSONReadHandle one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.JsonDocumentType.toJSONReadHandle(response);
                }

                @Override
                public Stream<JSONReadHandle> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.JsonDocumentType.toJSONReadHandle(response);
                }
            });
            this.put(JsonNode.class, new ReturnConverter<JsonNode>(){

                @Override
                public JsonNode one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.JsonDocumentType.toJsonNode(response);
                }

                @Override
                public Stream<JsonNode> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.JsonDocumentType.toJsonNode(response);
                }
            });
            this.put(JsonParser.class, new ReturnConverter<JsonParser>(){

                @Override
                public JsonParser one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.JsonDocumentType.toJsonParser(response);
                }

                @Override
                public Stream<JsonParser> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.JsonDocumentType.toJsonParser(response);
                }
            });
        }
    }

    private static class BinaryDocumentTypeConverter
    extends NodeTypeConverter {
        BinaryDocumentTypeConverter() {
            super("binaryDocument");
            this.put(BinaryReadHandle.class, new ReturnConverter<BinaryReadHandle>(){

                @Override
                public BinaryReadHandle one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.BinaryDocumentType.toBinaryReadHandle(response);
                }

                @Override
                public Stream<BinaryReadHandle> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.BinaryDocumentType.toBinaryReadHandle(response);
                }
            });
        }
    }

    private static class UnsignedLongTypeConverter
    extends AtomicTypeConverter {
        UnsignedLongTypeConverter() {
            super("unsignedLong");
            this.put(Long.class, new ReturnConverter<Long>(){

                @Override
                public Long one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.UnsignedLongType.toLong(response);
                }

                @Override
                public Stream<Long> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.UnsignedLongType.toLong(response);
                }
            });
        }
    }

    private static class UnsignedIntegerTypeConverter
    extends AtomicTypeConverter {
        UnsignedIntegerTypeConverter() {
            super("unsignedInt");
            this.put(Integer.class, new ReturnConverter<Integer>(){

                @Override
                public Integer one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.UnsignedIntegerType.toInteger(response);
                }

                @Override
                public Stream<Integer> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.UnsignedIntegerType.toInteger(response);
                }
            });
        }
    }

    private static class TimeTypeConverter
    extends AtomicTypeConverter {
        TimeTypeConverter() {
            super("time");
            this.put(LocalTime.class, new ReturnConverter<LocalTime>(){

                @Override
                public LocalTime one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.TimeType.toLocalTime(response);
                }

                @Override
                public Stream<LocalTime> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.TimeType.toLocalTime(response);
                }
            });
            this.put(OffsetTime.class, new ReturnConverter<OffsetTime>(){

                @Override
                public OffsetTime one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.TimeType.toOffsetTime(response);
                }

                @Override
                public Stream<OffsetTime> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.TimeType.toOffsetTime(response);
                }
            });
        }
    }

    private static class StringTypeConverter
    extends AtomicTypeConverter {
        StringTypeConverter() {
            super("string");
        }
    }

    private static class LongTypeConverter
    extends AtomicTypeConverter {
        LongTypeConverter() {
            super("long");
            this.put(Long.class, new ReturnConverter<Long>(){

                @Override
                public Long one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.LongType.toLong(response);
                }

                @Override
                public Stream<Long> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.LongType.toLong(response);
                }
            });
        }
    }

    private static class IntegerTypeConverter
    extends AtomicTypeConverter {
        IntegerTypeConverter() {
            super("int");
            this.put(Integer.class, new ReturnConverter<Integer>(){

                @Override
                public Integer one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.IntegerType.toInteger(response);
                }

                @Override
                public Stream<Integer> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.IntegerType.toInteger(response);
                }
            });
        }
    }

    private static class FloatTypeConverter
    extends AtomicTypeConverter {
        FloatTypeConverter() {
            super("float");
            this.put(Float.class, new ReturnConverter<Float>(){

                @Override
                public Float one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.FloatType.toFloat(response);
                }

                @Override
                public Stream<Float> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.FloatType.toFloat(response);
                }
            });
        }
    }

    private static class DoubleTypeConverter
    extends AtomicTypeConverter {
        DoubleTypeConverter() {
            super("double");
            this.put(Double.class, new ReturnConverter<Double>(){

                @Override
                public Double one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.DoubleType.toDouble(response);
                }

                @Override
                public Stream<Double> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.DoubleType.toDouble(response);
                }
            });
        }
    }

    private static class DecimalTypeConverter
    extends AtomicTypeConverter {
        DecimalTypeConverter() {
            super("decimal");
            this.put(BigDecimal.class, new ReturnConverter<BigDecimal>(){

                @Override
                public BigDecimal one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.DecimalType.toBigDecimal(response);
                }

                @Override
                public Stream<BigDecimal> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.DecimalType.toBigDecimal(response);
                }
            });
        }
    }

    private static class DayTimeDurationTypeConverter
    extends AtomicTypeConverter {
        DayTimeDurationTypeConverter() {
            super("dayTimeDuration");
            this.put(Duration.class, new ReturnConverter<Duration>(){

                @Override
                public Duration one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.DayTimeDurationType.toDuration(response);
                }

                @Override
                public Stream<Duration> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.DayTimeDurationType.toDuration(response);
                }
            });
        }
    }

    private static class DateTimeTypeConverter
    extends AtomicTypeConverter {
        DateTimeTypeConverter() {
            super("dateTime");
            this.put(Date.class, new ReturnConverter<Date>(){

                @Override
                public Date one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.DateTimeType.toDate(response);
                }

                @Override
                public Stream<Date> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.DateTimeType.toDate(response);
                }
            });
            this.put(LocalDateTime.class, new ReturnConverter<LocalDateTime>(){

                @Override
                public LocalDateTime one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.DateTimeType.toLocalDateTime(response);
                }

                @Override
                public Stream<LocalDateTime> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.DateTimeType.toLocalDateTime(response);
                }
            });
            this.put(OffsetDateTime.class, new ReturnConverter<OffsetDateTime>(){

                @Override
                public OffsetDateTime one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.DateTimeType.toOffsetDateTime(response);
                }

                @Override
                public Stream<OffsetDateTime> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.DateTimeType.toOffsetDateTime(response);
                }
            });
        }
    }

    private static class DateTypeConverter
    extends AtomicTypeConverter {
        DateTypeConverter() {
            super("date");
            this.put(LocalDate.class, new ReturnConverter<LocalDate>(){

                @Override
                public LocalDate one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.DateType.toLocalDate(response);
                }

                @Override
                public Stream<LocalDate> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.DateType.toLocalDate(response);
                }
            });
        }
    }

    private static class BooleanTypeConverter
    extends AtomicTypeConverter {
        BooleanTypeConverter() {
            super("boolean");
            this.put(Boolean.class, new ReturnConverter<Boolean>(){

                @Override
                public Boolean one(RESTServices.SingleCallResponse response) {
                    return BaseProxy.BooleanType.toBoolean(response);
                }

                @Override
                public Stream<Boolean> many(RESTServices.MultipleCallResponse response) {
                    return BaseProxy.BooleanType.toBoolean(response);
                }
            });
        }
    }

    static abstract class CharacterNodeTypeConverter
    extends NodeTypeConverter {
        CharacterNodeTypeConverter(String serverType) {
            super(serverType);
            this.put(Reader.class, new ReturnConverter<Reader>(){

                @Override
                public Reader one(RESTServices.SingleCallResponse response) {
                    return response.asReader();
                }

                @Override
                public Stream<Reader> many(RESTServices.MultipleCallResponse response) {
                    return response.asStreamOfReader();
                }
            });
            this.put(String.class, toStringConverter);
        }
    }

    static abstract class NodeTypeConverter
    extends ServerTypeConverter {
        NodeTypeConverter(String serverType) {
            super(serverType);
            this.put(byte[].class, new ReturnConverter<byte[]>(){

                @Override
                public byte[] one(RESTServices.SingleCallResponse response) {
                    return response.asBytes();
                }

                @Override
                public Stream<byte[]> many(RESTServices.MultipleCallResponse response) {
                    return response.asStreamOfBytes();
                }
            });
            this.put(File.class, new ReturnConverter<File>(){

                @Override
                public File one(RESTServices.SingleCallResponse response) {
                    return NodeConverter.InputStreamToFile(response.asInputStream());
                }

                @Override
                public Stream<File> many(RESTServices.MultipleCallResponse response) {
                    return NodeConverter.InputStreamToFile(response.asStreamOfInputStream());
                }
            });
            this.put(InputStream.class, new ReturnConverter<InputStream>(){

                @Override
                public InputStream one(RESTServices.SingleCallResponse response) {
                    return response.asInputStream();
                }

                @Override
                public Stream<InputStream> many(RESTServices.MultipleCallResponse response) {
                    return response.asStreamOfInputStream();
                }
            });
        }
    }

    static abstract class AtomicTypeConverter
    extends ServerTypeConverter {
        AtomicTypeConverter(String serverType) {
            super(serverType);
            this.put(String.class, toStringConverter);
        }
    }

    static abstract class ServerTypeConverter {
        static final ReturnConverter<String> toStringConverter = new ReturnConverter<String>(){

            @Override
            public String one(RESTServices.SingleCallResponse response) {
                return response.asString();
            }

            @Override
            public Stream<String> many(RESTServices.MultipleCallResponse response) {
                return response.asStreamOfString();
            }
        };
        Map<Class<?>, ReturnConverter<?>> converters;
        String serverType;

        ServerTypeConverter(String serverType) {
            this.serverType = serverType;
            this.converters = new HashMap();
        }

        protected <T> void put(Class<T> key, ReturnConverter<T> value) {
            this.converters.put(key, value);
        }

        void putTo(Map<String, ? super ServerTypeConverter> map) {
            map.put(this.serverType, this);
        }

        <T> ReturnConverter<T> forClientType(Class<T> as) {
            ReturnConverter<?> converter = this.converters.get(as);
            if (converter == null) {
                throw new IllegalArgumentException("cannot convert server type " + this.serverType + " to client type " + as.getCanonicalName());
            }
            return converter;
        }
    }

    static interface ReturnConverter<T> {
        public T one(RESTServices.SingleCallResponse var1);

        public Stream<T> many(RESTServices.MultipleCallResponse var1);
    }

    private static class XmlDocumentFieldifier
    extends CharacterNodeFieldifier {
        XmlDocumentFieldifier() {
            super("xmlDocument", Format.XML);
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, Document value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleNodeCallField(name, BaseProxy.XmlDocumentType.fromDocument(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Document[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleNodeCallField(name, BaseProxy.XmlDocumentType.fromDocument(Stream.of(values))) : new RESTServices.SingleNodeCallField(name, BaseProxy.XmlDocumentType.fromDocument(values[0]));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, InputSource value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleNodeCallField(name, BaseProxy.XmlDocumentType.fromInputSource(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, InputSource[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleNodeCallField(name, BaseProxy.XmlDocumentType.fromInputSource(Stream.of(values))) : new RESTServices.SingleNodeCallField(name, BaseProxy.XmlDocumentType.fromInputSource(values[0]));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, Source value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleNodeCallField(name, BaseProxy.XmlDocumentType.fromSource(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Source[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleNodeCallField(name, BaseProxy.XmlDocumentType.fromSource(Stream.of(values))) : new RESTServices.SingleNodeCallField(name, BaseProxy.XmlDocumentType.fromSource(values[0]));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, XMLEventReader value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleNodeCallField(name, BaseProxy.XmlDocumentType.fromXMLEventReader(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, XMLEventReader[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleNodeCallField(name, BaseProxy.XmlDocumentType.fromXMLEventReader(Stream.of(values))) : new RESTServices.SingleNodeCallField(name, BaseProxy.XmlDocumentType.fromXMLEventReader(values[0]));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, XMLStreamReader value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleNodeCallField(name, BaseProxy.XmlDocumentType.fromXMLStreamReader(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, XMLStreamReader[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleNodeCallField(name, BaseProxy.XmlDocumentType.fromXMLStreamReader(Stream.of(values))) : new RESTServices.SingleNodeCallField(name, BaseProxy.XmlDocumentType.fromXMLStreamReader(values[0]));
        }
    }

    private static class TextDocumentFieldifier
    extends CharacterNodeFieldifier {
        TextDocumentFieldifier() {
            super("textDocument", Format.TEXT);
        }
    }

    private static class ObjectFieldifier
    extends JsonDocumentFieldifier {
        ObjectFieldifier() {
            super("object");
        }
    }

    public static class ArrayFieldifier
    extends JsonDocumentFieldifier {
        ArrayFieldifier() {
            super("array");
        }
    }

    private static class JsonDocumentFieldifier
    extends CharacterNodeFieldifier {
        JsonDocumentFieldifier(String typeName) {
            super(typeName, Format.JSON);
        }

        JsonDocumentFieldifier() {
            this("jsonDocument");
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, JsonNode value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleNodeCallField(name, BaseProxy.JsonDocumentType.fromJsonNode(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, JsonNode[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleNodeCallField(name, BaseProxy.JsonDocumentType.fromJsonNode(Stream.of(values))) : new RESTServices.SingleNodeCallField(name, BaseProxy.JsonDocumentType.fromJsonNode(values[0]));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, JsonParser value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleNodeCallField(name, BaseProxy.JsonDocumentType.fromJsonParser(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, JsonParser[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleNodeCallField(name, BaseProxy.JsonDocumentType.fromJsonParser(Stream.of(values))) : new RESTServices.SingleNodeCallField(name, BaseProxy.JsonDocumentType.fromJsonParser(values[0]));
        }
    }

    private static class BinaryDocumentFieldifier
    extends NodeFieldifier {
        BinaryDocumentFieldifier() {
            super("binaryDocument", Format.BINARY);
        }
    }

    private static class UnsignedLongFieldifier
    extends AtomicFieldifier {
        UnsignedLongFieldifier() {
            super("unsignedLong");
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, Long value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.UnsignedLongType.fromLong(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Long[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.UnsignedLongType.fromLong(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.UnsignedLongType.fromLong(values[0]));
        }
    }

    private static class UnsignedIntegerFieldifier
    extends AtomicFieldifier {
        UnsignedIntegerFieldifier() {
            super("unsignedInt");
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, Integer value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.UnsignedIntegerType.fromInteger(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Integer[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.UnsignedIntegerType.fromInteger(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.UnsignedIntegerType.fromInteger(values[0]));
        }
    }

    private static class TimeFieldifier
    extends AtomicFieldifier {
        TimeFieldifier() {
            super("time");
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, LocalTime value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.TimeType.fromLocalTime(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, LocalTime[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.TimeType.fromLocalTime(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.TimeType.fromLocalTime(values[0]));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, OffsetTime value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.TimeType.fromOffsetTime(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, OffsetTime[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.TimeType.fromOffsetTime(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.TimeType.fromOffsetTime(values[0]));
        }
    }

    private static class StringFieldifier
    extends AtomicFieldifier {
        StringFieldifier() {
            super("string");
        }
    }

    public static class LongFieldifier
    extends AtomicFieldifier {
        LongFieldifier() {
            super("long");
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, Long value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.LongType.fromLong(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Long[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.LongType.fromLong(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.LongType.fromLong(values[0]));
        }
    }

    private static class IntegerFieldifier
    extends AtomicFieldifier {
        IntegerFieldifier() {
            super("int");
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, Integer value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.IntegerType.fromInteger(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Integer[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.IntegerType.fromInteger(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.IntegerType.fromInteger(values[0]));
        }
    }

    private static class FloatFieldifier
    extends AtomicFieldifier {
        FloatFieldifier() {
            super("float");
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, Float value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.FloatType.fromFloat(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Float[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.FloatType.fromFloat(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.FloatType.fromFloat(values[0]));
        }
    }

    private static class DoubleFieldifier
    extends AtomicFieldifier {
        DoubleFieldifier() {
            super("double");
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, Double value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.DoubleType.fromDouble(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Double[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.DoubleType.fromDouble(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.DoubleType.fromDouble(values[0]));
        }
    }

    private static class DecimalFieldifier
    extends AtomicFieldifier {
        DecimalFieldifier() {
            super("decimal");
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, BigDecimal value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.DecimalType.fromBigDecimal(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, BigDecimal[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.DecimalType.fromBigDecimal(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.DecimalType.fromBigDecimal(values[0]));
        }
    }

    private static class DayTimeDurationFieldifier
    extends AtomicFieldifier {
        DayTimeDurationFieldifier() {
            super("dayTimeDuration");
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, Duration value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.DayTimeDurationType.fromDuration(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Duration[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.DayTimeDurationType.fromDuration(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.DayTimeDurationType.fromDuration(values[0]));
        }
    }

    private static class DateTimeFieldifier
    extends AtomicFieldifier {
        DateTimeFieldifier() {
            super("dateTime");
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, Date value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.DateTimeType.fromDate(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Date[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.DateTimeType.fromDate(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.DateTimeType.fromDate(values[0]));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, LocalDateTime value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.DateTimeType.fromLocalDateTime(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, LocalDateTime[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.DateTimeType.fromLocalDateTime(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.DateTimeType.fromLocalDateTime(values[0]));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, OffsetDateTime value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.DateTimeType.fromOffsetDateTime(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, OffsetDateTime[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.DateTimeType.fromOffsetDateTime(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.DateTimeType.fromOffsetDateTime(values[0]));
        }
    }

    private static class DateFieldifier
    extends AtomicFieldifier {
        DateFieldifier() {
            super("date");
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, LocalDate value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.DateType.fromLocalDate(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, LocalDate[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.DateType.fromLocalDate(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.DateType.fromLocalDate(values[0]));
        }
    }

    private static class BooleanFieldifier
    extends AtomicFieldifier {
        BooleanFieldifier() {
            super("boolean");
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, Boolean value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, BaseProxy.BooleanType.fromBoolean(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Boolean[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, BaseProxy.BooleanType.fromBoolean(Stream.of(values))) : new RESTServices.SingleAtomicCallField(name, BaseProxy.BooleanType.fromBoolean(values[0]));
        }
    }

    private static abstract class CharacterNodeFieldifier
    extends NodeFieldifier {
        CharacterNodeFieldifier(String typeName, Format format) {
            super(typeName, format);
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, Reader value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleNodeCallField(name, this.format(NodeConverter.ReaderToHandle(value)));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Reader[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleNodeCallField(name, this.formatAll(NodeConverter.ReaderToHandle(Stream.of(values)))) : new RESTServices.SingleNodeCallField(name, this.format(NodeConverter.ReaderToHandle(values[0])));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, String value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleNodeCallField(name, this.format(NodeConverter.StringToHandle(value)));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, String[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleNodeCallField(name, this.formatAll(NodeConverter.StringToHandle(Stream.of(values)))) : new RESTServices.SingleNodeCallField(name, this.format(NodeConverter.StringToHandle(values[0])));
        }
    }

    private static abstract class NodeFieldifier
    extends BaseFieldifier {
        private Format format;

        NodeFieldifier(String typeName, Format format) {
            super(typeName);
            this.format = format;
        }

        Format getFormat() {
            return this.format;
        }

        AbstractWriteHandle format(AbstractWriteHandle value) {
            return NodeConverter.withFormat(value, this.getFormat());
        }

        Stream<? extends AbstractWriteHandle> formatAll(AbstractWriteHandle[] value) {
            for (AbstractWriteHandle handle : value) {
                NodeConverter.withFormat(handle, this.getFormat());
            }
            return Stream.of(value);
        }

        Stream<? extends AbstractWriteHandle> formatAll(Stream<? extends AbstractWriteHandle> value) {
            return NodeConverter.streamWithFormat(value, this.getFormat());
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, AbstractWriteHandle value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleNodeCallField(name, this.format(value));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, AbstractWriteHandle[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleNodeCallField(name, this.formatAll(values)) : new RESTServices.SingleNodeCallField(name, this.format(values[0]));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, byte[] value) {
            if (this.isEmpty(name, nullable, (Object)value)) {
                return null;
            }
            return new RESTServices.SingleNodeCallField(name, this.format(NodeConverter.BytesToHandle(value)));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, byte[][] values) {
            if (this.isEmpty(name, nullable, (Object[])values)) {
                return null;
            }
            return this.isMultiple(name, multiple, (Object[])values) ? new RESTServices.MultipleNodeCallField(name, this.formatAll(NodeConverter.BytesToHandle(Stream.of(values)))) : new RESTServices.SingleNodeCallField(name, this.format(NodeConverter.BytesToHandle(values[0])));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, File value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleNodeCallField(name, this.format(NodeConverter.FileToHandle(value)));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, File[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleNodeCallField(name, this.formatAll(NodeConverter.FileToHandle(Stream.of(values)))) : new RESTServices.SingleNodeCallField(name, this.format(NodeConverter.FileToHandle(values[0])));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, InputStream value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleNodeCallField(name, this.format(NodeConverter.InputStreamToHandle(value)));
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, InputStream[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleNodeCallField(name, this.formatAll(NodeConverter.InputStreamToHandle(Stream.of(values)))) : new RESTServices.SingleNodeCallField(name, this.format(NodeConverter.InputStreamToHandle(values[0])));
        }
    }

    private static abstract class AtomicFieldifier
    extends BaseFieldifier {
        AtomicFieldifier(String typeName) {
            super(typeName);
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, String value) {
            if (this.isEmpty(name, nullable, value)) {
                return null;
            }
            return new RESTServices.SingleAtomicCallField(name, value);
        }

        @Override
        RESTServices.CallField field(String name, boolean nullable, boolean multiple, String[] values) {
            if (this.isEmpty(name, nullable, values)) {
                return null;
            }
            return this.isMultiple(name, multiple, values) ? new RESTServices.MultipleAtomicCallField(name, Stream.of(values)) : new RESTServices.SingleAtomicCallField(name, values[0]);
        }
    }

    private static abstract class BaseFieldifier {
        private String typeName;

        BaseFieldifier(String typeName) {
            this.typeName = typeName;
        }

        String getTypeName() {
            return this.typeName;
        }

        boolean isEmpty(String name, boolean nullable, Object value) {
            if (value == null) {
                if (!nullable) {
                    throw new BaseProxy.RequiredParamException("null value for required parameter: " + name);
                }
                return true;
            }
            return false;
        }

        boolean isEmpty(String name, boolean nullable, Object[] values) {
            if (values == null || values.length == 0) {
                if (!nullable) {
                    throw new BaseProxy.RequiredParamException("null value for required parameter: " + name);
                }
                return true;
            }
            return false;
        }

        boolean isMultiple(String name, boolean multiple, Object[] values) {
            if (values.length > 1) {
                if (!multiple) {
                    throw new IllegalArgumentException("multiple values not accepted for " + name + " parameter");
                }
                return true;
            }
            return false;
        }

        RESTServices.CallField field(String name, boolean nullable, AbstractWriteHandle value) {
            throw new IllegalArgumentException("AbstractWriteHandle value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, AbstractWriteHandle[] values) {
            throw new IllegalArgumentException("AbstractWriteHandle values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, BigDecimal value) {
            throw new IllegalArgumentException("BigDecimal value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, BigDecimal[] values) {
            throw new IllegalArgumentException("BigDecimal values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, byte[] value) {
            throw new IllegalArgumentException("byte[] value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, byte[][] values) {
            throw new IllegalArgumentException("byte[] values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, Boolean value) {
            throw new IllegalArgumentException("Boolean value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Boolean[] values) {
            throw new IllegalArgumentException("Boolean values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, Date value) {
            throw new IllegalArgumentException("Date value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Date[] values) {
            throw new IllegalArgumentException("Date values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, Document value) {
            throw new IllegalArgumentException("Document value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Document[] values) {
            throw new IllegalArgumentException("Document values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, Double value) {
            throw new IllegalArgumentException("Double value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Double[] values) {
            throw new IllegalArgumentException("Double values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, Duration value) {
            throw new IllegalArgumentException("Duration value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Duration[] values) {
            throw new IllegalArgumentException("Duration values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, File value) {
            throw new IllegalArgumentException("File value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, File[] values) {
            throw new IllegalArgumentException("File values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, Float value) {
            throw new IllegalArgumentException("Float value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Float[] values) {
            throw new IllegalArgumentException("Float values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, InputSource value) {
            throw new IllegalArgumentException("InputSource value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, InputSource[] values) {
            throw new IllegalArgumentException("InputSource values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, InputStream value) {
            throw new IllegalArgumentException("InputStream value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, InputStream[] values) {
            throw new IllegalArgumentException("InputStream values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, Integer value) {
            throw new IllegalArgumentException("Integer value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Integer[] values) {
            throw new IllegalArgumentException("Integer values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, JsonNode value) {
            throw new IllegalArgumentException("JsonNode value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, JsonNode[] values) {
            throw new IllegalArgumentException("JsonNode values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, JsonParser value) {
            throw new IllegalArgumentException("JsonParser value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, JsonParser[] values) {
            throw new IllegalArgumentException("JsonParser values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, LocalDate value) {
            throw new IllegalArgumentException("LocalDate value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, LocalDate[] values) {
            throw new IllegalArgumentException("LocalDate values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, LocalDateTime value) {
            throw new IllegalArgumentException("LocalDateTime value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, LocalDateTime[] values) {
            throw new IllegalArgumentException("LocalDateTime values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, LocalTime value) {
            throw new IllegalArgumentException("LocalTime value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, LocalTime[] values) {
            throw new IllegalArgumentException("LocalTime values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, Long value) {
            throw new IllegalArgumentException("Long value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Long[] values) {
            throw new IllegalArgumentException("Long values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, OffsetDateTime value) {
            throw new IllegalArgumentException("OffsetDateTime value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, OffsetDateTime[] values) {
            throw new IllegalArgumentException("OffsetDateTime values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, OffsetTime value) {
            throw new IllegalArgumentException("OffsetTime value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, OffsetTime[] values) {
            throw new IllegalArgumentException("OffsetTime values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, Reader value) {
            throw new IllegalArgumentException("Reader value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Reader[] values) {
            throw new IllegalArgumentException("Reader values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, Source value) {
            throw new IllegalArgumentException("Source value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, Source[] values) {
            throw new IllegalArgumentException("Source values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, String value) {
            throw new IllegalArgumentException("String value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, String[] values) {
            throw new IllegalArgumentException("String values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, XMLEventReader value) {
            throw new IllegalArgumentException("XMLEventReader value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, XMLEventReader[] values) {
            throw new IllegalArgumentException("XMLEventReader values not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, XMLStreamReader value) {
            throw new IllegalArgumentException("XMLStreamReader value not accepted for " + name + " parameter");
        }

        RESTServices.CallField field(String name, boolean nullable, boolean multiple, XMLStreamReader[] values) {
            throw new IllegalArgumentException("XMLStreamReader values not accepted for " + name + " parameter");
        }
    }

    private static class CallArgsImpl
    implements CallManager.CallArgs {
        private CallableEndpointImpl endpoint;
        private List<RESTServices.CallField> callFields;
        private SessionState session;
        private Set<String> assignedParams;

        CallArgsImpl(CallableEndpointImpl endpoint) {
            this.endpoint = endpoint;
        }

        CallArgsImpl(CallableEndpointImpl endpoint, SessionState session) {
            this(endpoint);
            ParamdefImpl sessiondef = endpoint.getSessiondef();
            if (sessiondef == null) {
                throw new IllegalArgumentException(this.getEndpoint().getModule() + " does not support sessions");
            }
            this.session = session;
        }

        SessionState getSession() {
            return this.session;
        }

        List<RESTServices.CallField> getCallFields() {
            return this.callFields;
        }

        Set<String> getAssignedParams() {
            return this.assignedParams;
        }

        private CallableEndpointImpl getEndpoint() {
            return this.endpoint;
        }

        private ParamdefImpl getParamdef(String name) {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException("empty parameter name");
            }
            ParamdefImpl paramdef = this.getEndpoint().getParamDef(name);
            if (paramdef == null) {
                throw new IllegalArgumentException("no parameter with name: " + name);
            }
            return paramdef;
        }

        private CallManager.CallArgs addField(RESTServices.CallField field) {
            if (field == null) {
                return this;
            }
            if (this.getEndpoint().getRequiredParams() != null) {
                if (this.assignedParams == null) {
                    this.assignedParams = new HashSet<String>();
                }
                this.assignedParams.add(field.getParamName());
            }
            if (this.callFields == null) {
                this.callFields = new ArrayList<RESTServices.CallField>();
            }
            this.callFields.add(field);
            return this;
        }

        @Override
        public CallManager.CallArgs param(String name, AbstractWriteHandle value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, AbstractWriteHandle[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, BigDecimal value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, BigDecimal[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, Boolean value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, Boolean[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, byte[] value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, byte[][] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, Date value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, Date[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, Document value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, Document[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, Double value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, Double[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, Duration value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, Duration[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, File value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, File[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, Float value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, Float[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, InputSource value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, InputSource[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, InputStream value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, InputStream[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, Integer value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, Integer[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, JsonNode value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, JsonNode[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, JsonParser value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, JsonParser[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, LocalDate value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, LocalDate[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, LocalDateTime value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, LocalDateTime[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, LocalTime value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, LocalTime[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, Long value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, Long[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, OffsetDateTime value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, OffsetDateTime[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, OffsetTime value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, OffsetTime[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, Reader value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, Reader[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, Source value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, Source[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, String value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, String[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, XMLEventReader value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, XMLEventReader[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }

        @Override
        public CallManager.CallArgs param(String name, XMLStreamReader value) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), value));
        }

        @Override
        public CallManager.CallArgs param(String name, XMLStreamReader[] values) {
            ParamdefImpl paramdef = this.getParamdef(name);
            return this.addField(paramdef.getFielder().field(name, paramdef.isNullable(), paramdef.isMultiple(), values));
        }
    }

    private static abstract class CallerImpl
    extends EndpointDefinerImpl {
        private CallableEndpointImpl endpoint;
        private BaseProxy.DBFunctionRequest request;

        CallerImpl(CallableEndpointImpl endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public String getEndpointPath() {
            return this.endpoint.getEndpointPath();
        }

        @Override
        public Boolean isSessionRequired() {
            return this.endpoint.isSessionRequired();
        }

        @Override
        public Map<String, CallManager.Paramdef> getParamdefs() {
            return this.endpoint.getParamdefs();
        }

        @Override
        public CallManager.Returndef getReturndef() {
            return this.endpoint.getReturndef();
        }

        @Override
        CallableEndpointImpl getEndpoint() {
            return this.endpoint;
        }

        BaseProxy.DBFunctionRequest startRequest(CallArgsImpl callArgs) {
            if (this.request == null) {
                BaseProxy.DBFunctionRequest request = this.endpoint.getBaseProxy().request(this.endpoint.getModule(), this.endpoint.getParameterValuesKind());
                ParamdefImpl sessiondef = this.endpoint.getSessiondef();
                request = sessiondef == null ? request.withSession() : request.withSession(sessiondef.getParamName(), callArgs.getSession(), sessiondef.isNullable());
                List<RESTServices.CallField> callFields = callArgs.getCallFields();
                int fieldSize = callFields == null ? 0 : callFields.size();
                Set<String> requiredParams = this.endpoint.getRequiredParams();
                if (fieldSize > 0) {
                    Set<String> assignedParams = callArgs.getAssignedParams();
                    if (requiredParams != null && !assignedParams.containsAll(requiredParams)) {
                        throw new IllegalArgumentException(this.endpoint.getModule() + " called without some required parameters: " + requiredParams.stream().filter(assignedParams::contains).collect(Collectors.joining(", ")));
                    }
                    request = request.withParams(callFields.toArray(new RESTServices.CallField[fieldSize]));
                } else if (requiredParams != null) {
                    throw new IllegalArgumentException(this.endpoint.getModule() + " called without the required parameters: " + requiredParams.stream().collect(Collectors.joining(", ")));
                }
                this.request = request.withMethod("POST");
            }
            return this.request;
        }
    }

    private static class ManyCallerImpl<R>
    extends CallerImpl
    implements CallManager.ManyCaller<R> {
        private ReturnConverter<R> converter;
        private Format format;

        ManyCallerImpl(CallableEndpointImpl endpoint, Format format, ReturnConverter<R> converter) {
            super(endpoint);
            this.converter = converter;
            this.format = format;
        }

        @Override
        public Stream<R> call() {
            return this.call(this.args());
        }

        @Override
        public Stream<R> call(CallManager.CallArgs args) {
            if (!(args instanceof CallArgsImpl)) {
                throw new IllegalArgumentException("arguments not constructed by the builder");
            }
            return this.converter.many(this.startRequest((CallArgsImpl)args).responseMultiple(this.getEndpoint().isNullable(), this.format));
        }
    }

    private static class OneCallerImpl<R>
    extends CallerImpl
    implements CallManager.OneCaller<R> {
        private ReturnConverter<R> converter;
        private Format format;

        OneCallerImpl(CallableEndpointImpl endpoint, Format format, ReturnConverter<R> converter) {
            super(endpoint);
            this.converter = converter;
            this.format = format;
        }

        @Override
        public R call() {
            return this.call(this.args());
        }

        @Override
        public R call(CallManager.CallArgs args) {
            if (!(args instanceof CallArgsImpl)) {
                throw new IllegalArgumentException("arguments not constructed by the builder");
            }
            return this.converter.one(this.startRequest((CallArgsImpl)args).responseSingle(this.getEndpoint().isNullable(), this.format));
        }
    }

    private static class NoneCallerImpl
    extends CallerImpl
    implements CallManager.NoneCaller {
        NoneCallerImpl(CallableEndpointImpl endpoint) {
            super(endpoint);
        }

        @Override
        public void call() {
            this.call(this.args());
        }

        @Override
        public void call(CallManager.CallArgs args) {
            if (!(args instanceof CallArgsImpl)) {
                throw new IllegalArgumentException("arguments not constructed by the builder");
            }
            this.startRequest((CallArgsImpl)args).responseNone();
        }
    }

    private static abstract class EndpointDefinerImpl
    implements CallManager.EndpointDefiner {
        private EndpointDefinerImpl() {
        }

        @Override
        public CallManager.CallArgs args() {
            return new CallArgsImpl(this.getEndpoint());
        }

        @Override
        public CallManager.CallArgs args(SessionState session) {
            return new CallArgsImpl(this.getEndpoint(), session);
        }

        abstract CallableEndpointImpl getEndpoint();
    }

    private static class ParamdefImpl
    extends ValuedefImpl
    implements CallManager.Paramdef {
        private String name;
        private BaseFieldifier fieldifier;

        ParamdefImpl(JsonNode paramDecl) {
            super(paramDecl);
            String paramName = CallManagerImpl.getText(paramDecl.get("name"));
            if (paramName == null || paramName.length() == 0) {
                throw new IllegalArgumentException("no name in parameter declaration: " + paramDecl.toString());
            }
            this.name = paramName;
            this.fieldifier = (BaseFieldifier)paramFieldifiers.get(this.getDataType());
            if (this.fieldifier == null) {
                throw new IllegalArgumentException("unknown data type in parameter declaration: " + paramDecl.toString());
            }
        }

        @Override
        public String getParamName() {
            return this.name;
        }

        BaseFieldifier getFielder() {
            return this.fieldifier;
        }
    }

    private static class ReturndefImpl
    extends ValuedefImpl
    implements CallManager.Returndef {
        private ServerTypeConverter typeConverter;
        private Format format;

        ReturndefImpl(JsonNode returnDecl) {
            super(returnDecl);
            String serverType = this.getDataType();
            this.typeConverter = (ServerTypeConverter)returnConverters.get(serverType);
            if (this.typeConverter == null) {
                throw new IllegalArgumentException("unknown data type in return declaration: " + returnDecl.toString());
            }
            this.format = (Format)((Object)typeFormats.get(serverType));
        }

        ServerTypeConverter getTypeConverter() {
            return this.typeConverter;
        }

        Format getFormat() {
            return this.format;
        }
    }

    private static abstract class ValuedefImpl {
        private String datatype = null;
        private boolean isNullable = false;
        private boolean isMultiple = false;

        ValuedefImpl(JsonNode valueDecl) {
            String datatype = CallManagerImpl.getText(valueDecl.get("datatype"));
            if (datatype == null || datatype.length() == 0) {
                throw new IllegalArgumentException("no datatype in parameter or return declaration: " + valueDecl.toString());
            }
            this.datatype = datatype;
            this.isNullable = CallManagerImpl.getBoolean(valueDecl.get("nullable"), false);
            this.isMultiple = CallManagerImpl.getBoolean(valueDecl.get("multiple"), false);
        }

        public String getDataType() {
            return this.datatype;
        }

        public boolean isNullable() {
            return this.isNullable;
        }

        public boolean isMultiple() {
            return this.isMultiple;
        }
    }

    private static class CallableEndpointImpl
    extends EndpointDefinerImpl
    implements CallManager.CallableEndpoint {
        private BaseProxy baseProxy;
        private String endpointDirectory;
        private String module;
        private String endpointPath;
        private ReturndefImpl returndef;
        private Map<String, ParamdefImpl> paramdefs;
        private Map<String, CallManager.Paramdef> params;
        private ParamdefImpl sessiondef;
        private Set<String> required;
        private BaseProxy.ParameterValuesKind parameterValuesKind = BaseProxy.ParameterValuesKind.NONE;

        CallableEndpointImpl(DatabaseClient client, JsonNode serviceDeclaration, JsonNode endpointDeclaration, String extension) {
            JsonNode functionReturn;
            this.endpointDirectory = CallManagerImpl.getText(serviceDeclaration.get("endpointDirectory"));
            if (this.endpointDirectory == null || this.endpointDirectory.length() == 0) {
                throw new IllegalArgumentException("no endpointDirectory in service declaration: " + serviceDeclaration.toString());
            }
            this.baseProxy = new BaseProxy(client, this.endpointDirectory);
            String functionName = CallManagerImpl.getText(endpointDeclaration.get("functionName"));
            if (functionName == null || functionName.length() == 0) {
                throw new IllegalArgumentException("no functionName in endpoint declaration: " + endpointDeclaration.toString());
            }
            this.module = functionName + "." + extension;
            JsonNode functionParams = endpointDeclaration.get("params");
            if (functionParams != null) {
                if (!functionParams.isArray()) {
                    throw new IllegalArgumentException("params not array in endpoint declaration: " + endpointDeclaration.toString());
                }
                int paramCount = functionParams.size();
                if (paramCount > 0) {
                    for (JsonNode functionParam : functionParams) {
                        if (!functionParam.isObject()) {
                            throw new IllegalArgumentException("parameter is not object in endpoint declaration: " + functionParam.toString());
                        }
                        ParamdefImpl paramdef = new ParamdefImpl(functionParam);
                        String datatype = paramdef.getDataType();
                        if (datatype == "session:") {
                            if (this.sessiondef != null) {
                                throw new IllegalArgumentException(this.module + " has two session parameters: " + this.sessiondef.getParamName() + " and " + paramdef.getParamName());
                            }
                            this.sessiondef = paramdef;
                            continue;
                        }
                        if (this.parameterValuesKind != BaseProxy.ParameterValuesKind.MULTIPLE_MIXED) {
                            boolean isNode = typeFormats.containsKey(datatype);
                            switch (this.parameterValuesKind) {
                                case NONE: {
                                    boolean isMultiple = paramdef.isMultiple();
                                    this.parameterValuesKind = isNode && isMultiple ? BaseProxy.ParameterValuesKind.MULTIPLE_NODES : (!isNode && isMultiple ? BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS : (isNode ? BaseProxy.ParameterValuesKind.SINGLE_NODE : BaseProxy.ParameterValuesKind.SINGLE_ATOMIC));
                                    break;
                                }
                                case SINGLE_ATOMIC: {
                                    this.parameterValuesKind = !isNode ? BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS : BaseProxy.ParameterValuesKind.MULTIPLE_MIXED;
                                    break;
                                }
                                case SINGLE_NODE: {
                                    this.parameterValuesKind = isNode ? BaseProxy.ParameterValuesKind.MULTIPLE_NODES : BaseProxy.ParameterValuesKind.MULTIPLE_MIXED;
                                    break;
                                }
                                case MULTIPLE_ATOMICS: {
                                    if (!isNode) break;
                                    this.parameterValuesKind = BaseProxy.ParameterValuesKind.MULTIPLE_MIXED;
                                    break;
                                }
                                case MULTIPLE_NODES: {
                                    if (isNode) break;
                                    this.parameterValuesKind = BaseProxy.ParameterValuesKind.MULTIPLE_MIXED;
                                    break;
                                }
                                default: {
                                    throw new InternalError("unknown case for " + (Object)((Object)this.parameterValuesKind));
                                }
                            }
                        }
                        if (this.paramdefs == null) {
                            this.paramdefs = new HashMap<String, ParamdefImpl>();
                        }
                        String paramName = paramdef.getParamName();
                        this.paramdefs.put(paramName, paramdef);
                        if (paramdef.isNullable()) continue;
                        if (this.required == null) {
                            this.required = new HashSet<String>();
                        }
                        this.required.add(paramName);
                    }
                }
            }
            if ((functionReturn = endpointDeclaration.get("return")) != null) {
                if (!functionReturn.isObject()) {
                    throw new IllegalArgumentException("return is not object in endpoint declaration: " + functionReturn.toString());
                }
                this.returndef = new ReturndefImpl(functionReturn);
            }
        }

        @Override
        CallableEndpointImpl getEndpoint() {
            return this;
        }

        @Override
        public String getEndpointPath() {
            if (this.endpointPath == null) {
                String endpointDir = this.endpointDirectory;
                if (!endpointDir.endsWith("/")) {
                    endpointDir = endpointDir + "/";
                }
                this.endpointPath = endpointDir + this.module;
            }
            return this.endpointPath;
        }

        @Override
        public Boolean isSessionRequired() {
            return this.sessiondef != null && !this.sessiondef.isNullable();
        }

        @Override
        public Map<String, CallManager.Paramdef> getParamdefs() {
            if (this.params == null && this.paramdefs != null) {
                Map<String, ParamdefImpl> paramstemp = this.paramdefs;
                this.params = Collections.unmodifiableMap(paramstemp);
            }
            return this.params;
        }

        @Override
        public CallManager.Returndef getReturndef() {
            return this.returndef;
        }

        @Override
        public CallManager.NoneCaller returningNone() {
            if (this.returndef != null && !this.isNullable()) {
                throw new IllegalArgumentException(this.module + " has a required return");
            }
            return new NoneCallerImpl(this);
        }

        @Override
        public <R> CallManager.OneCaller<R> returningOne(Class<R> as) {
            if (this.returndef == null) {
                throw new IllegalArgumentException(this.module + " does not return values");
            }
            if (this.returndef.isMultiple()) {
                throw new IllegalArgumentException(this.module + " returns multiple values");
            }
            return new OneCallerImpl<R>(this, this.returndef.getFormat(), this.returndef.getTypeConverter().forClientType(as));
        }

        @Override
        public <R> CallManager.ManyCaller<R> returningMany(Class<R> as) {
            if (this.returndef == null) {
                throw new IllegalArgumentException(this.module + " does not return values");
            }
            if (!this.returndef.isMultiple()) {
                throw new IllegalArgumentException(this.module + " returns a single value");
            }
            return new ManyCallerImpl<R>(this, this.returndef.getFormat(), this.returndef.getTypeConverter().forClientType(as));
        }

        boolean isNullable() {
            return this.returndef.isNullable();
        }

        BaseProxy getBaseProxy() {
            return this.baseProxy;
        }

        String getModule() {
            return this.module;
        }

        ParamdefImpl getSessiondef() {
            return this.sessiondef;
        }

        ParamdefImpl getParamDef(String name) {
            if (this.paramdefs == null) {
                return null;
            }
            return this.paramdefs.get(name);
        }

        Set<String> getRequiredParams() {
            return this.required;
        }

        BaseProxy.ParameterValuesKind getParameterValuesKind() {
            return this.parameterValuesKind;
        }
    }
}

