/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.document;

import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;

public interface DocumentWriteOperation {
    public OperationType getOperationType();

    public String getUri();

    public DocumentMetadataWriteHandle getMetadata();

    public AbstractWriteHandle getContent();

    public String getTemporalDocumentURI();

    public static Stream<DocumentWriteOperation> from(Stream<? extends AbstractWriteHandle> content, DocumentUriMaker uriMaker) {
        if (content == null || uriMaker == null) {
            throw new IllegalArgumentException("Content and/or Uri maker cannot be null");
        }
        final class WrapperImpl {
            private DocumentUriMaker docUriMaker;

            WrapperImpl(DocumentUriMaker uriMaker) {
                this.docUriMaker = uriMaker;
            }

            DocumentWriteOperation mapper(AbstractWriteHandle content) {
                String uri = (String)this.docUriMaker.apply(content);
                if (uri == null) {
                    throw new MarkLogicInternalException("Uri could not be created");
                }
                final class DocumentWriteOperationImpl
                implements DocumentWriteOperation {
                    private AbstractWriteHandle content;
                    private String uri;

                    public DocumentWriteOperationImpl(AbstractWriteHandle content, String uri) {
                        this.content = content;
                        this.uri = uri;
                    }

                    @Override
                    public OperationType getOperationType() {
                        return null;
                    }

                    @Override
                    public String getUri() {
                        return this.uri;
                    }

                    @Override
                    public DocumentMetadataWriteHandle getMetadata() {
                        return null;
                    }

                    @Override
                    public AbstractWriteHandle getContent() {
                        return this.content;
                    }

                    @Override
                    public String getTemporalDocumentURI() {
                        return null;
                    }
                }
                return new DocumentWriteOperationImpl(content, uri);
            }
        }
        WrapperImpl wrapperImpl = new WrapperImpl(uriMaker);
        return content.map(wrapperImpl::mapper);
    }

    public static DocumentUriMaker uriMaker(String format) throws IllegalArgumentException {
        if (format == null || format.length() == 0) {
            throw new IllegalArgumentException("Format cannot be null or empty");
        }
        final class FormatUriMaker {
            private String uriFormat;

            FormatUriMaker(String format) {
                this.uriFormat = format;
            }

            String makeUri(AbstractWriteHandle content) {
                return String.format(this.uriFormat, UUID.randomUUID());
            }
        }
        FormatUriMaker formatUriMaker = new FormatUriMaker(format);
        return formatUriMaker::makeUri;
    }

    @FunctionalInterface
    public static interface DocumentUriMaker
    extends Function<AbstractWriteHandle, String> {
    }

    public static enum OperationType {
        METADATA_DEFAULT,
        DISABLE_METADATA_DEFAULT,
        DOCUMENT_WRITE;

    }
}

