/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.SessionState;
import com.marklogic.client.impl.DatabaseClientImpl;
import com.marklogic.client.impl.NodeConverter;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.SessionStateImpl;
import com.marklogic.client.impl.ValueConverter;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.BinaryReadHandle;
import com.marklogic.client.io.marker.BinaryWriteHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Date;
import java.util.stream.Stream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class BaseProxy {
    private static ObjectMapper mapper = null;
    private String endpointDir;
    private RESTServices services;

    protected static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        return mapper;
    }

    public BaseProxy(DatabaseClient db, String endpointDir) {
        if (db == null) {
            throw new IllegalArgumentException("Cannot connect with null database client");
        }
        if (db.getDatabase() != null) {
            throw new IllegalArgumentException("Client cannot specify a database - specified: " + db.getDatabase());
        }
        if (endpointDir == null || endpointDir.length() == 0) {
            throw new IllegalArgumentException("Cannot make requests with null or empty endpoint directory");
        }
        this.endpointDir = endpointDir;
        DatabaseClientImpl dbImpl = (DatabaseClientImpl)db;
        this.services = dbImpl.getServices();
    }

    public DBFunctionRequest request(String module, ParameterValuesKind paramsKind) {
        if (module == null) {
            throw new IllegalArgumentException("null module");
        }
        return new DBFunctionRequest(this.services, this.endpointDir, module, paramsKind);
    }

    public static RESTServices.SingleAtomicCallField atomicParam(String paramName, boolean isNullable, String value) {
        return BaseProxy.isParamNull(paramName, isNullable, value) ? null : new RESTServices.SingleAtomicCallField(paramName, value);
    }

    public static RESTServices.MultipleAtomicCallField atomicParam(String paramName, boolean isNullable, Stream<String> values) {
        return BaseProxy.isParamNull(paramName, isNullable, values) ? null : new RESTServices.MultipleAtomicCallField(paramName, values);
    }

    public static RESTServices.SingleNodeCallField documentParam(String paramName, boolean isNullable, AbstractWriteHandle value) {
        return BaseProxy.isParamNull(paramName, isNullable, value) ? null : new RESTServices.SingleNodeCallField(paramName, value);
    }

    public static RESTServices.MultipleNodeCallField documentParam(String paramName, boolean isNullable, Stream<? extends AbstractWriteHandle> values) {
        return BaseProxy.isParamNull(paramName, isNullable, values) ? null : new RESTServices.MultipleNodeCallField(paramName, values);
    }

    protected static boolean isParamNull(String paramName, boolean isNullable, Object value) {
        if (value != null) {
            return false;
        }
        if (!isNullable) {
            throw new RequiredParamException("null value for required parameter: " + paramName);
        }
        return true;
    }

    public SessionState newSessionState() {
        return new SessionStateImpl();
    }

    public static class RequiredReturnException
    extends IllegalArgumentException {
        public RequiredReturnException(String s) {
            super(s);
        }
    }

    public static class RequiredParamException
    extends IllegalArgumentException {
        public RequiredParamException(String s) {
            super(s);
        }
    }

    public static class DBFunctionRequest {
        private RESTServices services;
        private String endpoint;
        private ParameterValuesKind paramsKind;
        private RESTServices.CallField[] params;
        private SessionState session;
        private RESTServices.HttpMethod method = RESTServices.HttpMethod.POST;

        private DBFunctionRequest(RESTServices services, String endpointDir, String module, ParameterValuesKind paramsKind) {
            this.services = services;
            this.endpoint = endpointDir + module;
            this.paramsKind = paramsKind;
        }

        public DBFunctionRequest withSession() {
            return this;
        }

        public DBFunctionRequest withSession(String paramName, SessionState session, boolean isNullable) {
            if (session != null) {
                this.session = session;
            } else if (!isNullable) {
                throw new RequiredParamException("null value for required session parameter: " + paramName);
            }
            return this;
        }

        public DBFunctionRequest withParams(RESTServices.CallField ... params) {
            this.params = params;
            return this;
        }

        public DBFunctionRequest withMethod(String method) {
            this.method = RESTServices.HttpMethod.valueOf(method);
            return this;
        }

        private RESTServices.CallRequest makeRequest() {
            switch (this.paramsKind) {
                case NONE: {
                    return this.services.makeEmptyRequest(this.endpoint, this.method, this.session);
                }
                case SINGLE_ATOMIC: 
                case MULTIPLE_ATOMICS: {
                    if (this.params == null || this.params.length == 0 || this.params.length == 1 && this.params[0] == null) {
                        return this.services.makeEmptyRequest(this.endpoint, this.method, this.session);
                    }
                    return this.services.makeAtomicBodyRequest(this.endpoint, this.method, this.session, this.params);
                }
                case SINGLE_NODE: {
                    if (this.params == null || this.params.length == 0) {
                        return this.services.makeEmptyRequest(this.endpoint, this.method, this.session);
                    }
                    if (this.params.length > 1) {
                        throw new InternalError("multiple parameters instead of single node");
                    }
                    if (this.params[0] == null) {
                        return this.services.makeEmptyRequest(this.endpoint, this.method, this.session);
                    }
                    if (this.params.length > 1 || !(this.params[0] instanceof RESTServices.SingleNodeCallField)) {
                        throw new InternalError("invalid parameter type instead of single node: " + this.params[0].getClass().getName());
                    }
                    return this.services.makeNodeBodyRequest(this.endpoint, this.method, this.session, this.params);
                }
                case MULTIPLE_NODES: 
                case MULTIPLE_MIXED: {
                    return this.services.makeNodeBodyRequest(this.endpoint, this.method, this.session, this.params);
                }
            }
            throw new InternalError("unknown parameters kind: " + this.paramsKind.name());
        }

        public void responseNone() {
            RESTServices.CallRequest requestdef = this.makeRequest();
            RESTServices.CallResponse responsedef = requestdef.withEmptyResponse();
        }

        public RESTServices.SingleCallResponse responseSingle(boolean isNullable, Format returnFormat) {
            RESTServices.CallRequest requestdef = this.makeRequest();
            RESTServices.SingleCallResponse responsedef = requestdef.withDocumentResponse(returnFormat == null ? Format.TEXT : returnFormat);
            if (responsedef.isNull() && !isNullable) {
                throw new RequiredReturnException("null for required single return value");
            }
            return responsedef;
        }

        public RESTServices.MultipleCallResponse responseMultiple(boolean isNullable, Format returnFormat) {
            RESTServices.CallRequest requestdef = this.makeRequest();
            RESTServices.MultipleCallResponse responsedef = requestdef.withMultipartMixedResponse(returnFormat == null ? Format.TEXT : returnFormat);
            if (responsedef.isNull() && !isNullable) {
                throw new RequiredReturnException("null for required multiple return value");
            }
            return responsedef;
        }
    }

    public static enum ParameterValuesKind {
        NONE,
        SINGLE_ATOMIC,
        SINGLE_NODE,
        MULTIPLE_ATOMICS,
        MULTIPLE_NODES,
        MULTIPLE_MIXED;

    }

    public static final class XmlDocumentType
    implements CharacterNodeDataType {
        public static final String NAME = "xmlDocument";
        public static final Format FORMAT = Format.XML;

        public static final XMLWriteHandle fromXMLWriteHandle(XMLWriteHandle value) {
            return NodeConverter.XMLWriter(value);
        }

        public static final Stream<XMLWriteHandle> fromXMLWriteHandle(Stream<? extends XMLWriteHandle> values) {
            return NodeConverter.XMLWriter(values);
        }

        public static final XMLWriteHandle fromDocument(Document value) {
            return NodeConverter.XMLWriter(NodeConverter.DocumentToHandle(value));
        }

        public static final Stream<XMLWriteHandle> fromDocument(Stream<? extends Document> values) {
            return NodeConverter.XMLWriter(NodeConverter.DocumentToHandle(values));
        }

        public static final XMLWriteHandle fromInputSource(InputSource value) {
            return NodeConverter.XMLWriter(NodeConverter.InputSourceToHandle(value));
        }

        public static final Stream<XMLWriteHandle> fromInputSource(Stream<? extends InputSource> values) {
            return NodeConverter.XMLWriter(NodeConverter.InputSourceToHandle(values));
        }

        public static final XMLWriteHandle fromSource(Source value) {
            return NodeConverter.XMLWriter(NodeConverter.SourceToHandle(value));
        }

        public static final Stream<XMLWriteHandle> fromSource(Stream<? extends Source> values) {
            return NodeConverter.XMLWriter(NodeConverter.SourceToHandle(values));
        }

        public static final XMLWriteHandle fromXMLEventReader(XMLEventReader value) {
            return NodeConverter.XMLWriter(NodeConverter.XMLEventReaderToHandle(value));
        }

        public static final Stream<XMLWriteHandle> fromXMLEventReader(Stream<? extends XMLEventReader> values) {
            return NodeConverter.XMLWriter(NodeConverter.XMLEventReaderToHandle(values));
        }

        public static final XMLWriteHandle fromXMLStreamReader(XMLStreamReader value) {
            return NodeConverter.XMLWriter(NodeConverter.XMLStreamReaderToHandle(value));
        }

        public static final Stream<XMLWriteHandle> fromXMLStreamReader(Stream<? extends XMLStreamReader> values) {
            return NodeConverter.XMLWriter(NodeConverter.XMLStreamReaderToHandle(values));
        }

        public static final XMLWriteHandle fromFile(File value) {
            return NodeConverter.XMLWriter(NodeConverter.FileToHandle(value));
        }

        public static final Stream<XMLWriteHandle> fromFile(Stream<? extends File> values) {
            return NodeConverter.XMLWriter(NodeConverter.FileToHandle(values));
        }

        public static final XMLWriteHandle fromInputStream(InputStream value) {
            return NodeConverter.XMLWriter(NodeConverter.InputStreamToHandle(value));
        }

        public static final Stream<XMLWriteHandle> fromInputStream(Stream<? extends InputStream> values) {
            return NodeConverter.XMLWriter(NodeConverter.InputStreamToHandle(values));
        }

        public static final XMLWriteHandle fromOutputStreamSender(OutputStreamSender value) {
            return NodeConverter.XMLWriter(NodeConverter.OutputStreamSenderToHandle(value));
        }

        public static final Stream<XMLWriteHandle> fromOutputStreamSender(Stream<? extends OutputStreamSender> values) {
            return NodeConverter.XMLWriter(NodeConverter.OutputStreamSenderToHandle(values));
        }

        public static final XMLWriteHandle fromReader(Reader value) {
            return NodeConverter.XMLWriter(NodeConverter.ReaderToHandle(value));
        }

        public static final Stream<XMLWriteHandle> fromReader(Stream<? extends Reader> values) {
            return NodeConverter.XMLWriter(NodeConverter.ReaderToHandle(values));
        }

        public static final XMLWriteHandle fromString(String value) {
            return NodeConverter.XMLWriter(NodeConverter.StringToHandle(value));
        }

        public static final Stream<XMLWriteHandle> fromString(Stream<? extends String> values) {
            return NodeConverter.XMLWriter(NodeConverter.StringToHandle(values));
        }

        public static final Document toDocument(RESTServices.SingleCallResponse response) {
            return NodeConverter.InputStreamToDocument(response.asInputStream());
        }

        public static final Stream<Document> toDocument(RESTServices.MultipleCallResponse response) {
            return NodeConverter.InputStreamToDocument(response.asStreamOfInputStream());
        }

        public static final InputSource toInputSource(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToInputSource(response.asReader());
        }

        public static final Stream<InputSource> toInputSource(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToInputSource(response.asStreamOfReader());
        }

        public static final Source toSource(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToSource(response.asReader());
        }

        public static final Stream<Source> toSource(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToSource(response.asStreamOfReader());
        }

        public static final XMLEventReader toXMLEventReader(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToXMLEventReader(response.asReader());
        }

        public static final Stream<XMLEventReader> toXMLEventReader(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToXMLEventReader(response.asStreamOfReader());
        }

        public static final XMLStreamReader toXMLStreamReader(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToXMLStreamReader(response.asReader());
        }

        public static final Stream<XMLStreamReader> toXMLStreamReader(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToXMLStreamReader(response.asStreamOfReader());
        }

        public static final byte[] toBytes(RESTServices.SingleCallResponse response) {
            return response.asBytes();
        }

        public static final Stream<byte[]> toBytes(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfBytes();
        }

        public static final InputStream toInputStream(RESTServices.SingleCallResponse response) {
            return response.asInputStream();
        }

        public static final Stream<InputStream> toInputStream(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfInputStream();
        }

        public static final Reader toReader(RESTServices.SingleCallResponse response) {
            return response.asReader();
        }

        public static final Stream<Reader> toReader(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfReader();
        }

        public static final XMLReadHandle toXMLReadHandle(RESTServices.SingleCallResponse response) {
            return NodeConverter.XMLReader(NodeConverter.ReaderToHandle(response.asReader()));
        }

        public static final Stream<XMLReadHandle> toXMLReadHandle(RESTServices.MultipleCallResponse response) {
            return NodeConverter.XMLReader(NodeConverter.ReaderToHandle(response.asStreamOfReader()));
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class TextDocumentType
    implements CharacterNodeDataType {
        public static final String NAME = "textDocument";
        public static final Format FORMAT = Format.TEXT;

        public static final TextWriteHandle fromTextWriteHandle(TextWriteHandle value) {
            return NodeConverter.TextWriter(value);
        }

        public static final Stream<TextWriteHandle> fromTextWriteHandle(Stream<? extends TextWriteHandle> values) {
            return NodeConverter.TextWriter(values);
        }

        public static final TextWriteHandle fromFile(File value) {
            return NodeConverter.TextWriter(NodeConverter.FileToHandle(value));
        }

        public static final Stream<TextWriteHandle> fromFile(Stream<? extends File> values) {
            return NodeConverter.TextWriter(NodeConverter.FileToHandle(values));
        }

        public static final TextWriteHandle fromInputStream(InputStream value) {
            return NodeConverter.TextWriter(NodeConverter.InputStreamToHandle(value));
        }

        public static final Stream<TextWriteHandle> fromInputStream(Stream<? extends InputStream> values) {
            return NodeConverter.TextWriter(NodeConverter.InputStreamToHandle(values));
        }

        public static final TextWriteHandle fromOutputStreamSender(OutputStreamSender value) {
            return NodeConverter.TextWriter(NodeConverter.OutputStreamSenderToHandle(value));
        }

        public static final Stream<TextWriteHandle> fromOutputStreamSender(Stream<? extends OutputStreamSender> values) {
            return NodeConverter.TextWriter(NodeConverter.OutputStreamSenderToHandle(values));
        }

        public static final TextWriteHandle fromReader(Reader value) {
            return NodeConverter.TextWriter(NodeConverter.ReaderToHandle(value));
        }

        public static final Stream<TextWriteHandle> fromReader(Stream<? extends Reader> values) {
            return NodeConverter.TextWriter(NodeConverter.ReaderToHandle(values));
        }

        public static final TextWriteHandle fromString(String value) {
            return NodeConverter.TextWriter(NodeConverter.StringToHandle(value));
        }

        public static final Stream<TextWriteHandle> fromString(Stream<String> values) {
            return NodeConverter.TextWriter(NodeConverter.StringToHandle(values));
        }

        public static final byte[] toBytes(RESTServices.SingleCallResponse response) {
            return response.asBytes();
        }

        public static final Stream<byte[]> toBytes(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfBytes();
        }

        public static final InputStream toInputStream(RESTServices.SingleCallResponse response) {
            return response.asInputStream();
        }

        public static final Stream<InputStream> toInputStream(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfInputStream();
        }

        public static final Reader toReader(RESTServices.SingleCallResponse response) {
            return response.asReader();
        }

        public static final Stream<Reader> toReader(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfReader();
        }

        public static final TextReadHandle toTextReadHandle(RESTServices.SingleCallResponse response) {
            return NodeConverter.TextReader(NodeConverter.ReaderToHandle(response.asReader()));
        }

        public static final Stream<TextReadHandle> toTextReadHandle(RESTServices.MultipleCallResponse response) {
            return NodeConverter.TextReader(NodeConverter.ReaderToHandle(response.asStreamOfReader()));
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class ObjectType
    extends JsonDocumentType {
        public static final String NAME = "object";
        public static final Format FORMAT = Format.JSON;
    }

    public static final class ArrayType
    extends JsonDocumentType {
        public static final String NAME = "array";
        public static final Format FORMAT = Format.JSON;
    }

    public static class JsonDocumentType
    implements CharacterNodeDataType {
        public static final String NAME = "jsonDocument";
        public static final Format FORMAT = Format.JSON;

        public static final JSONWriteHandle fromJSONWriteHandle(JSONWriteHandle value) {
            return NodeConverter.JSONWriter(value);
        }

        public static final Stream<JSONWriteHandle> fromJSONWriteHandle(Stream<? extends JSONWriteHandle> values) {
            return NodeConverter.JSONWriter(values);
        }

        public static final JSONWriteHandle fromJsonNode(JsonNode value) {
            return NodeConverter.JSONWriter(NodeConverter.JsonNodeToHandle(value));
        }

        public static final Stream<JSONWriteHandle> fromJsonNode(Stream<? extends JsonNode> values) {
            return NodeConverter.JSONWriter(NodeConverter.JsonNodeToHandle(values));
        }

        public static final JSONWriteHandle fromArrayNode(ArrayNode value) {
            return NodeConverter.JSONWriter(NodeConverter.JsonNodeToHandle((JsonNode)value));
        }

        public static final Stream<JSONWriteHandle> fromArrayNode(Stream<? extends ArrayNode> values) {
            return NodeConverter.JSONWriter(NodeConverter.JsonNodeToHandle(values));
        }

        public static final JSONWriteHandle fromObjectNode(ObjectNode value) {
            return NodeConverter.JSONWriter(NodeConverter.JsonNodeToHandle((JsonNode)value));
        }

        public static final Stream<JSONWriteHandle> fromObjectNode(Stream<? extends ObjectNode> values) {
            return NodeConverter.JSONWriter(NodeConverter.JsonNodeToHandle(values));
        }

        public static final JSONWriteHandle fromJsonParser(JsonParser value) {
            return NodeConverter.JSONWriter(NodeConverter.JsonParserToHandle(value));
        }

        public static final Stream<JSONWriteHandle> fromJsonParser(Stream<? extends JsonParser> values) {
            return NodeConverter.JSONWriter(NodeConverter.JsonParserToHandle(values));
        }

        public static final JSONWriteHandle fromFile(File value) {
            return NodeConverter.JSONWriter(NodeConverter.FileToHandle(value));
        }

        public static final Stream<JSONWriteHandle> fromFile(Stream<? extends File> values) {
            return NodeConverter.JSONWriter(NodeConverter.FileToHandle(values));
        }

        public static final JSONWriteHandle fromInputStream(InputStream value) {
            return NodeConverter.JSONWriter(NodeConverter.InputStreamToHandle(value));
        }

        public static final Stream<JSONWriteHandle> fromInputStream(Stream<? extends InputStream> values) {
            return NodeConverter.JSONWriter(NodeConverter.InputStreamToHandle(values));
        }

        public static final JSONWriteHandle fromOutputStreamSender(OutputStreamSender value) {
            return NodeConverter.JSONWriter(NodeConverter.OutputStreamSenderToHandle(value));
        }

        public static final Stream<JSONWriteHandle> fromOutputStreamSender(Stream<? extends OutputStreamSender> values) {
            return NodeConverter.JSONWriter(NodeConverter.OutputStreamSenderToHandle(values));
        }

        public static final JSONWriteHandle fromReader(Reader value) {
            return NodeConverter.JSONWriter(NodeConverter.ReaderToHandle(value));
        }

        public static final Stream<JSONWriteHandle> fromReader(Stream<? extends Reader> values) {
            return NodeConverter.JSONWriter(NodeConverter.ReaderToHandle(values));
        }

        public static final JSONWriteHandle fromString(String value) {
            return NodeConverter.JSONWriter(NodeConverter.StringToHandle(value));
        }

        public static final Stream<JSONWriteHandle> fromString(Stream<? extends String> values) {
            return NodeConverter.JSONWriter(NodeConverter.StringToHandle(values));
        }

        public static final ArrayNode toArrayNode(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToArrayNode(response.asReader());
        }

        public static final Stream<ArrayNode> toArrayNode(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToArrayNode(response.asStreamOfReader());
        }

        public static final JsonNode toJsonNode(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToJsonNode(response.asReader());
        }

        public static final Stream<JsonNode> toJsonNode(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToJsonNode(response.asStreamOfReader());
        }

        public static final ObjectNode toObjectNode(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToObjectNode(response.asReader());
        }

        public static final Stream<ObjectNode> toObjectNode(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToObjectNode(response.asStreamOfReader());
        }

        public static final JsonParser toJsonParser(RESTServices.SingleCallResponse response) {
            return NodeConverter.ReaderToJsonParser(response.asReader());
        }

        public static final Stream<JsonParser> toJsonParser(RESTServices.MultipleCallResponse response) {
            return NodeConverter.ReaderToJsonParser(response.asStreamOfReader());
        }

        public static final byte[] toBytes(RESTServices.SingleCallResponse response) {
            return response.asBytes();
        }

        public static final Stream<byte[]> toBytes(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfBytes();
        }

        public static final InputStream toInputStream(RESTServices.SingleCallResponse response) {
            return response.asInputStream();
        }

        public static final Stream<InputStream> toInputStream(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfInputStream();
        }

        public static final Reader toReader(RESTServices.SingleCallResponse response) {
            return response.asReader();
        }

        public static final Stream<Reader> toReader(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfReader();
        }

        public static final JSONReadHandle toJSONReadHandle(RESTServices.SingleCallResponse response) {
            return NodeConverter.JSONReader(NodeConverter.ReaderToHandle(response.asReader()));
        }

        public static final Stream<JSONReadHandle> toJSONReadHandle(RESTServices.MultipleCallResponse response) {
            return NodeConverter.JSONReader(NodeConverter.ReaderToHandle(response.asStreamOfReader()));
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class BinaryDocumentType
    implements NodeDataType {
        public static final String NAME = "binaryDocument";
        public static final Format FORMAT = Format.BINARY;

        public static final BinaryWriteHandle fromBinaryWriteHandle(BinaryWriteHandle value) {
            return NodeConverter.BinaryWriter(value);
        }

        public static final Stream<BinaryWriteHandle> fromBinaryWriteHandle(Stream<? extends BinaryWriteHandle> values) {
            return NodeConverter.BinaryWriter(values);
        }

        public static final BinaryWriteHandle fromBytes(byte[] value) {
            return NodeConverter.BinaryWriter(NodeConverter.BytesToHandle(value));
        }

        public static final Stream<BinaryWriteHandle> fromBytes(Stream<? extends byte[]> values) {
            return NodeConverter.BinaryWriter(NodeConverter.BytesToHandle(values));
        }

        public static final BinaryWriteHandle fromFile(File value) {
            return NodeConverter.BinaryWriter(NodeConverter.FileToHandle(value));
        }

        public static final Stream<BinaryWriteHandle> fromFile(Stream<? extends File> values) {
            return NodeConverter.BinaryWriter(NodeConverter.FileToHandle(values));
        }

        public static final BinaryWriteHandle fromInputStream(InputStream value) {
            return NodeConverter.BinaryWriter(NodeConverter.InputStreamToHandle(value));
        }

        public static final Stream<BinaryWriteHandle> fromInputStream(Stream<? extends InputStream> values) {
            return NodeConverter.BinaryWriter(NodeConverter.InputStreamToHandle(values));
        }

        public static final BinaryWriteHandle fromOutputStreamSender(OutputStreamSender value) {
            return NodeConverter.BinaryWriter(NodeConverter.OutputStreamSenderToHandle(value));
        }

        public static final Stream<BinaryWriteHandle> fromOutputStreamSender(Stream<? extends OutputStreamSender> values) {
            return NodeConverter.BinaryWriter(NodeConverter.OutputStreamSenderToHandle(values));
        }

        public static final byte[] toBytes(RESTServices.SingleCallResponse response) {
            return response.asBytes();
        }

        public static final Stream<byte[]> toBytes(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfBytes();
        }

        public static final BinaryReadHandle toBinaryReadHandle(RESTServices.SingleCallResponse response) {
            return NodeConverter.BinaryReader(NodeConverter.InputStreamToHandle(response.asInputStream()));
        }

        public static final Stream<BinaryReadHandle> toBinaryReadHandle(RESTServices.MultipleCallResponse response) {
            return NodeConverter.BinaryReader(NodeConverter.InputStreamToHandle(response.asStreamOfInputStream()));
        }

        public static final InputStream toInputStream(RESTServices.SingleCallResponse response) {
            return response.asInputStream();
        }

        public static final Stream<InputStream> toInputStream(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfInputStream();
        }
    }

    public static final class UnsignedLongType
    implements AtomicDataType {
        public static final String NAME = "unsignedLong";

        public static final String fromLong(Long value) {
            return ValueConverter.UnsignedLongToString(value);
        }

        public static final Stream<String> fromLong(Stream<? extends Long> values) {
            return ValueConverter.UnsignedLongToString(values);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Long toLong(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToUnsignedLong(response.asString());
        }

        public static final Stream<Long> toLong(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToUnsignedLong(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class UnsignedIntegerType
    implements AtomicDataType {
        public static final String NAME = "unsignedInt";

        public static final String fromInteger(Integer value) {
            return ValueConverter.UnsignedIntegerToString(value);
        }

        public static final Stream<String> fromInteger(Stream<? extends Integer> values) {
            return ValueConverter.UnsignedIntegerToString(values);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Integer toInteger(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToUnsignedInteger(response.asString());
        }

        public static final Stream<Integer> toInteger(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToUnsignedInteger(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class TimeType
    implements AtomicDataType {
        public static final String NAME = "time";

        public static final String fromLocalTime(LocalTime value) {
            return ValueConverter.LocalTimeToString(value);
        }

        public static final Stream<String> fromLocalTime(Stream<? extends LocalTime> values) {
            return ValueConverter.LocalTimeToString(values);
        }

        public static final String fromOffsetTime(OffsetTime value) {
            return ValueConverter.OffsetTimeToString(value);
        }

        public static final Stream<String> fromOffsetTime(Stream<? extends OffsetTime> values) {
            return ValueConverter.OffsetTimeToString(values);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final LocalTime toLocalTime(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToLocalTime(response.asString());
        }

        public static final Stream<LocalTime> toLocalTime(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToLocalTime(response.asStreamOfString());
        }

        public static final OffsetTime toOffsetTime(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToOffsetTime(response.asString());
        }

        public static final Stream<OffsetTime> toOffsetTime(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToOffsetTime(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class StringType
    implements AtomicDataType {
        public static final String NAME = "string";

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class LongType
    implements AtomicDataType {
        public static final String NAME = "long";

        public static final String fromLong(Long value) {
            return ValueConverter.LongToString(value);
        }

        public static final Stream<String> fromLong(Stream<? extends Long> values) {
            return ValueConverter.LongToString(values);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Long toLong(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToLong(response.asString());
        }

        public static final Stream<Long> toLong(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToLong(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class IntegerType
    implements AtomicDataType {
        public static final String NAME = "int";

        public static final String fromInteger(Integer value) {
            return ValueConverter.IntegerToString(value);
        }

        public static final Stream<String> fromInteger(Stream<? extends Integer> values) {
            return ValueConverter.IntegerToString(values);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Integer toInteger(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToInteger(response.asString());
        }

        public static final Stream<Integer> toInteger(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToInteger(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class FloatType
    implements AtomicDataType {
        public static final String NAME = "float";

        public static final String fromFloat(Float value) {
            return ValueConverter.FloatToString(value);
        }

        public static final Stream<String> fromFloat(Stream<? extends Float> values) {
            return ValueConverter.FloatToString(values);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Float toFloat(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToFloat(response.asString());
        }

        public static final Stream<Float> toFloat(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToFloat(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class DoubleType
    implements AtomicDataType {
        public static final String NAME = "double";

        public static final String fromDouble(Double value) {
            return ValueConverter.DoubleToString(value);
        }

        public static final Stream<String> fromDouble(Stream<? extends Double> values) {
            return ValueConverter.DoubleToString(values);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Double toDouble(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToDouble(response.asString());
        }

        public static final Stream<Double> toDouble(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToDouble(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class DecimalType
    implements AtomicDataType {
        public static final String NAME = "decimal";

        public static final String fromBigDecimal(BigDecimal value) {
            return ValueConverter.BigDecimalToString(value);
        }

        public static final Stream<String> fromBigDecimal(Stream<? extends BigDecimal> values) {
            return ValueConverter.BigDecimalToString(values);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final BigDecimal toBigDecimal(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToBigDecimal(response.asString());
        }

        public static final Stream<BigDecimal> toBigDecimal(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToBigDecimal(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class DayTimeDurationType
    implements AtomicDataType {
        public static final String NAME = "dayTimeDuration";

        public static final String fromDuration(Duration value) {
            return ValueConverter.DurationToString(value);
        }

        public static final Stream<String> fromDuration(Stream<? extends Duration> values) {
            return ValueConverter.DurationToString(values);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Duration toDuration(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToDuration(response.asString());
        }

        public static final Stream<Duration> toDuration(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToDuration(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class DateTimeType
    implements AtomicDataType {
        public static final String NAME = "dateTime";

        public static final String fromDate(Date value) {
            return ValueConverter.DateToString(value);
        }

        public static final Stream<String> fromDate(Stream<? extends Date> values) {
            return ValueConverter.DateToString(values);
        }

        public static final String fromLocalDateTime(LocalDateTime value) {
            return ValueConverter.LocalDateTimeToString(value);
        }

        public static final Stream<String> fromLocalDateTime(Stream<? extends LocalDateTime> values) {
            return ValueConverter.LocalDateTimeToString(values);
        }

        public static final String fromOffsetDateTime(OffsetDateTime value) {
            return ValueConverter.OffsetDateTimeToString(value);
        }

        public static final Stream<String> fromOffsetDateTime(Stream<? extends OffsetDateTime> values) {
            return ValueConverter.OffsetDateTimeToString(values);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Date toDate(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToDate(response.asString());
        }

        public static final Stream<Date> toDate(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToDate(response.asStreamOfString());
        }

        public static final LocalDateTime toLocalDateTime(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToLocalDateTime(response.asString());
        }

        public static final Stream<LocalDateTime> toLocalDateTime(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToLocalDateTime(response.asStreamOfString());
        }

        public static final OffsetDateTime toOffsetDateTime(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToOffsetDateTime(response.asString());
        }

        public static final Stream<OffsetDateTime> toOffsetDateTime(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToOffsetDateTime(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class DateType
    implements AtomicDataType {
        public static final String NAME = "date";

        public static final String fromLocalDate(LocalDate value) {
            return ValueConverter.LocalDateToString(value);
        }

        public static final Stream<String> fromLocalDate(Stream<? extends LocalDate> values) {
            return ValueConverter.LocalDateToString(values);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final LocalDate toLocalDate(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToLocalDate(response.asString());
        }

        public static final Stream<LocalDate> toLocalDate(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToLocalDate(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static final class BooleanType
    implements AtomicDataType {
        public static final String NAME = "boolean";

        public static final String fromBoolean(Boolean value) {
            return ValueConverter.BooleanToString(value);
        }

        public static final Stream<String> fromBoolean(Stream<? extends Boolean> values) {
            return ValueConverter.BooleanToString(values);
        }

        public static final String fromString(String value) {
            return value;
        }

        public static final Stream<String> fromString(Stream<String> values) {
            return values;
        }

        public static final Boolean toBoolean(RESTServices.SingleCallResponse response) {
            return ValueConverter.StringToBoolean(response.asString());
        }

        public static final Stream<Boolean> toBoolean(RESTServices.MultipleCallResponse response) {
            return ValueConverter.StringToBoolean(response.asStreamOfString());
        }

        public static final String toString(RESTServices.SingleCallResponse response) {
            return response.asString();
        }

        public static final Stream<String> toString(RESTServices.MultipleCallResponse response) {
            return response.asStreamOfString();
        }
    }

    public static interface CharacterNodeDataType
    extends NodeDataType {
    }

    public static interface NodeDataType
    extends ServerDataType {
    }

    public static interface AtomicDataType
    extends ServerDataType {
    }

    public static interface ServerDataType {
    }
}

