/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.type.ArrayNodeExpr;
import com.marklogic.client.type.ArrayNodeSeqExpr;
import com.marklogic.client.type.AttributeNodeExpr;
import com.marklogic.client.type.AttributeNodeSeqExpr;
import com.marklogic.client.type.BooleanNodeExpr;
import com.marklogic.client.type.BooleanNodeSeqExpr;
import com.marklogic.client.type.CommentNodeExpr;
import com.marklogic.client.type.CommentNodeSeqExpr;
import com.marklogic.client.type.DocumentNodeExpr;
import com.marklogic.client.type.DocumentNodeSeqExpr;
import com.marklogic.client.type.ElementNodeExpr;
import com.marklogic.client.type.ElementNodeSeqExpr;
import com.marklogic.client.type.ItemExpr;
import com.marklogic.client.type.ItemSeqExpr;
import com.marklogic.client.type.NodeExpr;
import com.marklogic.client.type.NodeSeqExpr;
import com.marklogic.client.type.NullNodeExpr;
import com.marklogic.client.type.NullNodeSeqExpr;
import com.marklogic.client.type.NumberNodeExpr;
import com.marklogic.client.type.NumberNodeSeqExpr;
import com.marklogic.client.type.ObjectNodeExpr;
import com.marklogic.client.type.ObjectNodeSeqExpr;
import com.marklogic.client.type.ProcessingInstructionNodeExpr;
import com.marklogic.client.type.ProcessingInstructionNodeSeqExpr;
import com.marklogic.client.type.ServerExpression;
import com.marklogic.client.type.TextNodeExpr;
import com.marklogic.client.type.TextNodeSeqExpr;
import com.marklogic.client.type.XmlContentNodeSeqExpr;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;

public class BaseTypeImpl {
    private static String listToString(BaseArgImpl[] items) {
        if (items == null) {
            return "()";
        }
        return "(" + BaseTypeImpl.stringifyList(items) + ")";
    }

    private static StringBuilder exportASTList(StringBuilder strb, BaseArgImpl[] items) {
        BaseTypeImpl.astifyArray(strb, items);
        return strb;
    }

    private static String stringifyList(BaseArgImpl[] items) {
        if (items == null) {
            return null;
        }
        return Arrays.stream(items).map(item -> item == null ? "null" : item.toString()).reduce((priorString, argString) -> priorString + ", " + argString).get();
    }

    private static void astifyArray(StringBuilder strb, Object[] items) {
        strb.append("[");
        if (items != null && items.length > 0) {
            boolean isFirst = true;
            for (Object item : items) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    strb.append(", ");
                }
                BaseTypeImpl.astifyObject(strb, item);
            }
        }
        strb.append("]");
    }

    private static void astifyMap(StringBuilder strb, Map<?, ?> map) {
        strb.append("{");
        if (map != null && map.size() > 0) {
            boolean isFirst = true;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    strb.append(", ");
                }
                strb.append("\"");
                strb.append(entry.getKey().toString());
                strb.append("\"");
                strb.append(":");
                BaseTypeImpl.astifyObject(strb, entry.getValue());
            }
        }
        strb.append("}");
    }

    private static void astifyObject(StringBuilder strb, Object value) {
        if (value == null) {
            strb.append("null");
        } else if (value instanceof BaseArgImpl) {
            ((BaseArgImpl)value).exportAst(strb);
        } else if (value instanceof Number || value instanceof Boolean) {
            strb.append(value.toString());
        } else if (value instanceof Object[]) {
            BaseTypeImpl.astifyArray(strb, (Object[])value);
        } else if (value instanceof Map) {
            BaseTypeImpl.astifyMap(strb, (Map)value);
        } else {
            strb.append("\"");
            strb.append(value.toString());
            strb.append("\"");
        }
    }

    static BaseArgImpl[] convertList(Object[] items) {
        return BaseTypeImpl.convertList((Object[])items, BaseArgImpl.class);
    }

    static <T extends BaseArgImpl> T[] convertList(Object[] items, Class<T> as) {
        if (items == null) {
            return null;
        }
        if (as.isAssignableFrom(items.getClass().getComponentType())) {
            return (BaseArgImpl[])items;
        }
        return items == null || items.length == 0 ? null : (BaseArgImpl[])Arrays.stream(items).map(item -> {
            if (item != null && !as.isInstance(item)) {
                throw new IllegalArgumentException("expected " + as.getName() + " argument instead of " + item.getClass().getName());
            }
            return (BaseArgImpl)item;
        }).toArray(size -> (BaseArgImpl[])Array.newInstance(as, size));
    }

    static BaseArgImpl[] convertSequence(Object[] items) {
        return BaseTypeImpl.convertSequence((Object[])items, BaseArgImpl.class);
    }

    static <T extends BaseArgImpl> T[] convertSequence(Object[] items, Class<T> as) {
        if (items == null) {
            return null;
        }
        if (items.length == 0) {
            return (BaseArgImpl[])(as.isAssignableFrom(items.getClass().getComponentType()) ? items : Array.newInstance(as, 0));
        }
        BaseArgImpl[] optBuf = (BaseArgImpl[])Array.newInstance(as, items.length);
        ArrayList<BaseArgImpl> pessBuf = null;
        block4: for (int i = 0; i < items.length; ++i) {
            Object item = items[i];
            BaseArgImpl castItem = null;
            if (item != null) {
                if (!BaseListImpl.class.isInstance(item)) {
                    if (!as.isInstance(item)) {
                        throw new IllegalArgumentException("requires " + as.getName() + " argument instead of " + item.getClass().getName());
                    }
                    castItem = (BaseArgImpl)item;
                } else {
                    BaseArgImpl[] itemList = ((BaseListImpl)item).getArgsImpl();
                    switch (itemList.length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            BaseArgImpl firstListItem = itemList[0];
                            if (!as.isInstance(firstListItem)) {
                                throw new IllegalArgumentException("requires " + as.getName() + " first list item instead of " + firstListItem.getClass().getName());
                            }
                            castItem = firstListItem;
                            break;
                        }
                        default: {
                            if (pessBuf == null) {
                                pessBuf = new ArrayList<BaseArgImpl>(items.length + itemList.length);
                            }
                            for (int j = 0; j < itemList.length; ++j) {
                                BaseArgImpl listItem = itemList[j];
                                if (!as.isInstance(listItem)) {
                                    throw new IllegalArgumentException("requires " + as.getName() + " list item instead of " + listItem.getClass().getName());
                                }
                                pessBuf.add(listItem);
                            }
                            continue block4;
                        }
                    }
                }
            }
            if (pessBuf == null) {
                optBuf[i] = castItem;
                continue;
            }
            pessBuf.add(castItem);
        }
        return pessBuf == null ? optBuf : pessBuf.toArray((BaseArgImpl[])Array.newInstance(as, pessBuf.size()));
    }

    static class Literal
    implements BaseArgImpl {
        private Object value = null;

        Literal(Object value) {
            this.value = value;
        }

        @Override
        public StringBuilder exportAst(StringBuilder strb) {
            BaseTypeImpl.astifyObject(strb, this.value);
            return strb;
        }

        public String toString() {
            if (this.value == null) {
                return null;
            }
            return this.value.toString();
        }
    }

    static class XmlContentNodeSeqListImpl
    extends ItemSeqListImpl
    implements XmlContentNodeSeqExpr {
        XmlContentNodeSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class TextNodeCallImpl
    extends ItemCallImpl
    implements TextNodeExpr {
        TextNodeCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class TextNodeSeqListImpl
    extends ItemSeqListImpl
    implements TextNodeSeqExpr {
        TextNodeSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class ProcessingInstructionNodeCallImpl
    extends ItemCallImpl
    implements ProcessingInstructionNodeExpr {
        ProcessingInstructionNodeCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class ProcessingInstructionNodeSeqListImpl
    extends ItemSeqListImpl
    implements ProcessingInstructionNodeSeqExpr {
        ProcessingInstructionNodeSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class ObjectNodeCallImpl
    extends ItemCallImpl
    implements ObjectNodeExpr {
        ObjectNodeCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class ObjectNodeSeqListImpl
    extends ItemSeqListImpl
    implements ObjectNodeSeqExpr {
        ObjectNodeSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class NumberNodeCallImpl
    extends ItemCallImpl
    implements NumberNodeExpr {
        NumberNodeCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class NumberNodeSeqListImpl
    extends ItemSeqListImpl
    implements NumberNodeSeqExpr {
        NumberNodeSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class NullNodeCallImpl
    extends ItemCallImpl
    implements NullNodeExpr {
        NullNodeCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class NullNodeSeqListImpl
    extends ItemSeqListImpl
    implements NullNodeSeqExpr {
        NullNodeSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class ElementNodeCallImpl
    extends ItemCallImpl
    implements ElementNodeExpr {
        ElementNodeCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class ElementNodeSeqListImpl
    extends ItemSeqListImpl
    implements ElementNodeSeqExpr {
        ElementNodeSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class DocumentNodeCallImpl
    extends ItemCallImpl
    implements DocumentNodeExpr {
        DocumentNodeCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class DocumentNodeSeqListImpl
    extends ItemSeqListImpl
    implements DocumentNodeSeqExpr {
        DocumentNodeSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class CommentNodeCallImpl
    extends ItemCallImpl
    implements CommentNodeExpr {
        CommentNodeCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class CommentNodeSeqListImpl
    extends ItemSeqListImpl
    implements CommentNodeSeqExpr {
        CommentNodeSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class BooleanNodeCallImpl
    extends ItemCallImpl
    implements BooleanNodeExpr {
        BooleanNodeCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class BooleanNodeSeqListImpl
    extends ItemSeqListImpl
    implements BooleanNodeSeqExpr {
        BooleanNodeSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class AttributeNodeCallImpl
    extends ItemCallImpl
    implements AttributeNodeExpr {
        AttributeNodeCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class AttributeNodeSeqListImpl
    extends ItemSeqListImpl
    implements AttributeNodeSeqExpr {
        AttributeNodeSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class ArrayNodeCallImpl
    extends ItemCallImpl
    implements ArrayNodeExpr {
        ArrayNodeCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class ArrayNodeSeqListImpl
    extends ItemSeqListImpl
    implements ArrayNodeSeqExpr {
        ArrayNodeSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class NodeCallImpl
    extends ItemCallImpl
    implements NodeExpr {
        NodeCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class NodeSeqCallImpl
    extends ServerExpressionCallImpl
    implements NodeSeqExpr {
        NodeSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class NodeSeqListImpl
    extends ItemSeqListImpl
    implements NodeSeqExpr {
        NodeSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class ItemCallImpl
    extends ServerExpressionCallImpl
    implements ItemExpr {
        ItemCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class ItemSeqCallImpl
    extends ServerExpressionCallImpl
    implements ItemSeqExpr {
        ItemSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class ItemSeqListImpl
    extends ServerExpressionListImpl
    implements ItemSeqExpr {
        ItemSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class ServerExpressionCallImpl
    extends BaseCallImpl<BaseArgImpl>
    implements ServerExpression {
        ServerExpressionCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, BaseTypeImpl.convertList(fnArgs));
        }
    }

    static class ServerExpressionListImpl
    extends BaseListImpl<BaseArgImpl>
    implements ServerExpression {
        ServerExpressionListImpl(Object[] items) {
            this(items, false);
        }

        ServerExpressionListImpl(Object[] items, boolean flatten) {
            super(flatten ? BaseTypeImpl.convertSequence(items) : BaseTypeImpl.convertList(items));
        }
    }

    static class BaseChainImpl<T extends BaseArgImpl>
    implements BaseArgImpl {
        private BaseCallImpl<T>[] chain = null;

        protected BaseChainImpl(BaseChainImpl<T> prior, String fnPrefix, String fnName, T[] fnArgs) {
            BaseCallImpl call = new BaseCallImpl(fnPrefix, fnName, fnArgs);
            if (prior == null) {
                this.chain = (BaseCallImpl[])Array.newInstance(BaseCallImpl.class, 1);
                this.chain[0] = call;
            } else {
                BaseCallImpl<T>[] priorChain = prior.chain;
                this.chain = Arrays.copyOf(priorChain, priorChain.length + 1);
                this.chain[priorChain.length] = call;
            }
        }

        @Override
        public StringBuilder exportAst(StringBuilder strb) {
            strb.append("{\"ns\":\"op\", \"fn\":\"operators\", \"args\":");
            return BaseTypeImpl.exportASTList(strb, this.chain).append("}");
        }

        public String toString() {
            return Arrays.stream(this.chain).map(item -> item.toString()).reduce((priorString, argString) -> priorString + "." + argString).get();
        }
    }

    static class BaseCallImpl<T extends BaseArgImpl>
    extends BaseListImpl<T> {
        protected String fnPrefix = null;
        protected String fnName = null;

        protected BaseCallImpl(String fnPrefix, String fnName, T[] fnArgs) {
            super(fnArgs);
            this.fnPrefix = fnPrefix;
            this.fnName = fnName;
        }

        @Override
        public StringBuilder exportAst(StringBuilder strb) {
            strb.append("{\"ns\":\"").append(this.fnPrefix).append("\", \"fn\":\"").append(this.fnName).append("\", \"args\":");
            return super.exportAst(strb).append("}");
        }

        @Override
        public String toString() {
            return this.fnPrefix + ":" + this.fnName + super.toString();
        }
    }

    static class BaseListImpl<T extends BaseArgImpl>
    implements BaseArgImpl {
        protected T[] args;

        protected BaseListImpl(T[] args) {
            this.args = args;
        }

        public T[] getArgsImpl() {
            return this.args;
        }

        @Override
        public StringBuilder exportAst(StringBuilder strb) {
            return BaseTypeImpl.exportASTList(strb, this.args);
        }

        public String toString() {
            return BaseTypeImpl.listToString(this.args);
        }
    }

    static class BaseMapImpl
    implements BaseArgImpl {
        private Map<String, ?> arg;
        private Pattern quote = Pattern.compile("(\"|\\\\)");

        BaseMapImpl(Map<String, ?> arg) {
            this.arg = arg;
        }

        @Override
        public StringBuilder exportAst(StringBuilder strb) {
            strb.append("{");
            boolean isFirst = true;
            for (Map.Entry<String, ?> entry : this.arg.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    strb.append(", ");
                }
                strb.append("\"");
                strb.append(this.quote.matcher(entry.getKey()).replaceAll("\\$1"));
                strb.append("\":");
                Object value = entry.getValue();
                if (value == null) {
                    strb.append("null");
                    continue;
                }
                if (value instanceof BaseArgImpl) {
                    ((BaseArgImpl)value).exportAst(strb);
                    continue;
                }
                if (value instanceof Boolean) {
                    strb.append(((Boolean)value).toString());
                    continue;
                }
                if (value instanceof Number) {
                    strb.append(((Number)value).toString());
                    continue;
                }
                String valStr = value instanceof String ? (String)value : value.toString();
                strb.append("\"");
                strb.append(this.quote.matcher(valStr).replaceAll("\\$1"));
                strb.append("\"");
            }
            strb.append("}");
            return strb;
        }

        Map<String, ?> getMap() {
            return this.arg;
        }
    }

    public static interface ParamBinder {
        public String getParamQualifier();

        public String getParamValue();
    }

    public static interface BaseArgImpl {
        public StringBuilder exportAst(StringBuilder var1);
    }
}

