/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.FailedRequestException;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class HTTPKerberosAuthInterceptor
implements Interceptor {
    String host;
    Map<String, String> krbOptions;
    LoginContext loginContext;

    public HTTPKerberosAuthInterceptor(String host, Map<String, String> krbOptions) {
        this.host = host;
        this.krbOptions = krbOptions;
        try {
            this.buildSubjectCredentials();
        }
        catch (LoginException e) {
            throw new FailedRequestException(e.getMessage(), e);
        }
    }

    private void buildSubjectCredentials() throws LoginException {
        Subject subject = new Subject();
        LoginContext lc = new LoginContext("Krb5LoginContext", subject, null, this.krbOptions != null ? new KerberosLoginConfiguration(this.krbOptions) : new KerberosLoginConfiguration());
        lc.login();
        this.loginContext = lc;
    }

    private String getClientPrincipalName() {
        Set<Principal> principalSet = this.loginContext.getSubject().getPrincipals();
        if (principalSet.size() != 1) {
            throw new IllegalStateException("Only one principal is expected. Found 0 or more than one principals :" + principalSet);
        }
        return principalSet.iterator().next().getName();
    }

    private String buildAuthorizationHeader(String serverPrincipalName) throws LoginException {
        String clientPrincipal = this.getClientPrincipalName();
        CreateAuthorizationHeaderAction action = new CreateAuthorizationHeaderAction(clientPrincipal, serverPrincipalName);
        Set<Object> privateCreds = this.loginContext.getSubject().getPrivateCredentials();
        for (Object privateCred : privateCreds) {
            String serverPrincipalTicketName;
            if (!(privateCred instanceof KerberosTicket) || !(serverPrincipalTicketName = ((KerberosTicket)privateCred).getServer().getName()).startsWith("krbtgt") || ((KerberosTicket)privateCred).getEndTime().compareTo(new Date()) != -1) continue;
            this.buildSubjectCredentials();
            break;
        }
        Subject.doAs(this.loginContext.getSubject(), action);
        return action.getNegotiateToken();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String authValue;
        Request request = chain.request();
        try {
            authValue = "Negotiate " + this.buildAuthorizationHeader("HTTP/" + this.host);
        }
        catch (Exception e) {
            throw new FailedRequestException(e.getMessage(), e);
        }
        Request authenticatedRequest = request.newBuilder().header("Authorization", authValue).build();
        return chain.proceed(authenticatedRequest);
    }

    private static class CreateAuthorizationHeaderAction
    implements PrivilegedAction {
        String clientPrincipalName;
        String serverPrincipalName;
        private StringBuffer outputToken = new StringBuffer();

        private CreateAuthorizationHeaderAction(String clientPrincipalName, String serverPrincipalName) {
            this.clientPrincipalName = clientPrincipalName;
            this.serverPrincipalName = serverPrincipalName;
        }

        private String getNegotiateToken() {
            return this.outputToken.toString();
        }

        public Object run() {
            try {
                Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
                Oid krb5PrincipalNameType = new Oid("1.2.840.113554.1.2.2.1");
                GSSManager manager = GSSManager.getInstance();
                GSSName clientName = manager.createName(this.clientPrincipalName, krb5PrincipalNameType);
                GSSCredential clientCred = manager.createCredential(clientName, 28800, krb5Mechanism, 1);
                GSSName serverName = manager.createName(this.serverPrincipalName, krb5PrincipalNameType);
                GSSContext context = manager.createContext(serverName, krb5Mechanism, clientCred, 0);
                byte[] inToken = new byte[]{};
                byte[] outToken = context.initSecContext(inToken, 0, inToken.length);
                context.requestMutualAuth(true);
                this.outputToken.append(new String(Base64.getEncoder().encode(outToken)));
                context.dispose();
            }
            catch (GSSException exception) {
                throw new FailedRequestException(exception.getMessage(), exception);
            }
            return null;
        }
    }

    private class KerberosLoginConfiguration
    extends Configuration {
        Map<String, String> krbOptions = null;

        public KerberosLoginConfiguration() {
        }

        KerberosLoginConfiguration(Map<String, String> krbOptions) {
            this.krbOptions = krbOptions;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, this.krbOptions)};
        }
    }
}

