/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.BytesHandle;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.FileHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.InputSourceHandle;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.JacksonParserHandle;
import com.marklogic.client.io.OutputStreamHandle;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.ReaderHandle;
import com.marklogic.client.io.SourceHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.XMLEventReaderHandle;
import com.marklogic.client.io.XMLStreamReaderHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.BinaryReadHandle;
import com.marklogic.client.io.marker.BinaryWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NodeConverter {
    private static ObjectMapper mapper;
    private static DocumentBuilderFactory documentBuilderFactory;
    private static XMLInputFactory xmlInputFactory;

    private NodeConverter() {
    }

    private static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        return mapper;
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        if (documentBuilderFactory == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            documentBuilderFactory = factory;
        }
        return documentBuilderFactory;
    }

    private static XMLInputFactory getXMLInputFactory() {
        if (xmlInputFactory == null) {
            xmlInputFactory = XMLInputFactory.newFactory();
        }
        return xmlInputFactory;
    }

    public static BinaryWriteHandle BinaryWriter(BinaryWriteHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.BINARY);
    }

    public static Stream<BinaryWriteHandle> BinaryWriter(Stream<? extends BinaryWriteHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::BinaryWriter);
    }

    public static BinaryReadHandle BinaryReader(BinaryReadHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.BINARY);
    }

    public static Stream<BinaryReadHandle> BinaryReader(Stream<? extends BinaryReadHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::BinaryReader);
    }

    public static JSONWriteHandle JSONWriter(JSONWriteHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.JSON);
    }

    public static Stream<JSONWriteHandle> JSONWriter(Stream<? extends JSONWriteHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::JSONWriter);
    }

    public static JSONReadHandle JSONReader(JSONReadHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.JSON);
    }

    public static Stream<JSONReadHandle> JSONReader(Stream<? extends JSONReadHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::JSONReader);
    }

    public static TextWriteHandle TextWriter(TextWriteHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.TEXT);
    }

    public static Stream<TextWriteHandle> TextWriter(Stream<? extends TextWriteHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::TextWriter);
    }

    public static TextReadHandle TextReader(TextReadHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.TEXT);
    }

    public static Stream<TextReadHandle> TextReader(Stream<? extends TextReadHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::TextReader);
    }

    public static XMLWriteHandle XMLWriter(XMLWriteHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.XML);
    }

    public static Stream<XMLWriteHandle> XMLWriter(Stream<? extends XMLWriteHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::XMLWriter);
    }

    public static XMLReadHandle XMLReader(XMLReadHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.XML);
    }

    public static Stream<XMLReadHandle> XMLReader(Stream<? extends XMLReadHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::XMLReader);
    }

    public static <T> T withFormat(T handle, Format format) {
        if (handle != null) {
            if (!(handle instanceof BaseHandle)) {
                throw new IllegalArgumentException("cannot set format on handle of " + handle.getClass().getName());
            }
            if (format != null) {
                ((BaseHandle)handle).setFormat(format);
            }
        }
        return handle;
    }

    public static <T extends AbstractWriteHandle> Stream<T> streamWithFormat(Stream<T> handles, Format format) {
        if (handles == null || format == null) {
            return handles;
        }
        Formatter formatter = new Formatter(format);
        return handles.map(formatter);
    }

    public static AbstractWriteHandle ObjectToHandle(Object value, Format format) {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return NodeConverter.BytesObjectToHandle(value, format);
        }
        if (value instanceof File) {
            return NodeConverter.FileObjectToHandle(value, format);
        }
        if (value instanceof InputStream) {
            return NodeConverter.InputStreamObjectToHandle(value, format);
        }
        if (value instanceof Reader) {
            return NodeConverter.ReaderObjectToHandle(value, format);
        }
        if (value instanceof String) {
            return NodeConverter.StringObjectToHandle(value, format);
        }
        throw new IllegalArgumentException("unsupported value argument " + value.getClass().getCanonicalName() + ", expected byte[], File, InputStream, Reader, or String");
    }

    private static BytesHandle BytesObjectToHandle(Object value, Format format) {
        return NodeConverter.BytesToHandle((byte[])value).withFormat(format);
    }

    private static FileHandle FileObjectToHandle(Object value, Format format) {
        return NodeConverter.FileToHandle((File)value).withFormat(format);
    }

    private static InputStreamHandle InputStreamObjectToHandle(Object value, Format format) {
        return NodeConverter.InputStreamToHandle((InputStream)value).withFormat(format);
    }

    private static ReaderHandle ReaderObjectToHandle(Object value, Format format) {
        return NodeConverter.ReaderToHandle((Reader)value).withFormat(format);
    }

    private static StringHandle StringObjectToHandle(Object value, Format format) {
        return NodeConverter.StringToHandle((String)value).withFormat(format);
    }

    public static Stream<? extends AbstractWriteHandle> ObjectToHandle(Stream<?> values, Format format) {
        if (values == null) {
            return null;
        }
        ObjectHandler handler = new ObjectHandler(format);
        return values.map(handler::toHandle);
    }

    public static BytesHandle BytesToHandle(byte[] value) {
        return value == null ? null : new BytesHandle(value);
    }

    public static Stream<BytesHandle> BytesToHandle(Stream<? extends byte[]> values) {
        return values == null ? null : values.map(NodeConverter::BytesToHandle);
    }

    public static DOMHandle DocumentToHandle(Document value) {
        return value == null ? null : new DOMHandle(value);
    }

    public static Stream<DOMHandle> DocumentToHandle(Stream<? extends Document> values) {
        return values == null ? null : values.map(NodeConverter::DocumentToHandle);
    }

    public static FileHandle FileToHandle(File value) {
        return value == null ? null : new FileHandle(value);
    }

    public static Stream<FileHandle> FileToHandle(Stream<? extends File> values) {
        return values == null ? null : values.map(NodeConverter::FileToHandle);
    }

    public static InputStreamHandle InputStreamToHandle(InputStream value) {
        return value == null ? null : new InputStreamHandle(value);
    }

    public static Stream<InputStreamHandle> InputStreamToHandle(Stream<? extends InputStream> values) {
        return values == null ? null : values.map(NodeConverter::InputStreamToHandle);
    }

    public static InputSourceHandle InputSourceToHandle(InputSource value) {
        return value == null ? null : new InputSourceHandle(value);
    }

    public static Stream<InputSourceHandle> InputSourceToHandle(Stream<? extends InputSource> values) {
        return values == null ? null : values.map(NodeConverter::InputSourceToHandle);
    }

    public static JacksonHandle JsonNodeToHandle(JsonNode value) {
        return value == null ? null : new JacksonHandle(value);
    }

    public static Stream<JacksonHandle> JsonNodeToHandle(Stream<? extends JsonNode> values) {
        return values == null ? null : values.map(NodeConverter::JsonNodeToHandle);
    }

    public static JacksonParserHandle JsonParserToHandle(JsonParser value) {
        if (value == null) {
            return null;
        }
        JacksonParserHandle handle = new JacksonParserHandle();
        handle.set(value);
        return handle;
    }

    public static Stream<JacksonParserHandle> JsonParserToHandle(Stream<? extends JsonParser> values) {
        return values == null ? null : values.map(NodeConverter::JsonParserToHandle);
    }

    public static ArrayNode ReaderToArrayNode(Reader value) {
        try {
            return value == null ? null : (ArrayNode)NodeConverter.getMapper().readValue(value, ArrayNode.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<ArrayNode> ReaderToArrayNode(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToArrayNode);
    }

    public static JsonNode ReaderToJsonNode(Reader value) {
        try {
            return value == null ? null : NodeConverter.getMapper().readTree(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<JsonNode> ReaderToJsonNode(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToJsonNode);
    }

    public static ObjectNode ReaderToObjectNode(Reader value) {
        try {
            return value == null ? null : (ObjectNode)NodeConverter.getMapper().readValue(value, ObjectNode.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<ObjectNode> ReaderToObjectNode(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToObjectNode);
    }

    public static JsonParser ReaderToJsonParser(Reader value) {
        try {
            return value == null ? null : NodeConverter.getMapper().getFactory().createParser(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<JsonParser> ReaderToJsonParser(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToJsonParser);
    }

    public static Document InputStreamToDocument(InputStream inputStream) {
        try {
            return inputStream == null ? null : NodeConverter.getDocumentBuilderFactory().newDocumentBuilder().parse(inputStream);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<Document> InputStreamToDocument(Stream<? extends InputStream> values) {
        return values == null ? null : values.map(NodeConverter::InputStreamToDocument);
    }

    public static File InputStreamToFile(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            Path tempFile = Files.createTempFile("tmp", null, new FileAttribute[0]);
            Files.copy(inputStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
            return tempFile.toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<File> InputStreamToFile(Stream<? extends InputStream> values) {
        return values == null ? null : values.map(NodeConverter::InputStreamToFile);
    }

    public static InputSource ReaderToInputSource(Reader reader) {
        return reader == null ? null : new InputSource(reader);
    }

    public static Stream<InputSource> ReaderToInputSource(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToInputSource);
    }

    public static Source ReaderToSource(Reader reader) {
        return reader == null ? null : new StreamSource(reader);
    }

    public static Stream<Source> ReaderToSource(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToSource);
    }

    public static XMLEventReader ReaderToXMLEventReader(Reader reader) {
        try {
            return reader == null ? null : NodeConverter.getXMLInputFactory().createXMLEventReader(reader);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<XMLEventReader> ReaderToXMLEventReader(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToXMLEventReader);
    }

    public static XMLStreamReader ReaderToXMLStreamReader(Reader reader) {
        try {
            return reader == null ? null : NodeConverter.getXMLInputFactory().createXMLStreamReader(reader);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<XMLStreamReader> ReaderToXMLStreamReader(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToXMLStreamReader);
    }

    public static OutputStreamHandle OutputStreamSenderToHandle(OutputStreamSender value) {
        return value == null ? null : new OutputStreamHandle(value);
    }

    public static Stream<OutputStreamHandle> OutputStreamSenderToHandle(Stream<? extends OutputStreamSender> values) {
        return values == null ? null : values.map(NodeConverter::OutputStreamSenderToHandle);
    }

    public static ReaderHandle ReaderToHandle(Reader value) {
        return value == null ? null : new ReaderHandle(value);
    }

    public static Stream<ReaderHandle> ReaderToHandle(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToHandle);
    }

    public static StringHandle StringToHandle(String value) {
        return value == null ? null : new StringHandle(value);
    }

    public static Stream<StringHandle> StringToHandle(Stream<? extends String> values) {
        return values == null ? null : values.map(NodeConverter::StringToHandle);
    }

    public static SourceHandle SourceToHandle(Source value) {
        return value == null ? null : new SourceHandle(value);
    }

    public static Stream<SourceHandle> SourceToHandle(Stream<? extends Source> values) {
        return values == null ? null : values.map(NodeConverter::SourceToHandle);
    }

    public static XMLEventReaderHandle XMLEventReaderToHandle(XMLEventReader value) {
        return value == null ? null : new XMLEventReaderHandle(value);
    }

    public static Stream<XMLEventReaderHandle> XMLEventReaderToHandle(Stream<? extends XMLEventReader> values) {
        return values == null ? null : values.map(NodeConverter::XMLEventReaderToHandle);
    }

    public static XMLStreamReaderHandle XMLStreamReaderToHandle(XMLStreamReader value) {
        return value == null ? null : new XMLStreamReaderHandle(value);
    }

    public static Stream<XMLStreamReaderHandle> XMLStreamReaderToHandle(Stream<? extends XMLStreamReader> values) {
        return values == null ? null : values.map(NodeConverter::XMLStreamReaderToHandle);
    }

    public static byte[] InputStreamToBytes(InputStream inputStream) {
        try {
            if (inputStream == null) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int byteCount = -1;
            while ((byteCount = inputStream.read(buf)) != -1) {
                out.write(buf, 0, byteCount);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Reader InputStreamToReader(InputStream inputStream) {
        try {
            if (inputStream == null) {
                return null;
            }
            return new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String InputStreamToString(InputStream inputStream) {
        return NodeConverter.ReaderToString(NodeConverter.InputStreamToReader(inputStream));
    }

    public static String ReaderToString(Reader reader) {
        try {
            if (reader == null) {
                return null;
            }
            StringBuilder bldr = new StringBuilder();
            char[] buf = new char[8192];
            int charCount = -1;
            while ((charCount = reader.read(buf)) != -1) {
                bldr.append(buf, 0, charCount);
            }
            return bldr.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode handleToJsonNode(JSONWriteHandle jsonHandle) {
        if (jsonHandle == null) {
            return null;
        }
        if (!(jsonHandle instanceof ContentHandle)) {
            throw new IllegalArgumentException("JSONWriteHandle must implement ContentHandle: " + jsonHandle.getClass().getCanonicalName());
        }
        Object jsonTree = ((ContentHandle)((Object)jsonHandle)).get();
        if (jsonTree == null || jsonTree instanceof JsonNode) {
            return (JsonNode)jsonTree;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            if (jsonTree instanceof byte[]) {
                return mapper.readTree((byte[])jsonTree);
            }
            if (jsonTree instanceof File) {
                return mapper.readTree((File)jsonTree);
            }
            if (jsonTree instanceof JsonParser) {
                return (JsonNode)mapper.readTree((JsonParser)jsonTree);
            }
            if (jsonTree instanceof InputStream) {
                return mapper.readTree((InputStream)jsonTree);
            }
            if (jsonTree instanceof Reader) {
                return mapper.readTree((Reader)jsonTree);
            }
            if (jsonTree instanceof String) {
                return mapper.readTree((String)jsonTree);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalArgumentException("Could not convert JSON of class: " + jsonTree.getClass().getCanonicalName() + "\n" + jsonTree.toString());
    }

    private static class ObjectHandler {
        private Format format;
        private BiFunction<Object, Format, ? extends AbstractWriteHandle> toHandler = null;
        private Class<?> itemType = null;

        ObjectHandler(Format format) {
            this.format = format;
        }

        AbstractWriteHandle toHandle(Object value) {
            if (value == null) {
                return null;
            }
            if (this.toHandler == null || this.itemType == null) {
                this.init(value);
            } else if (!this.itemType.isInstance(value)) {
                throw new IllegalArgumentException("inconsistent stream - expected instance of " + this.itemType.getSimpleName() + " but received " + value.getClass().getCanonicalName());
            }
            return this.toHandler.apply(value, this.format);
        }

        private synchronized void init(Object value) {
            if (value instanceof byte[]) {
                this.toHandler = (x$0, x$1) -> NodeConverter.BytesObjectToHandle(x$0, x$1);
                this.itemType = byte[].class;
            } else if (value instanceof File) {
                this.toHandler = (x$0, x$1) -> NodeConverter.FileObjectToHandle(x$0, x$1);
                this.itemType = File.class;
            } else if (value instanceof InputStream) {
                this.toHandler = (x$0, x$1) -> NodeConverter.InputStreamObjectToHandle(x$0, x$1);
                this.itemType = InputStream.class;
            } else if (value instanceof Reader) {
                this.toHandler = (x$0, x$1) -> NodeConverter.ReaderObjectToHandle(x$0, x$1);
                this.itemType = Reader.class;
            } else if (value instanceof String) {
                this.toHandler = (x$0, x$1) -> NodeConverter.StringObjectToHandle(x$0, x$1);
                this.itemType = String.class;
            } else {
                throw new IllegalArgumentException("unsupported stream item argument " + value.getClass().getCanonicalName() + ", expected byte[], File, InputStream, Reader, or String");
            }
        }
    }

    private static class Formatter<T extends AbstractWriteHandle>
    implements Function<T, T> {
        private Format format;

        Formatter(Format format) {
            this.format = format;
        }

        @Override
        public T apply(T handle) {
            return (T)((AbstractWriteHandle)NodeConverter.withFormat(handle, this.format));
        }
    }
}

