/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.MarkLogicBindingException;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.ResourceNotFoundException;
import com.marklogic.client.Transaction;
import com.marklogic.client.document.DocumentPage;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.document.JSONDocumentManager;
import com.marklogic.client.impl.DocumentManagerImpl;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.PojoPageImpl;
import com.marklogic.client.impl.PojoQueryBuilderImpl;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.JacksonDatabindHandle;
import com.marklogic.client.io.SearchHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.client.io.marker.SearchReadHandle;
import com.marklogic.client.pojo.PojoPage;
import com.marklogic.client.pojo.PojoQueryBuilder;
import com.marklogic.client.pojo.PojoQueryDefinition;
import com.marklogic.client.pojo.PojoRepository;
import com.marklogic.client.pojo.annotation.Id;
import com.marklogic.client.query.DeleteQueryDefinition;
import com.marklogic.client.query.QueryManager;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PojoRepositoryImpl<T, ID extends Serializable>
implements PojoRepository<T, ID> {
    private static final Pattern getterPattern;
    private final String EXTENSION = ".json";
    private DatabaseClient client;
    private Class<T> entityClass;
    private Class<ID> idClass;
    private JSONDocumentManager docMgr;
    private PojoQueryBuilder<T> qb;
    private Method idMethod;
    private Field idProperty;
    private String idPropertyName;
    private static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static SimpleDateFormat simpleDateFormat8601;
    private ObjectMapper objectMapper = new ObjectMapper().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).setDateFormat((DateFormat)simpleDateFormat8601).enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_OBJECT);

    PojoRepositoryImpl(DatabaseClient client, Class<T> entityClass) {
        this.client = client;
        this.entityClass = entityClass;
        this.idClass = null;
        this.docMgr = client.newJSONDocumentManager();
        this.qb = new PojoQueryBuilderImpl<T>(entityClass);
    }

    PojoRepositoryImpl(DatabaseClient client, Class<T> entityClass, Class<ID> idClass) {
        this(client, entityClass);
        this.idClass = idClass;
        if (this.idMethod == null && this.idProperty == null) {
            throw new IllegalArgumentException("Your class " + entityClass.getName() + " does not have a method or field annotated with com.marklogic.client.pojo.annotation.Id");
        }
    }

    @Override
    public void write(T entity) {
        this.write(entity, (Transaction)null, (String[])null);
    }

    @Override
    public void write(T entity, String ... collections) {
        this.write(entity, (Transaction)null, collections);
    }

    @Override
    public void write(T entity, Transaction transaction) {
        this.write(entity, transaction, (String[])null);
    }

    @Override
    public void write(T entity, Transaction transaction, String ... collections) {
        if (entity == null) {
            return;
        }
        JacksonDatabindHandle<T> contentHandle = new JacksonDatabindHandle<T>(entity);
        contentHandle.setMapper(this.objectMapper);
        DocumentMetadataHandle metadataHandle = new DocumentMetadataHandle();
        metadataHandle = metadataHandle.withCollections(this.entityClass.getName());
        if (collections != null && collections.length > 0) {
            metadataHandle = metadataHandle.withCollections(collections);
        }
        DocumentWriteSet writeSet = this.docMgr.newWriteSet();
        writeSet.add(this.getDocumentUri(entity), (DocumentMetadataWriteHandle)metadataHandle, contentHandle);
        try {
            this.docMgr.write(writeSet, transaction);
        }
        catch (MarkLogicIOException e) {
            this.checkForEmptyBeans(e);
            throw e;
        }
    }

    private void checkForEmptyBeans(Throwable e) {
        Throwable cause = e.getCause();
        if (cause != null) {
            if (cause instanceof JsonMappingException && cause.getMessage() != null && cause.getMessage().contains("SerializationFeature.FAIL_ON_EMPTY_BEANS")) {
                throw new MarkLogicBindingException("Each of your pojo beans and descendent beans must have public fields or paired get/set methods", cause);
            }
            this.checkForEmptyBeans(cause);
        }
    }

    @Override
    public boolean exists(ID id) {
        return this.docMgr.exists(this.createUri(id)) != null;
    }

    @Override
    public boolean exists(ID id, Transaction transaction) {
        return this.docMgr.exists(this.createUri(id), transaction) != null;
    }

    @Override
    public long count() {
        return this.count((PojoQueryDefinition)null, null);
    }

    @Override
    public long count(String ... collections) {
        return this.count(collections, (Transaction)null);
    }

    @Override
    public long count(PojoQueryDefinition query) {
        return this.count(query, null);
    }

    @Override
    public long count(Transaction transaction) {
        return this.count((PojoQueryDefinition)null, transaction);
    }

    @Override
    public long count(String[] collections, Transaction transaction) {
        if (collections != null && collections.length > 0 && (collections.length > 1 || collections[0] != null)) {
            return this.count(this.qb.collection(collections), transaction);
        }
        return this.count((PojoQueryDefinition)null, transaction);
    }

    @Override
    public long count(PojoQueryDefinition query, Transaction transaction) {
        long pageLength = this.getPageLength();
        this.setPageLength(0L);
        PojoPage<T> page = this.search(query, 1L, transaction);
        this.setPageLength(pageLength);
        return page.getTotalSize();
    }

    @Override
    public void delete(ID ... ids) {
        this.delete((Serializable[])ids, null);
    }

    @Override
    public void delete(ID[] ids, Transaction transaction) {
        for (ID id : ids) {
            this.docMgr.delete(this.createUri(id), transaction);
        }
    }

    @Override
    public void deleteAll() {
        this.deleteAll(null);
    }

    @Override
    public void deleteAll(Transaction transaction) {
        QueryManager queryMgr = this.client.newQueryManager();
        DeleteQueryDefinition deleteQuery = queryMgr.newDeleteDefinition();
        deleteQuery.setCollections(this.entityClass.getName());
        queryMgr.delete(deleteQuery, transaction);
    }

    @Override
    public T read(ID id) {
        return this.read(id, null);
    }

    @Override
    public T read(ID id, Transaction transaction) {
        ArrayList<ID> ids = new ArrayList<ID>();
        ids.add(id);
        T page = this.read((ID)ids.toArray(new Serializable[0]), transaction);
        if (page == null || !page.hasNext()) {
            throw new ResourceNotFoundException("Could not find document of type " + this.entityClass.getName() + " with id " + id);
        }
        return page.next();
    }

    @Override
    public PojoPage<T> read(ID[] ids) {
        return this.read((ID)ids, null);
    }

    @Override
    public PojoPage<T> read(ID[] ids, Transaction transaction) {
        ArrayList<String> uris = new ArrayList<String>();
        for (ID id : ids) {
            uris.add(this.createUri(id));
        }
        DocumentPage docPage = this.docMgr.read(transaction, uris.toArray(new String[0]));
        PojoPageImpl<T> pojoPage = new PojoPageImpl<T>(docPage, this.entityClass);
        return pojoPage;
    }

    @Override
    public PojoPage<T> readAll(long start) {
        return this.search(null, start, null, null);
    }

    @Override
    public PojoPage<T> readAll(long start, Transaction transaction) {
        return this.search(null, start, null, transaction);
    }

    @Override
    public PojoPage<T> search(long start, String ... collections) {
        return this.search(this.qb.collection(collections), start, null, null);
    }

    @Override
    public PojoPage<T> search(long start, Transaction transaction, String ... collections) {
        return this.search(this.qb.collection(collections), start, null, transaction);
    }

    @Override
    public PojoPage<T> search(PojoQueryDefinition query, long start) {
        return this.search(query, start, null, null);
    }

    @Override
    public PojoPage<T> search(PojoQueryDefinition query, long start, Transaction transaction) {
        return this.search(query, start, null, transaction);
    }

    @Override
    public PojoPage<T> search(PojoQueryDefinition query, long start, SearchReadHandle searchHandle) {
        return this.search(query, start, searchHandle, null);
    }

    @Override
    public PojoPage<T> search(PojoQueryDefinition query, long start, SearchReadHandle searchHandle, Transaction transaction) {
        if (searchHandle != null) {
            HandleAccessor.checkHandle(searchHandle, "search");
            if (searchHandle instanceof SearchHandle) {
                SearchHandle responseHandle = (SearchHandle)searchHandle;
                if (this.docMgr instanceof DocumentManagerImpl) {
                    responseHandle.setHandleRegistry(((DocumentManagerImpl)((Object)this.docMgr)).getHandleRegistry());
                }
                responseHandle.setQueryCriteria(query);
            }
        }
        DocumentPage docPage = this.docMgr.search(this.wrapQuery(query), start, searchHandle, transaction);
        PojoPageImpl<T> pojoPage = new PojoPageImpl<T>(docPage, this.entityClass);
        return pojoPage;
    }

    @Override
    public PojoQueryBuilder<T> getQueryBuilder() {
        return this.qb;
    }

    @Override
    public long getPageLength() {
        return this.docMgr.getPageLength();
    }

    @Override
    public void setPageLength(long length) {
        this.docMgr.setPageLength(length);
    }

    public QueryManager.QueryView getSearchView() {
        return this.docMgr.getSearchView();
    }

    public void setSearchView(QueryManager.QueryView view) {
        this.docMgr.setSearchView(view);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    private PojoQueryDefinition wrapQuery(PojoQueryDefinition query) {
        if (query == null) {
            return this.qb.collection(this.entityClass.getName());
        }
        List<String> collections = Arrays.asList(query.getCollections());
        HashSet<String> collectionSet = new HashSet<String>(collections);
        collectionSet.add(this.entityClass.getName());
        query.setCollections(collectionSet.toArray(new String[0]));
        return query;
    }

    @Override
    public String getDocumentUri(T entity) {
        return this.createUri(this.getId(entity));
    }

    private String createUri(ID id) {
        if (id == null) {
            throw new IllegalStateException("id cannot be null");
        }
        try {
            return this.entityClass.getName() + "/" + URLEncoder.encode(id.toString(), "UTF-8") + ".json";
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicInternalException(e);
        }
    }

    private void findId() {
        if (this.idMethod == null && this.idProperty == null) {
            SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
            JavaType javaType = serializationConfig.constructType(this.entityClass);
            BeanDescription beanDescription = serializationConfig.introspect(javaType);
            List list = beanDescription.findProperties();
            for (BeanPropertyDefinition property : list) {
                Method setter;
                Field field;
                if (property.hasField() && (field = property.getField().getAnnotated()).getAnnotation(Id.class) != null) {
                    this.idPropertyName = property.getName();
                    this.idProperty = field;
                    break;
                }
                if (!property.hasGetter()) continue;
                Method getter = property.getGetter().getAnnotated();
                if (getter.getAnnotation(Id.class) != null) {
                    this.idPropertyName = property.getName();
                    this.idMethod = getter;
                    break;
                }
                if (!property.hasSetter() || (setter = property.getSetter().getAnnotated()).getAnnotation(Id.class) == null) continue;
                this.idPropertyName = property.getName();
                this.idMethod = getter;
                break;
            }
        }
        if (this.idMethod == null && this.idProperty == null) {
            for (Method method : this.entityClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Id.class)) continue;
                Class<?>[] parameters = method.getParameterTypes();
                if (!Modifier.isPublic(method.getModifiers())) {
                    throw new IllegalStateException("Your method, " + method.getName() + ", annotated with com.marklogic.client.pojo.annotation.Id " + " must be public");
                }
                if (parameters == null || parameters.length == 0) {
                    Matcher matcher = getterPattern.matcher(method.getName());
                    if (matcher.matches()) {
                        this.idPropertyName = matcher.group(2).toLowerCase() + matcher.group(3);
                        this.idMethod = method;
                        break;
                    }
                    throw new IllegalStateException("Your no-args method, " + method.getName() + ", annotated with com.marklogic.client.pojo.annotation.Id " + " must be a proper getter method and begin with \"get\" or \"is\"");
                }
                Matcher getterMatcher = getterPattern.matcher(method.getName());
                if (getterMatcher.matches()) {
                    throw new IllegalStateException("Your getter method, " + method.getName() + ", annotated with com.marklogic.client.pojo.annotation.Id " + " must not require any arguments");
                }
                if (method.getName().startsWith("set")) {
                    throw new MarkLogicInternalException("Your setter method, " + method.getName() + ", annotated with com.marklogic.client.pojo.annotation.Id " + "was not found by Jackson for some reason.  Please report this to " + "MarkLogic support.");
                }
                throw new IllegalStateException("Your setter method, " + method.getName() + ", annotated with com.marklogic.client.pojo.annotation.Id " + " must be a proper setter method (beginning with \"set\")");
            }
            if (this.idMethod == null) {
                for (AccessibleObject accessibleObject : this.entityClass.getDeclaredFields()) {
                    if (!accessibleObject.isAnnotationPresent(Id.class)) continue;
                    if (!Modifier.isPublic(((Field)accessibleObject).getModifiers())) {
                        throw new IllegalStateException("Your field, " + ((Field)accessibleObject).getName() + ", annotated with com.marklogic.client.pojo.annotation.Id " + " must be public");
                    }
                    this.idProperty = accessibleObject;
                    break;
                }
            }
        }
    }

    @Override
    public ID getId(T entity) {
        this.findId();
        if (this.idMethod != null) {
            try {
                return (ID)((Serializable)this.idMethod.invoke(entity, new Object[0]));
            }
            catch (Exception e) {
                throw new IllegalStateException("Error invoking " + this.entityClass.getName() + " method " + this.idMethod.getName(), e);
            }
        }
        if (this.idProperty != null) {
            try {
                return (ID)((Serializable)this.idProperty.get(entity));
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving " + this.entityClass.getName() + " field " + this.idProperty.getName(), e);
            }
        }
        throw new IllegalArgumentException("Your class " + this.entityClass.getName() + " does not have a method or field annotated with com.marklogic.client.pojo.annotation.Id");
    }

    static {
        block2: {
            getterPattern = Pattern.compile("^(get|is)(.)(.*)");
            try {
                simpleDateFormat8601 = new SimpleDateFormat(ISO_8601_FORMAT);
            }
            catch (IllegalArgumentException e) {
                if (!"Illegal pattern character 'X'".equals(e.getMessage())) break block2;
                simpleDateFormat8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            }
        }
        simpleDateFormat8601.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

