/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BinaryReadHandle;
import com.marklogic.client.io.marker.BinaryWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.GenericReadHandle;
import com.marklogic.client.io.marker.GenericWriteHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.QuadsWriteHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.TriplesReadHandle;
import com.marklogic.client.io.marker.TriplesWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.File;

public class FileHandle
extends BaseHandle<File, File>
implements ContentHandle<File>,
BinaryReadHandle,
BinaryWriteHandle,
GenericReadHandle,
GenericWriteHandle,
JSONReadHandle,
JSONWriteHandle,
TextReadHandle,
TextWriteHandle,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle,
CtsQueryWriteHandle,
QuadsWriteHandle,
TriplesReadHandle,
TriplesWriteHandle {
    private File content;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{File.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return File.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                FileHandle handle = this.isHandled(type) ? new FileHandle() : null;
                return handle;
            }
        };
    }

    public FileHandle() {
        this.setResendable(true);
    }

    public FileHandle(File content) {
        this();
        this.set(content);
    }

    @Override
    public File get() {
        return this.content;
    }

    @Override
    public void set(File content) {
        this.content = content;
    }

    public FileHandle with(File content) {
        this.set(content);
        return this;
    }

    public FileHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    public FileHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    protected Class<File> receiveAs() {
        return File.class;
    }

    @Override
    protected void receiveContent(File content) {
        this.content = content;
    }

    @Override
    protected File sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No file to write");
        }
        return this.content;
    }
}

